@extends ('core.layouts.app')

@section ('title', 'Work Order Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Work Order Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.work_orders.partials.work-order-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="card">
            <div class="card-header">
                <a href="#" class="btn btn-primary btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                    <i class="fa fa-pencil" aria-hidden="true"></i> <b>Status</b>
                </a>
            </div>
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered table-sm">
                                @php
                                    $details = [ 
                                        '#Order No.' => $work_order->tid_code,
                                        'Customer' => @$work_order->customer->name,
                                        'Note' => $work_order->note,
                                        'Date' => dateFormat($work_order->date),
                                        'Due Date' => dateFormat($work_order->due_date),
                                        'Invoice' => @$work_order->invoice->tid_code,
                                        'Approval' => $work_order->status,
                                        'Review Note' => $work_order->status_note,
                                    ];
                                @endphp
                                @foreach ($details as $key => $val)
                                    <tr>
                                        <th>{{ $key }}</th>
                                        @if ($key == 'Approval')
                                            <td><b>{{ $val }}</b></td>
                                        @else
                                            <td>{{ $val }}</td>
                                        @endif                                        
                                    </tr>
                                @endforeach
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table table-bordered table-sm">
                                @php
                                    $details = [ 
                                        'Tax Rate (%)' => +$work_order->tax_rate,
                                        'Taxable Amount' => numberFormat($work_order->taxable), 
                                        'Subtotal' => numberFormat($work_order->subtotal),
                                        'Tax' => numberFormat($work_order->tax), 
                                        'Grand Total' => numberFormat($work_order->total), 
                                    ];
                                @endphp
                                @foreach ($details as $key => $val)
                                    <tr>
                                        <th>{{ $key }}</th>
                                        <td>{{ $val }}</td>
                                    </tr>
                                @endforeach
                            </table>
                        </div>
                    </div>
                            
                    <!-- work order items -->
                    <table class="table tfr my_stripe_single pb-1">
                        <thead>
                            <tr class="item_header bg-gradient-directional-blue white">
                                <th width="8%">#</th>
                                <th width="35%">Item Name</th>
                                <th >UoM</th>
                                <th width="5%">Qty</th>
                                <th>Unit Price</th>
                                <th>VAT</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($work_order->items as $item)
                                <tr>
                                    <td>{{ $item->num }}</td>                                            
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->uom }}</td>
                                    <td>{{ +$item->qty }}</td>
                                    <td>{{ numberFormat($item->subtotal) }}</td>
                                    <td>{{ numberFormat($item->tax) }}</td>
                                    <td>{{ numberFormat($item->total) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('focus.work_orders.modals.status_modal')
@endsection
