{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" }},
        date: {format: "{{config('core.user_date_format')}}", autoHide: true},
        autocomplete: {
            source: function(request, response) {
                // stock product
                let term = request.term;
                let url = "{{ route('biller.products.quote_product_search') }}";
                let data = {
                    keyword: term, 
                    price_customer_id: $('#price_customer').val(),
                };
                // maintenance service product 
                const docType = @json(request('doc_type'));
                if (docType == 'maintenance') {
                    url = "{{ route('biller.taskschedules.quote_product_search') }}";
                    data.customer_id = $('#lead_id option:selected').attr('customer_id');
                } 
                $.ajax({
                    url, data,
                    method: 'POST',
                    success: result => response(result.map(v => ({label: v.name, value: v.name, data: v}))),
                });
            },
            autoFocus: true,
            select: function(event, ui) {
                const {data} = ui.item;

                const row = Form.activeRow;
                row.find('.prod-id').val(data.id);
                row.find('.name').val(data.name);
                row.find('.qty').val(1);

                const currencyRate = $('#currency option:selected').attr('currency_rate');
                if (currencyRate > 1) {
                    data.purchase_price = parseFloat(data.purchase_price) / currencyRate;
                    data.price = parseFloat(data.price) / currencyRate;
                }

                row.find('.price').val(accounting.formatNumber(data.price)).change();  
                if (data.units) {
                    let units = data.units.filter(v => v.unit_type == 'base');
                    if (units.length) row.find('.unit').val(units[0].code);
                }
            }
        },
    };

    const Form = {
        rowCount: 1,
        initRow: '',
        activeRow: {},

        init() {
            $('table tbody th').css({padding: '8px 5px'});
            $('table tbody td').css({padding: '8px 5px'});

            $.ajaxSetup(config.ajax);
            $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
            $('.select2').select2({allowClear: true});

            
            $('#tax').change(Form.taxChangeHandler).change();
            $('#currency').change(Form.currencyChangeHandler);
            $(document).on('click', '.add-row, .remove-row', Form.addOrRemoveRowHandler);
            $(document).on('change', '.qty, .price, .taxid', Form.rowInputChangeHandler);
            $(document).on('keyup', '.name', Form.setActiveRowHandler);

            Form.initRow = $('#products_tbl tbody tr:first').html();
            $('#products_tbl tbody tr:first').find('.name').autocomplete(config.autocomplete);
        },

        currencyChangeHandler() {
            rate = $(this).find(':selected').attr('rate');
            if (rate == 1) {
                $('#frx_rate').val(1).attr('readonly', true);
            } else {
                $('#frx_rate').val(rate).attr('readonly', false);
            }
        },

        taxChangeHandler() {
            const taxRate = this.value * 1;
            $('#products_tbl tbody tr').each(function() {
                taxId = $(this).find('.taxid');
                taxId.children().each(function() {
                    const rowTaxRate = $(this).attr('value') * 1;
                    if (rowTaxRate == taxRate || rowTaxRate == 0) 
                        $(this).removeClass('d-none');
                    else $(this).addClass('d-none');
                });
                taxId.val(taxRate).change();
            });
        },

        rowInputChangeHandler() {
            const row = $(this).parents('tr');
            const qty = accounting.unformat(row.find('.qty').val());
            const price = accounting.unformat(row.find('.price').val());
            const taxRate = accounting.unformat(row.find('.taxid').val());

            const tax = qty * price * (taxRate / 100);
            const amount = tax + (qty * price);
            
            row.find('.prodtax').val(accounting.formatNumber(tax));
            row.find('.price').val(accounting.formatNumber(price));
            row.find('.amount').val(accounting.formatNumber(amount));
            Form.calcTotal();
        },

        addOrRemoveRowHandler() {
            if ($(this).is('.add-row')) {
                Form.rowCount++;
                $(this).closest('tr').after(`<tr>${Form.initRow}</tr>`);
                const row = $(this).closest('tr').next();
                row.find('.name').autocomplete(config.autocomplete);
                // limit line item tax options
                const taxRate = parseFloat($('#tax').val());
                row.find('.taxid').children().each(function() {
                    const optVal = parseFloat($(this).attr('value'));
                    if (optVal == taxRate || optVal == 0) $(this).removeClass('d-none');
                    else $(this).addClass('d-none');
                });
            } else {
                Form.rowCount--;
                const row = $('#products_tbl tbody tr:last');
                if (!row.siblings().length) return;
                row.remove();
            }

            // set numbering
            $('#products_tbl tbody tr').each(function(i) {
                $(this).find('.num').val(i+1)
            });
            Form.calcTotal();
        },

        setActiveRowHandler() {
            Form.activeRow = $(this).parents('tr');
        },

        calcTotal() {
            let total = 0;
            let subtotal = 0;
            let taxable = 0;
            $('#products_tbl tbody tr').each(function(i) {
                const amount = accounting.unformat($(this).find('.amount').val());
                const qty = accounting.unformat($(this).find('.qty').val());
                const price = accounting.unformat($(this).find('.price').val());
                const tax = accounting.unformat($(this).find('.prodtax').val());
                if (tax > 0 ) taxable += qty * price;
                total += amount;
                subtotal += qty * price;
            });
            $('#taxable').val(accounting.formatNumber(taxable));
            $('#total').val(accounting.formatNumber(total));
            $('#subtotal').val(accounting.formatNumber(subtotal));
            $('#totaltax').val(accounting.formatNumber((total - subtotal)));
        }
    };

    $(Form.init);
</script>