<div class="row mb-1">
    <div class="col-6">
        <div>
            <button type="button" class="btn btn-blue btn-sm round float-right add-customer" data-toggle="modal" data-target="#addCustomerModal">
                <i class="fa fa-plus-circle"></i> customer
            </button>
            <label for="payer" class="caption">Customer Name</label>                      
        </div>
        
        <div class="input-group">
            <select class="form-control select2" name='customer_id' id="customer" data-placeholder="Choose Customer" required>
                <option value=""></option>
                @foreach ($customers as $row)
                    <option value="{{ $row->id }}">
                        {{ $row->company }}
                    </option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="col-2">
        <label for="tid" class="caption">Work Order No.</label>
        {{ Form::text('tid', @$tid, ['class' => 'form-control round', 'readonly']) }}
    </div>

    <div class="col-2">
        <label for="invoicedate" class="caption">Work Order Date</label>
        {{ Form::text('date', null, ['class' => 'form-control round datepicker', 'id' => 'date']) }}
    </div>

    <div class="col-2">
        <label for="tid" class="caption">Tax Rate*</label>
        <select class="custom-select" name='tax_rate' id="tax" required>
            @foreach ($tax_rates as $row)
                <option value="{{ +$row->value }}" {{ @$work_order && $work_order->tax_id == $row->value? 'selected' : '' }}>
                    {{ $row->name }}
                </option>
            @endforeach
        </select>        
    </div>   
</div>

<div class="form-group row">
    <div class="col-md-2"> 
        <label for="refer_no" class="caption">Deposit Account*</label>                                   
        <select class="custom-select" name="bank_id" id="bank_id" required>
            <option value="">-- Select Bank --</option>
            @foreach ($banks as $bank)
                <option value="{{ $bank->id }}" {{ $bank->id == @$work_order->bank_id ? 'selected' : '' }}>
                    {{ $bank->bank }} {{ $bank->note? "- {$bank->note}" : '' }}
                </option>
            @endforeach
        </select>                               
    </div>
    <div class="col-md-2">
        <label for="validity" class="caption">Credit Period</label>
        <select class="custom-select" name="validity" id="validity">
            @foreach ([0, 14, 30, 45, 60, 90] as $val)
            <option value="{{ $val }}" {{ !$val ? 'selected' : ''}} {{ @$work_order->validity == $val ? 'selected' : '' }}>
                {{ $val ? 'Valid For ' . $val . ' Days' : 'On Receipt' }}
            </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-2">
        <label for="income_category" class="caption">Income Category*</label>
        <select class="custom-select" name="ledger_id" required>
            <option value="">-- Select Category --</option>                                        
            @foreach ($accounts as $row)
                @php if ($row->system) continue; @endphp
                <option value="{{ $row->id }}" {{ $row->id == @$work_order->ledger_id ? 'selected' : '' }}>
                    {{ $row->name }}
                </option>                    
            @endforeach                                        
        </select>
    </div>

    <div class="col-md-3">
        <label for="terms">Terms</label>
        <select name="term_id" class="custom-select">
            @foreach ($terms as $term)
            <option value="{{ $term->id }}" {{ $term->id == @$work_order->term_id ? 'selected' : ''}}>
                {{ $term->title }}
            </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-3">
        <label for="currency">Currency Rate</label>
        <div class="row no-gutters">
            <div class="col-md-6">
                <select class="custom-select" name="currency_id" id="currency" data-placeholder="{{trans('tasks.assign')}}" required>
                    @foreach ($currencies as $currency)
                        <option value="{{ $currency->id }}" rate="{{ +$currency->rate }}" {{ +$currency->rate == 1? 'selected' : '' }}>                        
                            {{ $currency->code }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
                {{ Form::text('frx_rate', 1, ['class' => 'form-control', 'id' => 'frx_rate', 'readonly']) }}
            </div>
        </div>
        
    </div>
</div>

<div class="row mb-1">
    <div class="col-12">
        <div class="input-group"><label for="title" class="caption">Note</label></div>
        {{ Form::text('note', null, ['class' => 'form-control']) }}
    </div>
</div>

<div class="table-responsive">
    <table id="products_tbl" class="table tfr my_stripe_single pb-1">
        <thead>
            <tr class="item_header bg-gradient-directional-blue white">
                <th width="8%">#</th>
                <th width="35%">Item Name</th>
                <th >UoM</th>
                <th width="5%">Qty</th>
                <th>Unit Price</th>
                <th>VAT</th>
                <th>Amount</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><input class="form-control num" name="numbering[]" value="1"></td>                                            
                <td><input class="form-control name" name="description[]"></td>
                <td><input type="text" class="form-control unit" name="unit[]" value="ITEM"></td>
                <td><input type="text" class="form-control qty" name="product_qty[]"></td>
                <td><input type="text" class="form-control price" name="product_price[]"></td>
                <td>
                    <div class="row no-gutters">
                        <div class="col-6">
                            <select class="custom-select taxid" name='item_tax_id[]'>
                                @foreach ($tax_rates as $row)
                                    <option value="{{ +$row->value }}" {{ @$work_order && $work_order->tax_id == $row->value? 'selected' : '' }}>
                                        {{ $row->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-6"><input type="text" class="form-control prodtax" name="product_tax[]" readonly></div>
                    </div>                  
                </td>
                <td><input type="text" class="form-control amount" name="product_amount[]" readonly></td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            action
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item add-row" href="javascript:"><i class="fa fa-plus"></i> Add Row</a>
                            <a class="dropdown-item text-danger remove-row" href="javascript:">Remove</a>
                        </div>
                    </div> 
                </td>
                <input type="hidden" class="form-control prod-id" name="product_id[]">
            </tr>
        </tbody>
    </table>
</div>

<!-- Totals Summary -->
<div class="form-group">
    <div class="col-2 ml-auto">
        <label for="taxable">Taxable Amount</label>
        {{ Form::text('taxable', null, ['class' => 'form-control', 'id' => 'taxable', 'readonly']) }}
    </div>
    <div class="col-2 ml-auto">
        <label for="subtotal">Subtotal</label>
        {{ Form::text('subtotal', null, ['class' => 'form-control', 'id' => 'subtotal', 'readonly']) }}
    </div>
    <div class="col-2 ml-auto">
        <label for="totaltax">Total Tax</label>
        {{ Form::text('tax', null, ['class' => 'form-control', 'id' => 'totaltax', 'readonly']) }}
    </div>
    <div class="col-2 ml-auto">
        <label for="grandtotal">Grand Total</label>
        {{ Form::text('total', null, ['class' => 'form-control', 'id' => 'total', 'readonly']) }}
    </div>      

    <!-- submit buttons -->                             
    <div class="row form-group">
        <div class="col-sm-3 ml-auto mr-auto">
            <div class="input-group">
                <div class="col-sm-6">
                    <a href="{{ route('biller.invoices.index') }}" class="btn btn-danger block">Cancel</a>    
                </div>
                <div class="col-sm-6">
                    {{ Form::submit('Submit', ['class' => 'btn btn-primary block text-white mr-1']) }}    
                </div>
            </div>
        </div>        
    </div>
</div>

@section('extra-scripts')
@include('focus.work_orders.form_js')
@stop
