<div class="form-group row">
    <div class="col-3">
        <label for="tid">Work Order No.</label>
        {{ Form::text('reference_number',"WKOR-".(@$work_orders+1),['class' => 'form-control', 'id' => 'tid', 'readonly']) }}
    </div>

    {{-- <div class="col-3">
        <label for="tid">Reference Number.</label>
        {{ Form::text('reference_number',null,['class' => 'form-control', 'id' => 'reference_number']) }}
    </div> --}}

    <div class="col-3">
        <label for="tid">Customer</label>
        <select class="form-control" name="customer_id" id="customer_id">
            <option value="">--Select Customer--</option>
            @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" {{ $customer->id == @$workOrder->customer_id ? ' selected' : '' }}>
                    {{ $customer->name }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-3">
        <label for="tid">Project</label>
        <select class="form-control" name="project_id" id="project_id">
            {{-- @foreach ($projects as $project)
                <option value="{{ $project->id }}" {{ $customer->id == @$workOrder->project_id ? ' selected' : '' }}>
                    {{ $project->name }}
                </option>
            @endforeach --}}
        </select>
    </div>
    <div class="col-3">
        <label for="date">Date</label>
        {{ Form::date('date', null,['class' => 'form-control', 'id' => 'date', '']) }}
    </div>
</div>

<div class="form-group row">
    <div class="col-3">
        <label for="tid">Payment Details</label>
        <select class="custom-select" name="bank_id" id="bank_id" required>
            <option value="">-- Select Bank --</option>
            @foreach ($banks as $bank)
                <option value="{{ $bank->id }}" {{ $bank->id == @$workOrder->bank_id ? 'selected' : '' }}>
                    {{ $bank->bank }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-3">
        <label for="tid">Credit Period</label>
        <select class="custom-select" name="validity" id="validity">
            @foreach ([0, 14, 30, 45, 60, 90] as $val)
            <option value="{{ $val }}" {{ !$val ? 'selected' : ''}} {{ @$workOrder->validity == $val ? 'selected' : '' }}>
                {{ $val ? 'Valid For ' . $val . ' Days' : 'On Receipt' }}
            </option>
            @endforeach
        </select>
    </div>

    <div class="col-3">
        <label for="tid">Income Category</label>
        <select  name="income_account" class="form-control" id="income_account" required>
            <option value="">Select Ledger Account</option>
                    @foreach($income_accounts as $account)
                    <option value="{{$account->id}}" {{ $account->id == @$workOrder->income_account ? 'selected' : '' }}>
                        {{$account->holder}}
                    </option>
                    @endforeach
        </select>
    </div>

    <div class="col-3">
        <label for="tid">Terms</label>
        <select class="form-control" name="terms" id="term_id">
            <option value="">--Select Terms--</option>
            @foreach ($terms as $term)
            <option value="{{ $term->id }}" {{ $term->id == @$workOrder->terms ? 'selected' : '' }}>
                {{ $term->title }}
            </option>
            @endforeach
        </select>
    </div>


</div>

<div class="form-group row">
    <div class="col-3">
        <label for="tid">Generated By</label>
        <select class="form-control" name="generated_by" id="generated_by">
            <option value="">--Generated By--</option>
            @foreach ($users as $user)
                <option value="{{ $user->id }}" {{ $user->id == @$workOrder->generated_by ? 'selected' : '' }}>
                    {{ $user->first_name }} {{ $user->last_name }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-3">
        <label for="currency">Currency</label>
        <div class="row">
            <div class="col-6">
                <select class="form-control" name="currency_id" id="currency">
                    @foreach ($currencies as $currency)
                        <option value="{{ $currency->id }}" data-rate="{{ $currency->rate }}" {{ $currency->id == @$workOrder->currency ? 'selected' : '' }}>
                            {{ $currency->code }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-6">
                <div class="row">
                    <input class="form-control" type="number" name="currency_rate" id="new_currency_rate">
                </div>
            </div>
        </div>
    </div>


    {{-- <div class="col-3">
        <label for="currency">Currency</label>
        <div class="row">
            <div class="col-6">
                <select class="form-control" name="currency_id" id="currency">
                    <option value="">--Select Currency--</option>
                    @foreach ($currencies as $currency)
                        <option value="{{ $currency->id }}" currency_rate="{{ $currency->rate }}" {{ $currency->id == @$workOrder->currency ? 'selected' : '' }}>
                            {{ $currency->code }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-6">
                <div class="row">
                    <input class="form-control" type="number" name="currency_rate" id="new_currency_rate" disabled placeholder="Current Currency Rate">
                </div>
            </div>
        </div>
    </div> --}}

    <div class="col-3">
        <label for="tid">Tax</label>
        <select class="form-control" name='d_tax_id' id="d_tax_id">
            <option value="">-- Select Tax Rate --</option>
            @foreach ($additionals as $row)
                <option value="{{ $row->value }}" {{ $row->value == @$workOrder->tax_id ? 'selected' : '' }}>
                    {{ $row->name }}
                </option>
            @endforeach
        </select>
    </div>
</div>


<div class="form-group row">
    <div class="col-12">
        {{ Form::label('Notes', null,['class' => 'control-label']) }}
        {{ Form::textarea('notes', null, ['class' => 'form-control col', 'rows'=>2, 'placeholder' => "Notes"]) }}
    </div>
</div>

<br>

<div class="table-responsive">
    <table class="table tfr my_stripe_single text-center" id="workOrderTable">
        <thead>
            <tr class="item_header bg-gradient-directional-blue white ">
                <th class="text-center">Item</th>
                <th class="text-center">Quantity</th>
                <th class="text-center">UoM</th>
                <th class="text-center">Unit Cost</th>
                <th class="text-center">Total Cost</th>
                <th class="text-center">Tax</th>
                <th class="text-center">Amount</th>
                <th class="text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            {{-- @php
                dd($workOrder->work_order_items);
            @endphp --}}
            @foreach ($workOrder->work_order_items as $item)
            <tr>
                <td width="20%" class="text-left">
                    @if ($item->p_bom_type == 1)
                     <input type="text" class="form-control product-name" name="product_name[]" id="product_name-0" value="{{$item->product_name}}">
                     <input type="text" class="form-control product-id" name="product_id[]" id="product_id-0" value="{{$item->product_id}}">

                     <input type="hidden" name="p_bom_type[]" value="1">
                     <input type="hidden" name="p_bom_id[]" value="{{$item->product_id}}">


                    @else
                    <input type="text" class="form-control product-name" name="product_name[]" id="product_name-0" value="{{$item->product}}">
                    <input type="text" class="form-control product-id" name="product_id[]" id="product_id-0" value="{{$item->product_id}}">

                    <input type="hidden" name="p_bom_type[]" value="0">
                    <input type="hidden" name="p_bom_id[]" value="0">
                    @endif

                    {{-- <textarea id="" cols="40" rows="3" class="form-control product-id" name="product_id[]" id="product_id-0"></textarea> --}}
                    {{-- <select class="form-control product-name" name="product_id[]" id="product_id-0">
                        @foreach ($products as $product)
                            <option value="{{ $product->id }}">
                                {{ $product->name }}
                            </option>
                        @endforeach
                    </select> --}}
                </td>
                <td width="10%" class="text-left">
                    <input type="number" class="form-control quantity" name="quantity[]" id="quantity-0" value="{{$item->quantity}}" required>
                </td>
                <td width="15%" class="text-left">
                    <select class="form-control uom" name="uom[]" id="uom-0">
                        @foreach ($productvariables as $productvariable)
                            <option value="{{ $productvariable->id }}" {{ $productvariable->id == $item->uom ? 'selected' : '' }}>
                                {{ $productvariable->title }}
                            </option>
                        @endforeach
                    </select>
                </td>
                <td>
                    <input type="text" class="form-control unit_cost" name="unit_cost[]" id="unit_cost-0" value="{{$item->unit_cost }}">
                </td>
                <td>
                    <input type="text" class="form-control total_cost" name="total_cost[]" id="total_cost-0" value="{{$item->total_cost }}" readonly>
                <td width="10%" class="text-left">
                    <select class="custom-select tax_id" name='tax_id[]' id="tax_id-0" required>
                        @foreach ($additionals as $row)
                            <option value="{{ $row->value }}" {{ $row->value == $item->tax_id ? 'selected' : '' }} >
                                {{ $row->name }}
                            </option>
                        @endforeach
                    </select>
                </td>

                <td>
                    <input type="text" class="form-control amount" name="amount[]" id="amount-0" value="{{$item->amount}}" readonly>
                </td>
                <td>
                    <button type="button" class="btn btn-danger remove"><i class="fa fa-minus-square" aria-hidden="true"></i></button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<button type="button" class="btn btn-success" aria-label="Left Align" id="addProduct">
    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
</button>

<div class="form-group">
    <div class="col-2 ml-auto">
        <label for="taxable" class="m-0">Taxable</label>
        {{ Form::text('taxable', null, ['class' => 'form-control', 'id' => 'taxable', 'readonly']) }}
        <label for="subtotal" class="m-0">Subtotal</label>
        {{ Form::text('subtotal', null, ['class' => 'form-control', 'id' => 'sub_total', 'readonly']) }}
        <label for="totaltax" class="m-0">Total Tax</label>
        {{ Form::text('tax', null, ['class' => 'form-control', 'id' => 'tax', 'readonly']) }}
        <label for="grandtotal" class="m-0">Grand Total</label>
        {{ Form::text('grand_total', null, ['class' => 'form-control', 'id' => 'amount', 'readonly']) }}
    </div>
</div>

{{-- <div class="form-group">
    <div class="col-2 ml-auto">
        <label for="taxable" class="m-0">FR Taxable</label>
        {{ Form::text('taxable', null, ['class' => 'form-control', 'id' => 'frx_taxable', 'readonly']) }}
        <label for="subtotal" class="m-0">FR Subtotal</label>
        {{ Form::text('subtotal', null, ['class' => 'form-control', 'id' => 'frx_subtotal', 'readonly']) }}
        <label for="totaltax" class="m-0">FR Total Tax</label>
        {{ Form::text('tax', null, ['class' => 'form-control', 'id' => 'frx_tax', 'readonly']) }}
        <label for="grandtotal" class="m-0">FR Grand Total</label>
        {{ Form::text('grand_total', null, ['class' => 'form-control', 'id' => 'frx_total_amount', 'readonly']) }}
    </div>
</div> --}}

@section("extra-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        $.ajaxSetup({ headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}});

        const productUrl =  "{{ route('biller.products.select') }}";

        let tableRow = $('#workOrderTable tbody tr:first').html();
        let rowIds = 0;

    $('#currency').change(function(){
        $('#currency_rate').attr('disabled', false).attr('required', true).val('');
    });

    // $('#product_id-0').autocomplete(predict(productUrl, productSelect));

    $('#addProduct').click(function() {
        rowIds++;
        let i = rowIds;
        const html = tableRow.replace(/-0/g, '-'+i).replace(/d-none/g, '');
        $('#workOrderTable tbody').append('<tr>' + html + '</tr>');
        $('#product_id-'+i).autocomplete(predict(productUrl, productSelect));
        const productText = $("#d_tax_id option:selected").text().replace(/\s+/g, ' ');
    });

    $('#workOrderTable').on('click','.tax_id',function(){
        const el = $(this);
        const row = el.parents('tr:first');


        // $(row.find('.product-id')).autocomplete(predict(productUrl, productSelect));

        // const quantity = row.find('.quantity').val();
        // const unit_price = row.find('.unit_cost').val();
        // const total_price = quantity * unit_price;
        // row.find('.total_cost').val(total_price);

        // const tax_rate = row.find('.tax_id').val();
        // const tax = (tax_rate * total_price) / 100;
        // row.find('.amount').val(total_price + tax);
        // calculateTotals();
    });



    $('#d_tax_id').change(function(){
        const productText = $("#d_tax_id option:selected").text().replace(/\s+/g, ' ');
        $('#tax_id-0').val($(this).val());

    });

    //On customer select, load quotes
    $('#customer_id').change(function(){
        const customer_id = $(this).val();

        $.ajax({
            url:"{{route('biller.customer.projects.get')}}",
            dataType: "json",
            method: "POST",
            data: {customer_id:customer_id},
            success: function(data) {
                $('select[id="project_id"]').empty();
                $('select[id="project_id"]').append('<option value="">--Select Project--</option');
                $.each(data, function(k,v){
                    $('select[id="project_id"]')
                        .append('<option value="'+v.id+'">' + v.name + '</option');
                });
            }
        });
    });

    //On Quote select, load quotes
        $('#project_id').change(function(){
        const project_id = $(this).val();

        $.ajax({
            url:"{{route('biller.cp.get')}}",
            dataType: "json",
            method: "POST",
            data: {project_id:project_id},
            success: function(data) {
                // console.log(data);
                $('#workOrderTable tbody').empty();
                $.each(data, function(k,v){
                    console.log(v);
                    $('#workOrderTable tbody').append(addWorkOrderTableRow(k,v));
                    calculateTotals();
                });
            }
        });
    });


    function addWorkOrderTableRow(k,v){
        return `
        <tr>
            <td width="20%" class="text-left">
                <input type="text" class="form-control product-name" name="product_name[]" id="product_name-0" value="${v['product_name']}">
                <input type="hidden" class="form-control product-id" name="product_id[]" id="product_id-0" value="${v['product_id']}">
                <input type="hidden" name="p_bom_type[]" value="1">
                <input type="hidden" name="p_bom_id[]" value="${v['p_bom_id']}">
            </td>
            <td width="10%" class="text-left">
                <input type="number" class="form-control quantity" name="quantity[]" id="quantity-0" value="${v['quantity']}">
            </td>
            <td width="15%" class="text-left">
                <select class="form-control uom" name="uom[]" id="uom-0">
                    @foreach ($productvariables as $productvariable)
                        <option value="{{ $productvariable->id }}">
                            {{ $productvariable->title }}
                        </option>
                    @endforeach
                </select>
            </td>
            <td>
                <input type="number" class="form-control unit_cost" name="unit_cost[]" id="unit_cost-0" value="${accounting.unformat(v['unit_cost'])}">
            </td>
            <td>
                <input type="number" class="form-control total_cost" name="total_cost[]" id="total_cost-0" value="${v['quantity'] * v['unit_cost'] }" readonly>
            <td width="10%" class="text-left">
                <select class="custom-select tax_id" name='tax_id[]' id="tax_id-0" required>
                    @foreach ($additionals as $tax)
                        <option value="{{ $tax->value }}" {{$tax->value == 0 ? 'selected' : ''}}>
                            {{ $tax->name }}
                        </option>
                    @endforeach
                </select>
            </td>

            <td>
                <input type="number" class="form-control amount" name="amount[]" id="amount-0" value="${v['quantity'] * v['unit_cost'] }" readonly>
            </td>
            <td>
                <button type="button" class="btn btn-danger d-none remove"><i class="fa fa-minus-square" aria-hidden="true"></i></button>
            </td>
        </tr>
        `;
    }


    // $('#currency_rate').on('keyup', function(){
    //     const currency_rate = $(this).val();
    //     console.log(currency_rate);

    //     $('#workOrderTable tbody tr').each(function() {
    //         const el = $(this);
    //         const row = el.parents('tr:first');

    //         const quantity = row.find('.quantity').val();

    //         console.log(row);

    //         const unit_price = accounting.unformat($(this).find('.unit_cost').val());
    //         const tax_rate = $(this).find('.tax_id').val();
    //         const total_price = quantity * unit_price;
    //         const tax = (tax_rate * total_price) / 100;
    //         const amount = total_price + tax;
    //         // const t_amount = amount + unit_cost;

    //         row.find('.unit_cost').val(unit_price * currency_rate);

    //         // grandTotal += amount;
    //         // totalTax += tax;
    //         // subTotal += total_price;
    //         // taxable += tax;
    //     });
    // });

    $('#workOrderTable').on('keyup','.quantity',function(){
        const el = $(this);
        const row = el.parents('tr:first');
        const quantity = row.find('.quantity').val();
        const unit_price = row.find('.unit_cost').val();
        const total_price = quantity * unit_price;
        row.find('.total_cost').val(total_price);

        const tax_rate = row.find('.tax_id').val();
        const tax = (tax_rate * total_price) / 100;
        row.find('.amount').val(total_price + tax);
        // calculateTotals();
    });


    $('#workOrderTable').on('change','.tax_id',function(){
        const el = $(this);
        const row = el.parents('tr:first');
        const quantity = row.find('.quantity').val();
        const unit_price = row.find('.unit_cost').val();
        const total_price = quantity * unit_price;
        row.find('.total_cost').val(total_price);

        const tax_rate = row.find('.tax_id').val();
        const tax = (tax_rate * total_price) / 100;
        row.find('.amount').val(total_price + tax);
        calculateTotals();
    });




    function calculateTotals() {
        let grandTotal = 0;
        let totalTax = 0;
        let subTotal = 0;
        let taxable = 0;
        $('#workOrderTable tbody tr').each(function() {
            // if (!$(this).find('.current-stock-quantity').val()) return;
            const unit_price = accounting.unformat($(this).find('.unit_cost').val());
            const quantity = accounting.unformat($(this).find('.quantity').val());
            const tax_rate = $(this).find('.tax_id').val();
            const total_price = quantity * unit_price;
            const tax = (tax_rate * total_price) / 100;
            const amount = total_price + tax;
            // const t_amount = amount + unit_cost;
            grandTotal += amount;
            totalTax += tax;
            subTotal += total_price;
            // taxable += tax;
        });
            $('#taxable').val(subTotal);
            $('#subtotal').val(subTotal);
            $('#tax').val(totalTax);
            $('#total_amount').val(grandTotal);

            // let currentRate = $('#new_currency_rate').val();
            // $('#frx_taxable').val(taxable / currentRate);
            // $('#frx_total_amount').val(grandTotal / currentRate);
            // $('#frx_subtotal').val(subtotal / currentRate);
            // $('#frx_tax').val(frx_total_amount - frx_subtotal);
    };

    let productRowId = 0;
    function productSelect(event, ui){
            let currentRate = $('#new_currency_rate').val();
            const {data} = ui.item;
            const i = productRowId;

            if(currentRate === 0){
                currentRate = 1;
            }
            $('#unit_cost-'+i).val(data.selling_price);
            productRowId++;
        };

    function predict(url, callback) {
        return {
            source: function(request, response) {
                $.ajax({
                    url,
                    dataType: "json",
                    method: "POST",
                    data: {keyword: request.term},
                    success: function(data) {
                        response(data.map(v => ({
                            label: v.name,
                            value: v.name,
                            data: v
                        })));
                    }
                });
            },
            autoFocus: true,
            minLength: 0,
            select: callback
        };
    };

    let initRate = $('#currency option:selected').attr('currency_rate')*1;

    $('#new_currency_rate').keyup(function(){
        const currentRate = $(this).val()*1;
        // console.log(currentRate);
        if (currentRate > initRate) {
            $('#workOrderTable tbody tr').each(function() {
                // let purchasePrice = accounting.unformat($(this).find('.unit_cost').val())  * initRate;
                // let itemRate = accounting.unformat($(this).find('.total_cost').val()) * initRate;
                // purchasePrice = purchasePrice / currentRate;
                // itemRate = itemRate / currentRate;
                // $(this).find('.unit_cost').val(accounting.formatNumber(purchasePrice, 4));
                // $(this).find('.total_cost').val(accounting.formatNumber(itemRate, 4)).change();

                let purchasePrice = $(this).find('.unit_cost').val()  * initRate;
                let itemRate = $(this).find('.total_cost').val() * initRate;
                purchasePrice = purchasePrice / currentRate;
                itemRate = itemRate / currentRate;
                $(this).find('.unit_cost').val(purchasePrice);
                $(this).find('.total_cost').val(itemRate).change();

                const tax_rate = $(this).find('.tax_id').val();
                const tax = (tax_rate * itemRate) / 100;
                $(this).find('.amount').val(itemRate + tax).change();

            });
        } else {
            $('#workOrderTable tbody tr').each(function() {
                // let purchasePrice = accounting.unformat($(this).find('.unit_cost').val())  / currentRate;
                // let itemRate = accounting.unformat($(this).find('.total_cost').val()) / currentRate;
                // purchasePrice = purchasePrice * initRate;
                // itemRate = itemRate * initRate;
                // $(this).find('.unit_cost').val(accounting.formatNumber(purchasePrice, 4));
                // $(this).find('.total_cost').val(accounting.formatNumber(itemRate, 4)).change();

                let purchasePrice = $(this).find('.unit_cost').val()  / currentRate;
                let itemRate = $(this).find('.total_cost').val() / currentRate;
                purchasePrice = purchasePrice * initRate;
                itemRate = itemRate * initRate;
                $(this).find('.unit_cost').val(purchasePrice);
                $(this).find('.total_cost').val(itemRate).change();

                const tax_rate = $(this).find('.tax_id').val();
                const tax = (tax_rate * itemRate) / 100;
                $(this).find('.amount').val(itemRate + tax).change();
            });
        }
        initRate = currentRate;
    });

    $('#currency').change(function() {
        $('#new_currency_rate').attr('disabled', false).attr('required', true).val(1);

        // const currentRate = $(this).find(':selected').attr('currency_rate') * 1;
        const currentRate = $('#new_currency_rate').val() * 1;
        if (currentRate > initRate) {
            $('#workOrderTable tbody tr').each(function() {
                // let purchasePrice = accounting.unformat($(this).find('.unit_cost').val())  * initRate;
                // let itemRate = accounting.unformat($(this).find('.total_cost').val()) * initRate;
                // purchasePrice = purchasePrice / currentRate;
                // itemRate = itemRate / currentRate;
                // $(this).find('.unit_cost').val(accounting.formatNumber(purchasePrice, 4));
                // $(this).find('.total_cost').val(accounting.formatNumber(itemRate, 4)).change();

                let purchasePrice = $(this).find('.unit_cost').val()  * initRate;
                let itemRate = $(this).find('.total_cost').val() * initRate;
                purchasePrice = purchasePrice / currentRate;
                itemRate = itemRate / currentRate;
                $(this).find('.unit_cost').val(purchasePrice);
                $(this).find('.total_cost').val(itemRate).change();

                const tax_rate = $(this).find('.tax_id').val();
                const tax = (tax_rate * itemRate) / 100;
                $(this).find('.amount').val(itemRate + tax).change();


            });
        } else {
            $('#workOrderTable tbody tr').each(function() {
                // let purchasePrice = accounting.unformat($(this).find('.unit_cost').val())  / currentRate;
                // let itemRate = accounting.unformat($(this).find('.total_cost').val()) / currentRate;
                // purchasePrice = purchasePrice * initRate;
                // itemRate = itemRate * initRate;
                // $(this).find('.unit_cost').val(accounting.formatNumber(purchasePrice, 4));
                // $(this).find('.total_cost').val(accounting.formatNumber(itemRate, 4)).change();

                let purchasePrice = $(this).find('.unit_cost').val()  / currentRate;
                let itemRate = $(this).find('.total_cost').val() / currentRate;
                purchasePrice = purchasePrice * initRate;
                itemRate = itemRate * initRate;
                $(this).find('.unit_cost').val(purchasePrice);
                $(this).find('.total_cost').val(itemRate).change();

                const tax_rate = $(this).find('.tax_id').val();
                const tax = (tax_rate * itemRate) / 100;
                $(this).find('.amount').val(itemRate + tax).change();
            });
        }
        initRate = currentRate;
    });

    $('#workOrderTable').on('click', '.remove', removeRow);
    function removeRow() {
        const $tr = $(this).parents('tr:first');
        $tr.remove();
        calculateTotals();
    }

    function select2Config(url, callback) {
        return {
            ajax: {
                url,
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({q: term, keyword: term}),
                processResults: callback
            }
        }
    }

    $('.datepicker')
        .datepicker({format: "{{ config('core.user_date_format')}}", autoHide:true})
        .datepicker('setDate', new Date())


    // load projects dropdown
    // const projectUrl = "{{ route('biller.projects.project_search') }}";
    // function projectData(data) {
    //     return {results: data.map(v => ({id: v.id, text: v.name}))};
    // }
    // $("#project_id").select2(select2Config(projectUrl, projectData));




    // function updateLineTax(taxSelect) {
    //     if (taxSelect && taxSelect.length) {
    //         const mainTax = $('#tax_id').val();
    //         taxSelect.children().each(function() {
    //             const value = $(this).attr('value');
    //             if ((value == mainTax) || (value == 0)) $(this).removeClass('d-none');
    //             else $(this).addClass('d-none');
    //         });
    //         taxSelect.val(mainTax);
    //     }
    // }

    // $('#tax_id').change(function() {
    //     const mainTax = $(this).val();
    //     $('#workOrderTable tbody tr').each(function() {
    //         updateLineTax($(this).find('.tax_rate'));
    //         if ($(this).find('.quantity').val()*1) {
    //             const itemRate = accounting.unformat($(this).find('.unit_cost').val());
    //             $(this).find('.price').val(accounting.formatNumber(itemRate * (mainTax/100 + 1), 4));
    //             $(this).find('.rate').change();
    //         }
    //     });
    // }).change();

    </script>
@endsection
