@extends ('core.layouts.app')
@section('title', 'Waste Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Waste Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.waste_management.partials.waste-management-header-buttons')
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-header">
                            <a href="#" class="btn btn-warning btn-sm mr-1 mb-2" data-toggle="modal" data-target="#statusModal">
                                <i class="fa fa-pencil" aria-hidden="true"></i>Approval Status
                            </a>
                            <h4 class="card-title">
                                <div class="">
                                    {{ trans('products.general_product_details') }}
                                    <a href="{{ route('biller.waste-management.edit', [$waste_management['id']]) }}" class="btn btn-blue btn-outline-accent-5 btn-sm float-right">
                                        <i class="fa fa-pencil"></i> {{ trans('buttons.general.crud.edit') }}
                                    </a>
                                </div>

                            </h4>
                        </div>
                           <div class="card-body">
                            <div class="">
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Entry No:</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$waste_management->tid}}
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Entry Date:</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{dateFormat($waste_management->date)}}

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Description:</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$waste_management->description}}

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Added By:</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$waste_management->user->first_name}} {{$waste_management->user->last_name}}
                                    </div>
                                </div>
                            </div>
                            <div class="">
                                <br><br>
                                <div class="content-header-left col-6">
                                    <h4 class="content-header-title">Waste Products</h4>
                                </div>
                                <br><br>
                                <table class="table table-bordered">
                                    <thead>
                                        <th>#</th>
                                        <th  class="text-center">Waste Name</th>
                                        <th  class="text-center">UoM</th>
                                        <th  class="text-center">Quantity</th>
                                    </thead>
                                    <tbody>
                                        @foreach ( $waste_management['items'] as $mi)
                                            <tr class="text-center">
                                                <td>{{$loop->iteration}}</td>
                                                <td>{{$mi->name}}</td>
                                                <td>{{@$mi->unit->code}}</td>
                                                <td>{{+$mi->qty}}</td>
                                                
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        @include('focus.waste_management.partials.approval')
    </div>
</div>
@endsection
