@extends ('core.layouts.app')

@section ('title', 'Edit | Waste Management' )

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">{{ trans('labels.backend.products.management') }}</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.waste_management.partials.waste-management-header-buttons')
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            {{ Form::model($waste_management, ['route' => ['biller.waste-management.update', $waste_management], 'method' => 'PATCH', 'id' => 'edit-waste-management', 'files'=>true]) }}
                                <div class="form-group">
                                    @include("focus.waste_management.form")
                                    <div class="edit-form-btn">
                                        {{ link_to_route('biller.waste-management.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                        {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                        <div class="clearfix"></div>
                                    </div><!--edit-form-btn-->
                                </div><!--form-group-->
                            {{ Form::close() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra-scripts')
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        predict: (url, callback) => {
            return {
                source: function(request, response) {
                    $.ajax({
                        url,
                        dataType: "json",
                        method: "POST",
                        data: {keyword: request.term, projectstock: $('#projectstock').val()},
                        success: function(data) {
                            response(data.map(v => ({
                                label: v.name,
                                value: v.name,
                                data: v
                            })));
                        }
                    });
                },
                autoFocus: true,
                minLength: 0,
                select: callback
            };
        }
    };

    const Form = {
        rowIds: $('#wasteTbl tbody tr:first').length,
        tableRow: $('#wasteTbl tbody tr:first').html(),
        stockUrl: "{{ route('biller.products.waste_search') }}",

        init() {
            $.ajaxSetup(config.ajax);
            $('#user').select2({allowClear: true});
            $('.datepicker').datepicker(config.date);
            // initialize html editor
            editor();

            $('#wasteTbl tbody tr:first').remove();
            
            
            $('#addstock').click(this.addItem);
            $('#wasteTbl').on('click', '.remove', this.removeRow);
            
            
            
        },
        addItem() {
            Form.rowIds++;
            let i = Form.rowIds;
            const html = Form.tableRow.replace(/-0/g, '-'+i);
            $('#wasteTbl tbody').append('<tr>' + html + '</tr>');
            $('.name').autocomplete(config.predict(Form.stockUrl, Form.stockSelect));
        },
        removeRow() {
            const $tr = $(this).parents('tr:first');
            $tr.remove();
        },
        stockSelect(event, ui) {
            const {data} = ui.item;
            // console.log(ui);
            const i =  Form.rowIds;
            $('#item-id-'+i).val(data.id);
            $('#name-'+i).val(data.name);

            if(data.uom){
                $('#uom-'+i).val(data.uom);
                $('#unit-'+i).val(data.unit);
            }
            
        }
       
    };

    $(() => Form.init());
</script>
@endsection