<div class="card-content">
    <div class="card-body">
        <ul class="nav nav-tabs" role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="base-tab1" data-toggle="tab" aria-controls="tab1" href="#tab1" role="tab"
                   aria-selected="true"> {{ trans('suppliers.billing_address') }}
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="base-tab2" data-toggle="tab" aria-controls="tab2" href="#tab2" role="tab"
                   aria-selected="false">Payment Settings
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="base-tab3" data-toggle="tab" aria-controls="tab3" href="#tab3" role="tab"
                   aria-selected="false">Opening Balance
                </a>
            </li>
        </ul>

        <div class="tab-content px-1 pt-1">
            <!-- billing address -->
            @include('focus.suppliers.create_tabs.billing_adress_tab')
            <!-- payment setting -->
            @include('focus.suppliers.create_tabs.payment_settings_tab')
            <!-- opening balance -->
            @include('focus.suppliers.create_tabs.opening_balance_tab')
        </div>
    </div>
</div>

@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    const config = {
        date: {format: "{{config('core.user_date_format')}}", autoHide: true}
    };

    const Form = {
        supplier: @json(@$supplier),
        invRow: '',
        branchRow: '',

        init() {
            $('table thead th').css({'padding': '5px 8px'});
            $('table tbody td').css({'border': 'none', 'padding': '5px 8px'});
            $('#open_balance_date').datepicker(config.date).datepicker('setDate', new Date());
            $('.select2').select2({allowClear: true});

            $('#currency_id').change(Form.currencyChange).change();

            if (Form.supplier && Form.supplier.id) {
                Form.handleEdit(Form.supplier)
            } else {
                $('table tbody tr').removeClass('d-none');
                Form.invRow = $('#invoicesTbl tbody tr:first').html();
                Form.branchRow = $('#branchesTbl tbody tr:first').html();
                $('table .datepicker').datepicker(config.date).datepicker('setDate', new Date());
            }
            $(document).on('click', '.add_row, .del_row', Form.actionsMenuClick);
            $(document).on('change', '.inv_amount', Form.invoiceAmountChange);
        },

        handleEdit(supplier) {
            const date = supplier.open_balance_date;
            if (date) $('#open_balance_date').datepicker('setDate', new Date(date));
            $('#currency_id').val(supplier.currency_id).change();

            // set dynamic rows
            $('table tbody tr').removeClass('d-none');
            Form.invRow = $('#invoicesTbl tbody tr:first').html();
            Form.branchRow = $('#branchesTbl tbody tr:first').html();
            $('#invoicesTbl tbody tr:first').remove();
            $('#branchesTbl tbody tr:first').remove();

            $('#invoicesTbl tbody tr').each(function() {
                row = $(this);
                row.find('.datepicker').datepicker(config.date);
                row.find('.inv_date').datepicker('setDate', row.find('.inv_date').val());
                row.find('.inv_due_date').datepicker('setDate', row.find('.inv_date').val());
            });

            Form.invoiceAmountChange();
        },

        currencyChange() {
            const rate = $(this).find(':selected').attr('rate');
            $('#frx_rate').val(rate);  
            if (rate == 1) $('#frx_rate').attr('readonly', true);
            else $('#frx_rate').attr('readonly', false);
        },

        actionsMenuClick() {
            row = $(this).parents('tr');
            if ($(this).is('.add_row')) {
                if (row.find('.inv_no').length) {
                    row.after(`<tr>${Form.invRow}</tr>`);
                    row = $('#invoicesTbl tbody tr:last');
                    row.find('td:first').html(row.index() + 1);
                    row.find('.datepicker').datepicker(config.date);
                    row.find('.inv_date').datepicker('setDate', new Date());
                    row.find('.inv_due_date').datepicker('setDate', new Date());
                } else {
                    row.after(`<tr>${Form.branchRow}</tr>`);
                    row = $('#branchesTbl tbody tr:last');
                    row.find('td:first').html(row.index() + 1);
                }
            } else {
                if (row.siblings().length) {
                    row.remove();
                } else {
                    row.find('input').val('');
                    if (row.find('.inv_no').length) {
                        $('#open_balance').val('0.00').attr('readonly', false);
                    }
                }
            }
        },

        invoiceAmountChange() {
            totalInvAmount = 0;
            $('#invoicesTbl tbody tr').each(function() {
                const row = $(this);
                invAmountPaid = accounting.unformat(row.find('.inv_amountpaid').val());
                invAmount = accounting.unformat(row.find('.inv_amount').val());
                totalInvAmount += invAmount;
                row.find('.inv_amount').val(accounting.formatNumber(invAmount));
                row.find('.inv_amountpaid').val(accounting.formatNumber(invAmountPaid));
            });

            if (totalInvAmount > 0) {
                $('#open_balance').val(accounting.formatNumber(totalInvAmount)).attr('readonly', true);
            } else {
                $('#open_balance').val('0.00').attr('readonly', false);
            }
        },
    };

    $(Form.init);
</script>
@endsection