<div class="tab-pane active" id="tab1" role="tabpanel" aria-labelledby="base-tab1">
    <div class="row mt-1">
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label('company', 'Company Name',['class' => 'col-lg-6 control-label']) }}
                <div class='col-lg-12'>
                    {{ Form::text('company', null, ['class' => 'form-control box-size', 'placeholder' => 'Company Name' . '*', 'required']) }}
                </div>
            </div>
        </div>
        
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label( 'phone', trans('customers.phone'),['class' => 'col-lg-6 control-label']) }}
                <div class='col-md-12'>
                    {{ Form::text('phone', null, ['class' => 'form-control box-size', 'placeholder' => trans('customers.phone')]) }}
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label( 'email', trans('customers.email'),['class' => 'col-lg-6 control-label']) }}
                <div class='col-lg-12'>
                    {{ Form::email('email', null, ['class' => 'form-control box-size', 'placeholder' => trans('customers.email')]) }}
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class='form-group'>
                <div class='col-md-12'>
                    <label for="name">Supplier Name</label>
                    {{ Form::text('name', null, ['class' => 'form-control box-size', 'placeholder' => 'Supplier Name']) }}
                </div>
            </div>
        </div>
    </div>

    <div class='row'>
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label( 'address', trans('customers.address') . ' (P.O Box, City)', ['class' => 'col-lg-6 control-label']) }}
                <div class='col-sm-12'>
                    {{ Form::text('address', null, ['class' => 'form-control box-size', 'placeholder' => trans('customers.address') . ' (P.O Box, City)']) }}
                </div>
            </div>  
        </div> 
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label( 'region', trans('customers.region'),['class' => 'col-lg-6 control-label']) }}
                <div class='col-md-12'>
                    {{ Form::text('region', null, ['class' => 'form-control box-size', 'placeholder' => trans('customers.region')]) }}
                </div>
            </div>
        </div>                                     
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label( 'country', trans('customers.country'),['class' => 'col-lg-6 control-label']) }}
                <div class='col-md-12'>
                    {{ Form::text('country', null, ['class' => 'form-control box-size', 'placeholder' => trans('customers.country')]) }}
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class='form-group'>
                <div class='col-lg-12'>
                    <label for="customer_group">Supplier Group</label>
                    @php
                        $group_ids = @$supplier? $supplier->supplier_groups->pluck('id')->toArray() : [];
                    @endphp
                    <select name="supplier_groups[]" id="supplier_groups" class="form-control select2" data-placeholder="Choose Supplier Group" multiple>
                        <option value="">-- Select  --</option>
                        @foreach ($suppliergroups as $row)
                            <option value="{{ $row->id }}" {{ in_array($row->id, $group_ids)? 'selected' : '' }}>{{ $row->title }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label('tax_pin', 'TIN Number',['class' => 'col-lg-6 control-label']) }}
                <div class='col-lg-12'>
                    {{ Form::text('taxid', null, ['class' => 'form-control box-size', 'placeholder' => 'Tax PIN']) }}
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class='form-group'>
                <div class='col-lg-12'>
                    <label for="tax_exempt">Supplier Is Also Customer ?</label>
                    <select name="user_type" id="user_type" class="custom-select">
                        @foreach (['supplier' => 'No', 'customer_supplier' => 'Yes'] as $key => $val)
                            <option value="{{ $key }}" {{ @$supplier->user_type == $key? 'selected' : '' }}>
                                {{ $val }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class='form-group'>
                {{ Form::label('vrn', 'VRN Number',['class' => 'col-lg-6 control-label']) }}
                <div class='col-lg-12'>
                    {{ Form::text('vrn', null, ['class' => 'form-control box-size', 'placeholder' => 'VRN Number']) }}
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <div class='form-group'>
                <div class='col-lg-12'>
                    {{ Form::label('custom1', trans('customers.custom1'),['class' => 'control-label']) }}
                    {{ Form::textarea('custom1', null, ['class' => 'form-control', 'placeholder' => 'Extra Info', 'rows' => '3']) }}
                </div>
            </div>
        </div>

        <div class="col-sm-6">
            <div class='form-group'>
                <div class='col-lg-12'>
                    {{ Form::label( 'profile', 'Profile Image',['class' => 'control-label']) }}
                    <br>
                    {!! Form::file('picture', array('class'=>'input' )) !!}                    
                </div>
            </div>
        </div>
    </div>
</div>
