<div class="row form-group">
    <div class='col-3'>
        <label for="title">Name</label>
        {{ Form::text('name', $bom->name, ['class' => 'form-control', 'required']) }}
    </div>
    <div class='col-3'>
        <label for="code">Reference Number</label>
        {{ Form::text('reference_number', null, ['class' => 'form-control', 'required']) }}
    </div>
    <div class='col-3'>
        <label for="code">Date</label>
        {{ Form::date('date', null, ['class' => 'form-control', 'required']) }}
    </div>
    <div class='col-3'>
        <label for="code">Car Model</label>
        <select class="form-control car_model" name="car_model_id" id="car_model" required></select>
    </div>
</div>

<div class="row form-group">
    <div class='col-12'>
        <label for="title">Description</label>
        {{ Form::textarea('description', null, ['class' => 'form-control col', 'rows'=>2, 'placeholder' => 'Description']) }}

    </div>
</div>

<br>
<div class="table-responsive">
        <table class="table tfr my_stripe_single text-center" id="productsTbl">
        <thead>
            <tr class="item_header bg-gradient-directional-blue white ">
                <th width="10%" class="text-center">No.</th>
                <th class="text-center">Product</th>
                <th class="text-center">Status</th>
                <th class="text-center">Qty</th>
                <th class="text-center">UoM</th>
                <th class="text-center">Unit Cost</th>
                <th class="text-center">Amount</th>
                <th class="text-center">Action</th>
            </tr>
        </thead>
        <tbody>

            @foreach ($bom->bom_items as $bom_item)
                @if ($bom_item->a_type == "1" )
                <tr id="shopRow">
                    <td><input type="number" class="form-control" name="numbering[]" id="numbering-p0"></td>
                    <td colspan="6">
                        <select name="shop_name[]" class="form-control shop" required>
                            <option value="0">Select Assembly Shop</option>
                            @foreach ($shops as $shop)
                                <option value="{{ $shop->id }}" {{$shop->id == $bom_item->shop_id ? 'selected' : ''}}>
                                    {{ $shop->name }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    <td class="text-center">
                        <div class="dropdown">
                            <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">
                                Action
                            </button>
                            <div class="dropdown-menu" aria-labelledby="">
                                <a class="dropdown-item add-shop" href="javascript:"><i class="fa fa-plus"></i> Shop</a>
                                <a class="dropdown-item add-product" href="javascript:"><i class="fa fa-plus"></i> Product</a>
                                <a class="dropdown-item text-danger delete" href="javascript:">Remove</a>

                                {{-- <a class="dropdown-item add-misc" href="javascript:"><i class="fa fa-plus"></i> Miscellaneous</a> --}}
                                <hr>
                                <a class="dropdown-item up" href="javascript:">Up</a>
                                <a class="dropdown-item down" href="javascript:">Down</a>
                            </div>
                        </div>
                    </td>
                    <input type="hidden" name="status[]" value="0">
                    <input type="hidden" name="product_name[]" value="0">
                    <input type="hidden" name="quantity[]" value="0">
                    <input type="hidden" name="uom[]" value="0">
                    <input type="hidden" name="unit_cost[]" value="0">
                    <input type="hidden" name="total_cost[]" value="0">
                    <input type="hidden" class="index" name="row_index[]" value="0" id="rowindex-t1">
                    <input type="hidden" name="a_type[]" value="1" id="atype-t1">
                </tr>
                @else
                <tr id="productRow">
                    <td><input type="number" class="form-control" name="numbering[]" id="numbering-t1"></td>
                    <td width="30%" class="text-left">
                        <select class="custom-select product_name" name="product_name[]" id="product_name-0">
                            <option value="0">Select product</option>
                            @foreach ($products as $product)
                                <option value="{{ $product->id }}" {{$product->id == $bom_item->product_id ? 'selected' : ''}}>
                                    {{ $product->name }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    <td>
                        <select class="custom-select status" name="status[]" id="status-0">
                            <option value="2" {{$bom_item->status == 2 ? 'selected' : ''}}>Mandatory</option>
                            <option value="1" {{$bom_item->status == 1 ? 'selected' : ''}}>Optional</option>
                        </select>
                    </td>
                    <td width="10%"><input type="text" class="form-control quantity" name="quantity[]" id="quantity-0" value="{{$bom_item->quantity}}" required></td>
                    <td>
                        <select class="custom-select uom" name="uom[]" id="uom-0">
                            <option value="0">Select unit of measure</option>
                            @foreach ($productvariables as $productvariable)
                                <option value="{{ $productvariable->id }}" {{$productvariable->id == $bom_item->uom ? 'selected' : ''}}>
                                    {{ $productvariable->title }}
                                </option>
                            @endforeach
                        </select>
                    </td>
                    <td width="10%"><input type="text" name="unit_cost[]" id="unit_cost-0" class="form-control unit_cost" value="{{$bom_item->unit_cost}}" readonly></td>
                    <td width="10%"><input type="text" name="total_cost[]" id="total_cost-0" class="form-control total_cost" value="{{$bom_item->total_cost}}" readonly ></td>

                    <td class="text-center">
                        <div class="dropdown">
                            <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">
                                Action
                            </button>
                            <div class="dropdown-menu" aria-labelledby="">
                                <a class="dropdown-item add-shop" href="javascript:"><i class="fa fa-plus"></i> Shop</a>
                                <a class="dropdown-item add-product" href="javascript:"><i class="fa fa-plus"></i> Product</a>
                                <a class="dropdown-item text-danger delete" href="javascript:">Remove</a>

                                {{-- <a class="dropdown-item add-misc" href="javascript:"><i class="fa fa-plus"></i> Miscellaneous</a> --}}
                                <hr>
                                <a class="dropdown-item up" href="javascript:">Up</a>
                                <a class="dropdown-item down" href="javascript:">Down</a>
                            </div>
                        </div>
                    </td>
                    <input type="hidden" class="index" name="row_index[]" value="0" id="rowindex-t1">
                    <input type="hidden" name="a_type[]" value="2" id="atype-p1">
                    <input type="hidden" name="shop_name[]" value="0">

                </tr>
                @endif
            @endforeach



        </tbody>
    </table>
</div>

{{-- <button type="button" class="btn btn-success" aria-label="Left Align" id="addProduct">
    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
</button> --}}
<br>

{{-- <div class="form-group row">
    <div class="col-2 ml-auto">
        <label for="total">Mandatory Products Cost</label>
        {{ Form::text('amount', null, ['class' => 'form-control', 'id' => 'mandatory_amount', 'readonly']) }}
    </div>
</div>


<div class="form-group row">
    <div class="col-2 ml-auto">
        <label for="total">Optional Products Cost</label>
        {{ Form::text('amount', null, ['class' => 'form-control', 'id' => 'optional_amount', 'readonly']) }}
    </div>
</div> --}}

<div class="form-group row">
    <div class="col-2 ml-auto">
        <label for="total">Total Cost</label>
        {{ Form::text('amount', null, ['class' => 'form-control', 'id' => 'total_amount', 'readonly']) }}
    </div>
</div>

@section("extra-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        $.ajaxSetup({ headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}});
        let tableRow = $('#productsTbl tbody tr:first').html();

    // let rowIds = 0;
    // $('#addProduct').click(function() {
    //     rowIds++;
    //     let i = rowIds;
    //     const html = tableRow.replace(/-0/g, '-'+i).replace(/d-none/g, '');
    //     $('#productsTbl tbody').append('<tr>' + html + '</tr>');
    // });

    // $('#productsTbl').on('click', '.remove', removeRow);
    // function removeRow() {
    //     const $tr = $(this).parents('tr:first');
    //     $tr.remove();
    //     calcStock();
    // }

    // let rowId = 0;
    $('#productsTbl').on('keyup','.quantity', function() {
        const el = $(this);
        const row = el.parents('tr:first');
        const quantity = row.find('.quantity').val();
        const unit_cost = row.find('.unit_cost').val();
        row.find('.total_cost').val(quantity * unit_cost);
        calcStock();
    });

    $('#productsTbl').on('change', '.product_name', function() {
        const el = $(this);
        const row = el.parents('tr:first');

        const product_id = row.find('.product_name').attr('id');
        const product = row.find('.product_name').val();
        const quantity = row.find('.quantity').val();


        $.ajax({
                url:"{{ route('biller.products.details.get') }}",
                type: 'GET',
                quietMillis: 50,
                data:{product :product},
                success:function(data){
                    row.find('.unit_cost').val(data.purchase_price);
                }
            });

    });


    function calcStock() {
        let grandTotal = 0;
        $('#productsTbl tbody tr').each(function() {
            if (!$(this).find('.quantity').val()) return;
            const unit_cost = accounting.unformat($(this).find('.unit_cost').val());
            const qty = accounting.unformat($(this).find('.quantity').val());
            // const rowtax = $(this).find('.rowtax').val()/100 + 1;

            const amount = qty * unit_cost;
            grandTotal += amount;
        });
        $('#total_amount').val(grandTotal);
    }

    function select2Config(url, callback) {
        return {
            ajax: {
                url,
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({q: term, keyword: term}),
                processResults: callback
            }
        }
    }

    $('.datepicker')
        .datepicker({format: "{{ config('core.user_date_format')}}", autoHide:true})
        .datepicker('setDate', new Date())

    //Load Assembly Stations
    const assemblyStationsUrl = "{{ route('biller.stations.select') }}";
    function assemblyStations(data) {
        return {results: data.map(v => ({id: v.id, text: v.name}))};
    }
    $('#station').select2(select2Config(assemblyStationsUrl, assemblyStations));

    const productsUrl = "{{ route('biller.products.select') }}";
        function productsData(data) {

            return {results: data.map(v => ({id: v.id, text: v.name}))};
        }


    const carModelsUrl = "{{ route('biller.car-models.select') }}";
    function carModelsData(data) {
        return {results: data.map(v => ({id: v.id, text: v.name}))};
    }
    $('#car_model').select2(select2Config(carModelsUrl, carModelsData));




    // add title
    // let titleId = 2;
    // const titleHtml = $("#titleRow").html();
    // // $("#titleRow").remove();
    // $('#addShop').click(function() {
    //     // $('#productsTbl tbody tr.invisible').remove();

    //     const i = 't'+ titleId;
    //     const newTitleHtml = '<tr>' + titleHtml.replace(/t1/g, i) + '</tr>';
    //     $("#productsTbl tbody").append(newTitleHtml);
    //     titleId++;
    //     // calcTotal();
    //     // adjustTbodyHeight();
    // });

    // add product
    // let rowIdd = 1;
    // const rowHtml = $("#productRow").html();
    // $('#name-p0').autocomplete(autoComp('p0'));
    // $('#addProduct').click(function() {
    //     $('#quoteTbl tbody tr.invisible').remove();

    //     const i = 'p' + rowIdd;
    //     const newRowHtml = '<tr>' + rowHtml.replace(/p0/g, i) + '</tr>';
    //     $("#quoteTbl tbody").append(newRowHtml);
    //     $('#name-'+i).autocomplete(autoComp(i));
    //     updateLineTax($("#quoteTbl tbody tr:last").find('.tax_rate'));
    //     // trigger lead change to reset client pricelist
    //     $('#lead_id').change();

    //     adjustTbodyHeight();
    //     calcTotal();
    //     rowIdd++;
    // });

    // adjust tbody height to accomodate dropdown menu
    // function adjustTbodyHeight(rowCount) {
    // rowCount = rowCount || $('#quoteTbl tbody tr').length;
    // if (rowCount < 4) {
    //     const rows = [];
    //     for (let i = 0; i < 5; i++) {
    //         const tr = `<tr class="invisible"><td colspan="100%"></td><tr>`
    //         rows.push(tr);
    //     }
    //     $('#quoteTbl tbody').append(rows.join(''));
    // }
    // }

        // calculate profit
    //     const profitState = {sp_total: 0, bp_subtotal: 0, skill_total: 0, bp_total: 0};
    // function calcProfit() {
    //     const {sp_total, bp_total, skill_total} = profitState;
    //     const profit = sp_total - (bp_total + skill_total);
    //     let pcent_profit = profit/(bp_total + skill_total) * 100;
    //     pcent_profit = isFinite(pcent_profit) ? Math.round(pcent_profit) : 0;

    //     const profitText = bp_total > 0 ?
    //         `${accounting.formatNumber(profit)} : ${pcent_profit}%` : accounting.formatNumber(profit);
    //     $('.profit').text(profitText);

    //     if (profit < 0) $('.profit').removeClass('text-dark').addClass('text-danger');
    //     else $('.profit').removeClass('text-danger').addClass('text-dark');

    //     // budget limit 30 percent
    //     if (sp_total < bp_total * 1.3) $('.budget-alert').removeClass('d-none');
    //     else $('.budget-alert').addClass('d-none');

    //     // estimate cost
    //     $('.estimate-cost').text(accounting.formatNumber(bp_total + skill_total));
    // }

    // function autoComp(i) {
    //     return {
    //         source: function(request, response) {
    //             // stock product
    //             let term = request.term;
    //             let url = "{{ route('biller.products.quote_product_search') }}";
    //             let data = {
    //                 keyword: term,
    //                 price_customer_id: $('#price_customer').val(),
    //             };
    //             // maintenance service product
    //             const docType = @json(request('doc_type'));
    //             if (docType == 'maintenance') {
    //                 url = "{{ route('biller.taskschedules.quote_product_search') }}";
    //                 data.customer_id = $('#lead_id option:selected').attr('customer_id');
    //             }
    //             $.ajax({
    //                 url, data,
    //                 method: 'POST',
    //                 success: result => response(result.map(v => ({label: v.name, value: v.name, data: v}))),
    //             });
    //         },
    //         autoFocus: true,
    //         minLength: 0,
    //         select: function(event, ui) {
    //             const {data} = ui.item;

    //             $('#productid-'+i).val(data.id);
    //             $('#name-'+i).val(data.name);
    //             $('#unit-'+i).val(data.unit);
    //             $('#qty-'+i).val(1);

    //             const currencyRate = $('#currency option:selected').attr('currency_rate');
    //             if (currencyRate > 1) {
    //                 data.purchase_price = parseFloat(data.purchase_price) / currencyRate;
    //                 data.price = parseFloat(data.price) / currencyRate;
    //             }

    //             $('#buyprice-'+i).val(accounting.formatNumber(data.purchase_price));
    //             $('#estqty-'+i).val(1);

    //             const rate = parseFloat(data.price);
    //             let price = rate * ($('#tax_id').val()/100 + 1);
    //             $('#price-'+i).val(accounting.formatNumber(price));
    //             $('#amount-'+i).text(accounting.formatNumber(price));
    //             $('#rate-'+i).val(accounting.formatNumber(rate)).change();

    //             if (data.units) {
    //                 let units = data.units.filter(v => v.unit_type == 'base');
    //                 if (units.length) $('#unit-'+i).val(units[0].code);
    //             }
    //         }
    //     };
    // }

    // On clicking action drop down
    const shopHtml = $("#shopRow").html();
    const productHtml = $("#productRow").html();
    let rowIds = 0;
    $("#productsTbl").on("click", ".up, .down, .delete, .add-shop, .add-product, .add-misc", function() {
        const menu = $(this);
        const row = $(this).parents("tr:first");

        if (menu.is('.up')) row.insertBefore(row.prev());
        if (menu.is('.down')) row.insertAfter(row.next());
        if (menu.is('.delete') && confirm('Are you sure?')) {
            row.remove();
            $('#productsTbl tbody tr.invisible').remove();
            calcStock();
            adjustTbodyHeight(1);
        }

        // dropdown menus
        if (menu.is('.add-shop')) {
            // $('#addShop').click(function() {

            // });
            // const titleRow = $("#productsTbl tbody tr:last");
            // $("#productsTbl tbody tr:last").remove();
            row.before(`<tr>${shopHtml}</tr>`);
            // calcStock();
            $("#productsTbl tbody tr").each(function(i) {
                $(this).find('.index').val(i);
            });
        }
        if (menu.is('.add-product')) {
            // rowIds++;
            // let i = rowIds;
            // const html = productHtml.replace(/-0/g, '-'+i);

            // $('#addProduct').click();
            // const productRow = $("#productsTbl tbody tr:last");
            // $("#productsTbl tbody tr:last").remove();
            row.after(`<tr>${productHtml}</tr>`);
            // $('#product_name'+ i).select2(select2Config(productsUrl, productsData));
            $("#productsTbl tbody tr").each(function(i) {
                $(this).find('.index').val(i);
            });
            // calcStock();
            // update tax options
            // updateLineTax($("#productsTbl tbody tr:last").find('.tax_rate'));
        }
        // calcTotal();
    });

    // let tableRowId = 2;
        // let rowIds = 0;
    // $('#addProduct').click(function() {
    //     rowIds++;
    //     let i = rowIds;
    //     const html = tableRow.replace(/-0/g, '-'+i).replace(/d-none/g, '');
    //     $('#productsTbl tbody').append('<tr>' + html + '</tr>');
    // });



    </script>
@endsection
