{{ Html::script('focus/js/select2.min.js') }}
<script>
    // ajax config
    $.ajaxSetup({headers: { 'X-CSRF-TOKEN': "{{ csrf_token() }}" }});
     // initialize datepicker
     $('.datepicker').datepicker({format: "{{ config('core.user_date_format') }}", autoHide: true})
    $('#date').datepicker('setDate', new Date());
    $('#due_date').datepicker('setDate', new Date());
    $('#supplier').select2({allowClear: true});
    //add misc
    let miscId = 3;
    const miscHtml = $("#miscRow").html();
    $("#miscRow").remove();
    const miscUrl = "{{ route('biller.products.paper_search') }}";
    $('#product_name-e1').autocomplete(predict(miscUrl, stockSelect));
    $('#addMisc').click(function () {
        $('#bomTbl tbody tr.invisible').remove();

        const i = 'e'+miscId;
        const newmiscHtml = '<tr>' + miscHtml.replace(/e2/g, i) + '</tr>';
        $("#bomTbl tbody").append(newmiscHtml);
        $('#product_name-'+i).autocomplete(predict(miscUrl, stockSelect));
        miscId++;
    });
    //add paper
    let paperId = 2;
    const paperHtml = $("#paperRow").html();
    $("#paperRow").remove();
    const paperUrl = "{{ route('biller.products.paper_search') }}";
    $('#product_name-b1').autocomplete(predict(paperUrl, stockSelect));
    $('#addPaper').click(function () {
        $('#bomTbl tbody tr.invisible').remove();

        const i = 'b'+paperId;
        const newPaperHtml = '<tr>' + paperHtml.replace(/b1/g, i) + '</tr>';
        $("#bomTbl tbody").append(newPaperHtml);
        $('#product_name-'+i).autocomplete(predict(paperUrl, stockSelect));
        paperId++;
    });
     //add Item
     let itemId = 1;
    const itemHtml = $('#itemRow').html();
    const itemUrl = "{{ route('biller.products.purchase_search') }}";
    $('#product_name-m0').autocomplete(predict(itemUrl,stockSelect));
    $('#addItem').click(function () {
        $('#bomTbl tbody tr.invisible').remove();
        const i = 'm' + itemId;
        const newItemHtml = '<tr>' + itemHtml.replace(/m0/g, i) + '</tr>';
        $("#bomTbl tbody").append(newItemHtml);
        $('#product_name-'+i).autocomplete(predict(itemUrl,stockSelect));
        itemId++;
    });
    //Remove items and paper on BomTable
    $('#bomTbl').on('click', '.remove', function () {
        const menu = $(this);
        const row = $(this).parents("tr:first");
        if (menu.is('.remove') && confirm('Are you sure?')) {
            row.remove();
            $('#bomTbl tbody tr.invisible').remove();
           // adjustTbodyHeight(1);
        }
    })

    let productNameId = 0;
    function stockSelect(event, ui) {
        const {data} = ui.item;
        const i = productNameId;
        $('#itemId-'+i).val(data.id);
        $('#product_name-'+i).val(data.name);

        const purchasePrice = accounting.unformat(data.purchase_price);
        $('#purchase_price-'+i).val(accounting.formatNumber(purchasePrice)).change();

        $('#uom-'+i).html('');
        if(data.uom){
            
            $('#uom-'+i).val(data.uom);
        }
        
    }
    $('#bomTbl').on('mouseup', '.product_name', function() {
        const id = $(this).attr('id').split('-')[1];
        if ($(this).is('.product_name')) productNameId = id;
    });  

    // on change qty and rate
    $("#bomTbl").on("change", ".quantity, .purchase_price", function() {
        const id = $(this).attr('id').split('-')[1];

        const qty = accounting.unformat($('#quantity-'+id).val());
        let rate = accounting.unformat($('#purchase_price-'+id).val());
        $('#total_amount-'+id).text(accounting.formatNumber(qty * rate, 4));
        calBom();
    });
    // compute totals
    function calBom() {
        let total = 0;
        $("#bomTbl tbody tr").each(function(i) {
            const amount = accounting.unformat($(this).find('.total_amount').text());
            total += amount;
        });
        $('#total_bom').val(accounting.formatNumber(total));
    }

    function predict(url, callback) {
        return {
            source: function(request, response) {
                $.ajax({
                    url,
                    dataType: "json",
                    method: "POST",
                    data: {keyword: request.term, pricegroup_id: $('#pricegroup_id').val()},
                    success: function(data) {
                        response(data.map(v => ({
                            label: v.name,
                            value: v.name,
                            data: v
                        })));
                    }
                });
            },
            autoFocus: true,
            minLength: 0,
            select: callback
        };
    }

</script>
