<div class="form-group row">
    <div class="col-2">
        <label for="title">Request For Dispatch No.</label>
        {{ Form::text('tid', gen4tid('RFD-', @$request_dispatch? $request_dispatch->tid : @$tid+1), ['class' => 'form-control', 'disabled']) }}
        {{ Form::hidden('tid', @$request_dispatch? $request_dispatch->tid : @$tid+1) }}
    </div>
    <div class="col-4">
        <label for="customer">Customer</label>
        <select name="customer_id" id="customer" class="form-control" data-placeholder="Search Customer">
            <option value="">Search Customer</option>
            @foreach ($customers as $customer)
                <option value="{{ $customer->id }}" {{$customer->id == @$request_dispatchs->customer_id ? 'selected' : ''}}>{{ $customer->company }}</option>
            @endforeach
        </select>
    </div>

    <div class="col-2">
        <label for="date">Date</label>
        {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date']) }}
    </div>
    <div class="col-2">
        <label for="select-item">Type of Product</label>
        <select name="item_type" class="form-control custom-select" id="item_type">
            <option value="">----Select Type ------</option>
            @foreach (['jobcard','waste'] as $item)
                <option value="{{$item}}" {{$item == @$request_dispatchs->item_type ? 'selected' : ''}}>{{ ucfirst($item) }}</option>
            @endforeach
        </select>
    </div>
      
</div>

<div class="form-group row">
    <div class="col-12">
        <label for="description">Description</label>
        {{ Form::textarea('description', null, ['class' => 'form-control','row'=>'1.5', 'id' => 'description', 'placeholder'=> 'Description']) }}
    </div>
    
    
</div>

@include('focus.request_dispatchs.partials.add-items')


@section('extra-scripts')
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        predict: (url, callback) => {
            return {
                source: function(request, response) {
                    $.ajax({
                        url,
                        dataType: "json",
                        method: "POST",
                        data: {keyword: request.term, customer_id: $('#customer').val()},
                        success: function(data) {
                            response(data.map(v => ({
                                label: v.name,
                                value: v.name,
                                data: v
                            })));
                        }
                    });
                },
                autoFocus: true,
                minLength: 0,
                select: callback
            };
        },
        fetchJobcard: (customer_id, item_type) => {
            return $.ajax({
                url: "{{ route('biller.products.jobcard_search') }}",
                type: 'POST',
                quietMillis: 50,
                data: {customer_id, item_type},
            });
        },
        fetchWaste: (customer_id, item_type) => {
            return $.ajax({
                url: "{{ route('biller.products.jobcard_search') }}",
                type: 'POST',
                quietMillis: 50,
                data: {customer_id, item_type},
            });
        },
    };

    const Form = {
        requestDispatch: @json(@$request_dispatch),
        rowIds: 0,
        tableRow: $('#requisitionTbl tbody tr:first').html(),
        stockUrl: "{{ route('biller.products.waste_search') }}",
        jobcardUrl: "{{ route('biller.products.jobcard_search') }}",

        init() {
            $.ajaxSetup(config.ajax);
            $('#customer').select2({allowClear: true});
            $('.datepicker').datepicker(config.date);
            $('#requisitionTbl tbody').on('change', '.total_qty', this.calculateChange);
            $('#item_type').change(this.itemChange);
            $('#requisitionTbl').on('change', '.check', this.checkChange);
            // initialize html editor
            editor();

            if (this.requestDispatch) {
                const request = this.requestDispatch;
                $('#date').datepicker('setDate', new Date(request.date));
            } else {
                // $('#customer').val('').change();
                $('.datepicker').datepicker('setDate', new Date());
            }
            $('#customer').change(this.customerChange);
            $('#requisitionTbl tbody tr:first').remove();
            // $('#item_type').change(function () { 
            //     if ($(this).val() == 'jobcard') {

            //         $('.name').autocomplete(config.predict(this.jobcardUrl, Form.jobcardSelect));
            //     }
            //     else if ($(this).val() == 'waste') {

            //         $('.name').autocomplete(config.predict(this.stockUrl, Form.stockSelect));
            //     }
            // });
            
            
            $('#addstock').click(this.addItem);
            $('#requisitionTbl').on('click', '.remove', this.removeRow);
            
            
        },
        customerChange() {
            $('#item_type').val('');
            $('#requisitionTbl tbody').html('');
        },
        itemChange() {
            const el = $(this);
            const customer_id = $('#customer').val();
            $('#requisitionTbl tbody').html('');
            if (!el.val()) return;
            config.fetchJobcard(customer_id, el.val()).done(data => {
                data.forEach((v,i) => {
                    $('#requisitionTbl tbody').append(Form.productRow(v,i));
                });
            });
            
        },

        productRow(v,i) {
            
            return `
            <tr>
                <td><input type="checkbox" class="check"></td> 
                <td>
                    <input type="text" class="form-control name" value="${v.jobcard_no}" name="name[]" id="name-0" placeholder="Search JobCard/Product" disabled>
                </td>
                <td><input type="text" class="form-control box_bundle"  id="box_bundle-0" name="box_bundle[]" disabled></td>
                <td><input type="text" class="form-control no_of_bundle" id="no_of_bundle-0" name="no_of_bundle[]" disabled></td>
                <td><input type="datetime-local" class="form-control datetime" id="datetime-0" name="datetime[]" disabled></td> 
                <td><input type="text" class="form-control qty" id="qty-0" value="${v.remains}" disabled></td> 
                <td><input type="text" class="form-control total_qty" id="total_qty-0" name="total_qty[]" disabled></td> 
                <td><input type="text" class="form-control balance_instock" id="balance_instock-0" name="balance_instock[]" disabled></td> 

                <input type="hidden" name="item_id[]" value="${v.item_id}" class="item_id" id="item-id-0" value="0" disabled>
                <input type="hidden" name="jobcard_id[]" value="${v.jobcard_id}" class="jobcard_id" id="jobcard-0" value="0" disabled>
                <input type="hidden" name="id[]" class="id" value="0" disabled>
                <input type="hidden" name="type[]" class="type" value="${v.type}" id="type-0" value="" disabled>

            </tr>
            `;
        },
        checkChange() {
            const el = $(this);
            const row = el.parents('tr:first');
            if (el.is('.check:checked')) {
                row.find('.name').attr('disabled', false);
                row.find('.name').attr('readonly', true);
                row.find('.box_bundle').attr('disabled', false);
                row.find('.no_of_bundle').attr('disabled', false);
                row.find('.datetime').attr('disabled', false);
                row.find('.qty').attr('disabled', false);
                row.find('.qty').attr('readonly', true);
                row.find('.total_qty').attr('disabled', false);
                row.find('.balance_instock').attr('disabled', false);
                row.find('.balance_instock').attr('readonly', true);
                row.find('.item_id').attr('disabled', false);
                row.find('.jobcard_id').attr('disabled', false);
                row.find('.id').attr('disabled', false);
                row.find('.type').attr('disabled', false);
                
            }else{
                row.find('.name').attr('disabled', true);
                row.find('.box_bundle').attr('disabled', true);
                row.find('.no_of_bundle').attr('disabled', true);
                row.find('.datetime').attr('disabled', true);
                row.find('.qty').attr('disabled', true);
                row.find('.total_qty').attr('disabled', true);
                row.find('.balance_instock').attr('disabled', true);
                row.find('.item_id').attr('disabled', true);
                row.find('.jobcard_id').attr('disabled', true);
                row.find('.id').attr('disabled', true);
                row.find('.type').attr('disabled', true);
            }
        },
        addItem() {
            Form.rowIds++;
            let i = Form.rowIds;
            const html = Form.tableRow.replace(/-0/g, '-'+i);
            $('#requisitionTbl tbody').append('<tr>' + html + '</tr>');
            if ($('#item_type').val() == 'jobcard') {
                $('.name').autocomplete(config.predict(Form.jobcardUrl, Form.jobcardSelect));
            }
            else if ($('#item_type').val() == 'waste') {
                $('.name').autocomplete(config.predict(Form.stockUrl, Form.stockSelect));
            }
           // $('#requisitionTbl').on('change','.deduct', deduct);
        },
        removeRow() {
            const $tr = $(this).parents('tr:first');
            $tr.remove();
        },
        stockSelect(event, ui) {
            const {data} = ui.item;
            // console.log(ui);
            const i =  Form.rowIds;
            $('#item-id-'+i).val(data.id);
            $('#name-'+i).val(data.name);
            $('#qty-'+i).val(data.qty);
            $('#type-'+i).val('waste');

            if(data.uom){
                $('#uom-'+i).val(data.uom);
                $('#unit-'+i).val(data.unit);
            }
            
        },
        jobcardSelect(event, ui) {
            const {data} = ui.item;
            const i =  Form.rowIds;
            $('#jobcard-'+i).val(data.id);
            $('#name-'+i).val(data.jobcard_no);
            $('#qty-'+i).val(data.total_qty);
            $('#type-'+i).val('jobcard');


            if(data.uom){
                $('#uom-'+i).val(data.uom);
                $('#unit-'+i).val(data.unit);
            }
            
        },
        calculateChange() {
            const el = $(this);
            const row = el.parents('tr:first');
            const total_qty = accounting.unformat(row.find('.total_qty').val());
            const qty = accounting.unformat(row.find('.qty').val());
            let balance = 0;
            if(total_qty > qty){
                row.find('.total_qty').val(qty)
                // balance = qty-total_qty;
                row.find('.balance_instock').val(0)
            }else{
                balance = qty-total_qty;
                row.find('.balance_instock').val(balance)
            }
            // console.log();
        },
       
    };

    $(() => Form.init());
</script>
@endsection
