<div class="row">
    <!-- Quote -->
    <div class="col-6">
        <h3 class="form-group">
            @php
                $title_arr = explode(' ', $words['title']);
                $title = implode(' ', [$title_arr[0], ...array_splice($title_arr, 1)]);
            @endphp
            {{ $title }}
        </h3>
        <div class="form-group row">
            <div class="col-8">
                <label for="customer">Customer</label>
                <div class="input-group">
                    <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
                    <select class="form-control" name="customer_id" id="customer" data-placeholder="Search Customer" required> 
                        <option value=""></option>                                                
                        @foreach ($customers as $customer)
                            <option value="{{ $customer->id }}" {{@$quote->customer_id == $customer->id ? 'selected': ''}}>{{ $customer->name }}</option>
                        @endforeach                                                                                      
                    </select>
                    {{-- <input type="hidden" name="branch_id" id="branch_id" value="0">
                    <input type="hidden" name="customer_id" id="customer_id" value="0"> --}}
                </div>
            </div>
            <div class="col-4">
                <label for="currency" >Currency</label>
                <div class="input-group row no-gutters">
                    <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
                    <select class="custom-select" name="currency_id" id="currency" data-placeholder="{{trans('tasks.assign')}}" required>
                        @foreach ($currencies as $currency => $rate)
                        <option value="{{ $rate->id }}" data-rate="{{numberClean($rate->rate)}}" data-code="{{$rate->code}}" {{ @$quote->currency_id == $rate->id ? 'selected' : ''}}>{{ $rate->code }}</option>
                        @endforeach
                    </select>
                    {{ Form::text('currency_rate', null, ['class' => 'form-control currency_rate', 'id' => 'currency_rate']) }}
                </div>
            </div>
        </div>

        <div class="form-group row">
            
            <div class='col-8'>
                <label for="print_type" >Print Type</label>
                <div>                    
                    <div class="d-inline-block custom-control custom-checkbox mr-1">
                        <input type="radio" class="custom-control-input bg-primary" name="print_type" value="inclusive" id="colorCheck6">
                        <label class="custom-control-label" for="colorCheck6">VAT-Inclusive</label>
                    </div>
                    <div class="d-inline-block custom-control custom-checkbox">
                        <input type="radio" class="custom-control-input bg-purple" name="print_type" value="exclusive" id="colorCheck7" checked>
                        <label class="custom-control-label" for="colorCheck7">VAT-Exclusive</label>
                    </div>
                </div>
            </div>
            <div class="col-4">
                <label for="taxFormat">Tax</label>
                <select class="custom-select" name='tax_id' id="tax_id">
                    @foreach ($additionals as $row)
                        <option value="{{ +$row->value }}" {{ @$quote && round($row->value) == @$quote->tax_id ? 'selected' : '' }}>
                            {{ $row->name }}
                        </option>
                    @endforeach                                            
                </select>
                <input type="hidden" name="tax_format" value="exclusive" id="tax_format">
            </div> 
           
            

            
        </div>

    </div>

    <!-- Properties -->
    <div class="col-6">
        <h3 class="form-group">{{ trans('quotes.properties')}}</h3>
        <div class="form-group row">
           
            <div class="col-4">
                <label for="date">{{trans('general.date')}}</label>
                <div class="input-group">
                    <div class="input-group-addon"><span class="icon-calendar4" aria-hidden="true"></span></div>
                    {{ Form::text('date', null, ['class' => 'form-control round datepicker', 'id' => 'date']) }}
                </div>
            </div>
            <div class="col-4">
                <label for="terms">Terms</label>
                <select id="term_id" name="term_id" class="custom-select" required>
                    <option value="">-- Select Term --</option>
                    @foreach($terms as $term)
                        <option value="{{ $term->id }}" {{ $term->id == @$quote->term_id ? 'selected' : '' }}>
                            {{ $term->title }}
                        </option>
                    @endforeach
                </select>               
            </div>  
            <div class="col-4"><label for="validity" >Validity Period</label>
                <div class="input-group">
                    <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
                    <select class="custom-select round" name="validity" id="validity">
                        @php
                            $selected = '';
                        @endphp
                        @foreach ([0, 14, 30, 45, 60, 90] as $val)
                            @php
                                if (isset($quote)) $selected =  $val == @$quote->validity? 'selected' : '';
                                else $selected = $val == 0? 'selected' : '';
                            @endphp
                            <option value="{{ $val }}" {{ $selected }}>
                                {{ $val ? 'Valid For '.$val.' Days' : 'On Receipt' }}
                            </option>
                        @endforeach                                                
                    </select>
                </div>
            </div>                                  
        </div>

        <div class="form-group row">
           
            <div class="col-6"><label for="source" >Source</label>
                <div class="input-group">
                    <div class="input-group-addon"><span class="icon-calendar4" aria-hidden="true"></span></div>
                    {{ Form::text('source', null, ['class' => 'form-control round', 'id' => 'source']) }}
                </div>
            </div>    
                                                                                 
        </div>
        
    </div>                        
</div>
<div class="form-group row">
        <div class="col-12">
            <label for="subject" >Subject / Title</label>
            {{ Form::text('notes', null, ['class' => 'form-control', 'id' => 'subject', 'placeholder' => 'Subject or Title', 'required']) }}
        </div>
</div>
<!-- quotes item table -->
@include('focus.quotes.partials.quote_items')
<!-- footer -->
<div class="form-group row">
    <div class="col-9">
        <a href="javascript:" class="btn btn-success" id="addProduct"><i class="fa fa-plus-square"></i> Add Product</a>
        {{-- <a href="javascript:" class="btn btn-primary" id="addTitle"><i class="fa fa-plus-square"></i> Add Paper</a> --}}
        <a href="javascript:" class="btn btn-secondary ml-1 d-none" data-toggle="modal" data-target="#skillModal" id="addSkill">
            <i class="fa fa-wrench"></i> Labour
        </a>
    </div>
    <div class="col-3">
        <div>
            <label><span class="text-primary">(Estimated Cost: <span class="estimate-cost font-weight-bold text-dark">0.00</span>)</span></label>
        </div>
        <div>
            <label class="m-0">Taxable Amount</label>
            <input type="text" name="taxable" id="taxable" class="form-control" readonly>    
        </div>
        <div>
            <label class="m-0">SubTotal</label>
            <input type="text" name="subtotal" id="subtotal" class="form-control" readonly>    
        </div>
        <div>
            <label id="tax-label" class="m-0">
                {{ trans('general.total_tax') }}
                <span id="vatText" class="text-primary">(Print VAT-Exc)</span>
            </label>
            <input type="text" name="tax" id="tax" class="form-control" readonly>
        </div>
        <div>
            <label class="m-0">
                {{trans('general.grand_total')}}
                <b class="text-primary">(E.P: &nbsp;<span class="text-dark profit">0</span>)</b>
            </label>
            <input type="text" name="total" class="form-control" id="total" readonly>
        </div>
        {{ Form::submit('Generate', ['class' => 'btn btn-success btn-lg mt-1']) }}
    </div>
</div>