@extends ('core.layouts.app')

@section ('title', 'QC Questions Managment' . ' | ' . 'View')

@section('page-header')
    <h1>
        {{ 'QC Questions Managment' }}
        <small>{{ 'View' }}</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h3 class="content-header-title mb-0">{{ 'View' }}</h3>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.departments.partials.departments-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-content">

                                <div class="card-body">


                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Process Name</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{@$question->process['process_name']}}</p>
                                        </div>
                                    </div>




                                </div>
                                <div class="card-body">
                                    <table class="table table-boardered text-center" id="questionsTbl" width="100%">
                                        <thead>
                                            <tr class="item_header bg-gradient-directional-blue white">
                                
                                                <th>Questions</th>
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($question->items as $item)
                                                <tr>
                                                    <td>{{$item->question}}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
