@extends ('core.layouts.app')

@section ('title', 'QC Questions Managment' . ' | ' . 'Edit')

@section('page-header')
    <h1>
        {{ 'QC Questions Managment' }}
        <small>{{ 'Edit' }}</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h4 class="content-header-title mb-0">{{ 'Edit' }}</h4>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.questions.partials.questions-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-content">

                                <div class="card-body">
                                    {{ Form::model($questions, ['route' => ['biller.questions.update', $questions], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'PATCH', 'id' => 'edit-department']) }}

                                    <div class="form-group">
                                        {{-- Including Form blade file --}}
                                        @include("focus.questions.form")
                                        <div class="edit-form-btn">
                                            {{ link_to_route('biller.questions.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                            {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                            <div class="clearfix"></div>
                                        </div><!--edit-form-btn-->
                                    </div><!--form-group-->

                                    {{ Form::close() }}
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
       const config = {
            ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
            date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
            select2: {allowClear: true},
       };
       const Form = {
            rowIds: $("#questionsTbl tbody tr").length,
            tableRow: $('#questionsTbl tbody tr:first').html(),
            init(){
                $.ajaxSetup(config.ajaxSetup);
                $('#process').select2(config.select2);
                $("#questionsTbl tbody tr:first").remove();
                $('#addstock').click(this.addItem);
                $('#questionsTbl').on('click', '.remove', this.removeRow);
            },
            addItem() {
                Form.rowIds++;
                let i = Form.rowIds;
                const html = Form.tableRow.replace(/-0/g, '-'+i);
                $('#questionsTbl tbody').append('<tr>' + html + '</tr>');
            },
            removeRow() {
                const $tr = $(this).parents('tr:first');
                $tr.remove();
            },
       };
       $(()=>Form.init());
    </script>
@endsection