<div class="">
    <table class="table-responsive tfr my_stripe" id="expTbl">
        <thead>
            <tr class="item_header bg-gradient-directional-blue white">
                <th width="30%" class="text-center">Account Name</th>
                <th width="8%" class="text-center">{{trans('general.quantity')}}</th>
                <th width="8%" class="text-center">UoM</th>
                <th width="10%" class="text-center">{{trans('general.rate')}}</th>
                <th width="10%" class="text-center">{{trans('general.tax_p')}}</th>
                <th width="8%" class="text-center">Tax</th>
                <th width="10%" class="text-center">{{trans('general.amount')}}</th>
                <th width="5%" class="text-center">{{trans('general.action')}}</th>
            </tr>
        </thead>
        <tbody>
            <!-- layout -->
            <tr>
                <td>
                    <input type="text" class="form-control accountname" name="name[]" id="accountname-0" placeholder="Enter Ledger Account" autocomplete="off">
                    <input type="hidden" id="expitemid-0" name="product_id[]">
                </td>
                <td><input type="text" class="form-control exp_qty" name="qty[]" id="expqty-0" value="1"></td>
                <td><input type="text" class="form-control exp_uom" name="uom[]" id="expuom-0"></td>
                <td><input type="text" class="form-control exp_price" name="purchase_price[]" id="expprice-0"></td>
                <td>
                    <select class="form-control exp_vat" name="tax_rate[]" id="expvat-0">
                        @foreach ($additionals as $tax)
                            <option value="{{ (int) $tax->value }}" {{ $tax->is_default ? 'selected' : ''}}>
                                {{ $tax->name }}
                            </option>
                        @endforeach                                                    
                    </select>
                </td>  
                <td class="text-center"><span class="exp_tax" id="exptax-0">0</span></td>
                <td> <b><span class="exp_amount" id="expamount-0">0</span></b></td>
                <td><button type="button" class="btn btn-danger remove"><i class="fa fa-minus-square"></i></button></td>
                <input type="hidden" class="exptaxr" name="itemtax[]">
                <input type="hidden" class="expamountr" name="item_total[]">
                <input type="hidden" class="stockforeigntaxr" name="foreign_taxable[]">
                <input type="hidden" class="stockforeignamountr" name="foreign_total[]">
                <input type="hidden" class="form-control foreignprice" name="foreign_price[]" id="foreignprice-0">
                <input type="hidden" name="type[]" value="expense">
                <input type="hidden" name="id[]" value="0">
            </tr>
            <tr>
                <td colspan="4">
                    <textarea id="expdescr-0" class="form-control descr" name="description[]" placeholder="Enter Description"></textarea>
                </td>
                <td colspan="5">
                    <input type="text" class="form-control projectexp" id="projectexptext-0" placeholder="Search Project by Name, Customer, Branch">
                    <input type="hidden" name="project_id[]" id="projectexpval-0">
                </td>
                
            </tr>
            <!-- end layout -->

            <!-- fetched rows -->
            @isset ($purchase)
                @php ($i = 0)
                
                @foreach ($purchase->products as $item)
                    @if ($item->type == 'expense')
                        <tr>
                            <td><input type="text" class="form-control accountname" name="name[]" value="{{ @$item->account->holder }}" id="accountname-{{$i}}" placeholder="Enter Ledger"></td>
                            <td><input type="text" class="form-control exp_qty" name="qty[]" value="{{ number_format($item->qty, 1) }}" id="expqty-{{$i}}"></td>
                            <td><input type="text" class="form-control exp_uom" name="uom[]" value="{{ $item->uom }}" id="expuom-{{$i}}"></td>
                            <td><input type="text" class="form-control exp_price" name="purchase_price[]" value="{{ (float) $item->purchase_price }}" id="expprice-{{$i}}"></td>
                            <td>
                                <select class="form-control exp_vat" name="tax_rate[]" id="expvat-{{$i}}">
                                    @foreach ($additionals as $tax)
                                        <option value="{{ (int) $tax->value }}" {{ $tax->value == $item->tax_rate ? 'selected' : ''}}>
                                            {{ $tax->name }}
                                        </option>
                                    @endforeach                  
                                </select>
                            </td>                          
                            <td class="text-center"><span class="exp_tax" id="exptax-{{$i}}">{{ (float) $item->tax_rate }}</span></td>
                            <td> <b><span class="exp_amount" id="expamount-{{$i}}">{{ (float) $item->total }}</span></b></td>
                            <td><button type="button" class="btn btn-danger remove"><i class="fa fa-minus-square"></i></button></td>
                            <input type="hidden" id="expitemid-{{$i}}" name="product_id[]"value="{{ $item->product_id }}" >
                            <input type="hidden" class="exptaxr" name="itemtax[]" value="{{ (float) $item->tax }}">
                            <input type="hidden" class="exptotalr" name="item_total[]" value="{{ (float) $item->total }}">
                            <input type="hidden" name="type[]" value="expense">
                            <input type="hidden" name="id[]" value="{{ $item->id }}">
                            <input type="hidden" name="warehouse_id[]">
                            <input type="hidden" class="stockforeignamountr" name="foreign_total[]">
                            <input type="hidden" class="stockforeigntaxr" name="foreign_taxable[]">
                            <input type="hidden" class="form-control foreignprice" name="foreign_price[]" id="foreignprice-{{$i}}">
                        </tr>
                        <tr>
                            <td colspan="4">
                                <textarea id="expdescr-{{$i}}" class="form-control descr" name="description[]" placeholder="Enter Description">{{ $item->name }}</textarea>
                            </td>
                            <td colspan="5">
                                <input type="text" class="form-control projectexp" id="projectexptext-{{$i}}" value="{{ $item->project ? $item->project->name : '' }}" placeholder="Search Project by Name, Customer, Branch">
                                <input type="hidden" name="project_id[]" value="{{ $item->project_id }}" id="projectexpval-{{$i}}">
                            </td>
                        </tr>
                        @php ($i++)
                    @endif
                @endforeach
            @endisset
            <!-- end fetched rows -->

            <tr class="bg-white">
                <td>
                    <button type="button" class="btn btn-success" aria-label="Left Align" id="addexp">
                        <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
                    </button>
                </td>
                <td colspan="6"></td>
            </tr>
            <tr class="bg-white">
                <td colspan="5" align="right"><b>{{trans('general.total_tax')}}</b></td>
                <td align="left" colspan="2"><span id="exprow_taxttl" class="lightMode">0</span></td>
            </tr>
            <tr class="bg-white">
                <td colspan="5" align="right"><b>Expense Total ({{config('currency.symbol')}})</b></td>
                <td align="left" colspan="2">
                    <input type="text" class="form-control" name="total" value="0.00" id="exp_grandttl" readonly>
                    <input type="hidden" name="subtotal" value="0.00" id="exp_subttl">
                    <input type="hidden" name="taxable" value="0.00" id="exp_tax">
                    <input type="hidden" name="frx_taxable" value="0.00" id="fx_taxable">
                      <input type="hidden" name="frx_total" value="0.00" id="fx_total">
                      <input type="hidden" name="frx_subtotal" value="0.00" id="fx_subtotal">
                </td>
            </tr>
        </tbody>
    </table>
</div>
