<div class="row">
    <div class="col-sm-6 cmp-pnl">
        <div id="customerpanel" class="inner-cmp-pnl">
            <h3 class="title">Purchase </h3>                                                                
            <div class="form-group row">
                <div class="col-12">
                    <label for="payer" class="caption">Search Supplier</label>                                       
                    <select class="form-control" id="supplierbox" data-placeholder="Search Supplier"></select>
                    <input type="hidden" name="supplier_id" value="0" id="supplierid">
                </div>
            </div>
            
            <div class="form-group row">
                <div class="col-sm-8">
                    <label for="payer" class="caption">Supplier Name*</label>
                    <div class="input-group">
                        <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>                                            
                        {{ Form::text('suppliername', null, ['class' => 'form-control round', 'placeholder' => 'Supplier Name', 'id' => 'supplier', 'disabled']) }}
                    </div>
                </div>
                <div class="col-sm-4"><label for="taxid" class="caption">Tax ID</label>
                    <div class="input-group">
                        <div class="input-group-addon"><span class="icon-bookmark-o" aria-hidden="true"></span></div>
                        {{ Form::text('supplier_taxid', null, ['class' => 'form-control round', 'placeholder' => 'Tax Id', 'id' => 'taxid', 'disabled']) }}
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <div class="col-sm-12">
                    <label for="toAddInfo" class="caption">{{trans('general.note')}}*</label>
                    {{ Form::textarea('note', null, ['class' => 'form-control', 'placeholder' => trans('general.note'), 'rows'=>'2', 'required']) }}
                    {{ Form::hidden('document_type', 'lpo_expense', ['class' => 'form-control']) }}
                </div>
            </div>
            
        </div>
    </div>

    <div class="col-sm-6 cmp-pnl">
        <div class="inner-cmp-pnl">
            <h3 class="title">{{trans('purchaseorders.properties')}}</h3>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="tid" class="caption">Order No.</label>
                    <div class="input-group">
                        <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
                        {{ Form::text('tid', gen4tid("{$prefixes[0]}-", @$po? $po->tid : $last_tid+1), ['class' => 'form-control round', 'disabled']) }}
                        {{ Form::hidden('tid', @$po? $po->tid : $last_tid+1) }}
                    </div>
                </div>
                <div class="col-sm-4"><label for="transaction_date" class="caption">Order Date*</label>
                    <div class="input-group">                                            
                        {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date']) }}
                    </div>
                </div>
                <div class="col-sm-4"><label for="due_date" class="caption">Due Date*</label>
                    <div class="input-group">                                            
                        {{ Form::text('due_date', null, ['class' => 'form-control datepicker', 'id' => 'due_date']) }}
                    </div>
                </div>
            </div>

            <div class="form-group row">
                <div class="col-3">
                    <label for="currency">Currency</label>
                    <select name="currency" class="form-control currency" id="currency">
                        @foreach ($currency as $rate)
                            <option value="{{ $rate->id }}" data-rate="{{numberClean($rate->rate)}}" data-code="{{$rate->code}}" {{ $rate->id == @$po->currency ? 'selected' : ''}}>{{ $rate->code }}</option>
                        @endforeach
                    </select>
                   
                </div>
                <div class="col-3">
                    <label for="currency_rate">Currency Rate</label>
                    {{ Form::text('currency_rate', null, ['class' => 'form-control currency_rate', 'id' => 'currency_rate']) }}
                </div>
                <div class="col-3">
                    <label for="taxFormat" class="caption">Tax</label>
                    <select class="custom-select" name="tax" id="tax">
                        @foreach ($additionals as $row)
                            <option value="{{ +$row->value }}" {{ $row->is_default ? 'selected' : ''}}>
                                {{ $row->name }} 
                            </option>
                        @endforeach                                                    
                    </select>
                </div>

                <div class="col-3">
                    <label for="terms">Terms</label>
                    <select name="term_id" class="form-control">
                        @foreach ($terms as $term)
                            <option value="{{ $term->id }}" {{ $term->id == @$po->term_id ? 'selected' : ''}}>
                                {{ $term->title }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            
            
        </div>
    </div>
</div>

<!-- Tab Menus -->
@include('focus.purchaseorders.partials.stock_tab')
{{ Form::submit('Generate Purchase Order', ['class' => 'btn btn-success sub-btn btn-lg']) }}
<input type="hidden" name="supplier_type" value="supplier">