@extends('core.layouts.app')

@section('title', 'Purchase/Order | Create')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Purchase Request Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.purchaseorders.partials.purchaseorders-header-buttons')
                </div>
            </div>
        </div> 
    </div>    

    <div class="content-body"> 
        <div class="card">
            <div class="card-body">
                {{ Form::open(['route' => 'biller.purchaseorders.store', 'method' => 'POST']) }}
                    @include('focus.purchaseorders.form')
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script(mix('js/dataTable.js')) }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
    };

    const Index = {
        jobcard: @json(request('job_card')),
        init() {
            $.ajaxSetup(config.ajax);
            $('#requestsTbl tbody').on('click', '.check', this.checkOne);
            $('#requestsTbl tbody').on('change', '.price, .qty_purchased, .rowtax', this.calculateChange);
            $('#tax').change(this.taxChange).change();
            $('#lpo_include').change(this.lpoChange);
            // $('#stock_grandttl').change(this.totalChange);
            $('#filters').on('change', '#supplierbox, #item_type, #preffered',this.item_type);
            this.drawDataTable();
        },

        // totalChange() {
        //     console.log($('#stock_grandttl').val());
        //     if($(this).val() > 0){
        //         $('.sub-btn').prop('disabled', false);
        //     }
        // },

        item_type() {
            const item_type = $('#item_type').val();
            const supplier_id = $('#supplierid').val();
            const preffered = $('#preffered').val();
            // console.log(item_type, supplier_id);
            $('#requestsTbl').DataTable().destroy();
            return Index.drawDataTable({
                item_type: item_type,
                supplier_id: supplier_id,
                preffered: preffered
                // client_id: $('#client').val()
            });  
        },

        lpoChange() {
            if ($(this).val() == 'with_lpo') {
                $('.doc_ref_type').addClass('d-none')
                $('.doc_ref').addClass('d-none');
                $('#doc_ref_type').attr('disabled', true)
                $('#doc_ref').attr('disabled', true)
                $('.validity').removeClass('d-none');
                $('.terms').removeClass('d-none');
                $('#validity').attr('disabled', false);
                $('#terms').attr('disabled', false);
            }else if($(this).val() == 'without_lpo'){
                $('.doc_ref_type').removeClass('d-none')
                $('.doc_ref').removeClass('d-none')
                $('#doc_ref_type').attr('disabled', false)
                $('#doc_ref').attr('disabled', false)
                $('.validity').addClass('d-none');
                $('#validity').attr('disabled', true);
                $('.terms').addClass('d-none');
                $('#terms').attr('disabled', true);
            }
        },
        checkOne(){
            const el = $(this);
            const row = el.parents('tr:first');
            if(el.is('.check:checked')){
                row.find('.pid').attr('disabled', false);
                row.find('.qty_purchased').attr('disabled', false);
                row.find('.price').attr('disabled', false);
                row.find('.amount').attr('disabled', false);
                row.find('.amount').attr('disabled', false);
                row.find('.taxable').attr('disabled', false);
                row.find('.product_id').attr('disabled', false);
                row.find('.product_name').attr('disabled', false);
                row.find('.rowtax').attr('disabled', false);
                row.find('.stocktaxr').attr('disabled', false);
                row.find('.unit_id').attr('disabled', false);
                row.find('.item_type').attr('disabled', false);
                row.find('.taxable').attr('readonly', true);
                row.find('.amount').attr('readonly', true);
                // row.find('.unit_id').attr('readonly', true);
            }else{
                row.find('.pid').attr('disabled', true);
                row.find('.qty_purchased').attr('disabled', true);
                row.find('.price').attr('disabled', true);
                row.find('.amount').attr('disabled', true);
                row.find('.taxable').attr('disabled', true);
                row.find('.product_id').attr('disabled', true);
                row.find('.product_name').attr('disabled', true);
                row.find('.stocktaxr').attr('disabled', true);
                row.find('.rowtax').attr('disabled', true);
                row.find('.unit_id').attr('disabled', true);
                row.find('.item_type').attr('disabled', true);
            }
        },

        calculateChange() {
            const el = $(this);
            const row = el.parents('tr:first');
            const qty_purchase = accounting.unformat(row.find('.qty_purchased').val());
            const price = accounting.unformat(row.find('.price').val());
            const amount = price*qty_purchase;
            row.find('.amount').val(amount)
            // console.log();
        },

        taxChange() {
            const mainTax = $(this).val();
            $('#requestsTbl tbody tr').each(function() {
                Index.updateLineTax($(this).find('.rowtax'));
                if ($(this).find('.qty_purchased').val()*1) {
                    const itemRate = accounting.unformat($(this).find('.price').val());
                    $(this).find('.amount').val(accounting.formatNumber(itemRate * (mainTax/100 + 1), 4));
                    $(this).find('.price').change();
                }
            });
        },
        updateLineTax(taxSelect) {
            if (taxSelect && taxSelect.length) {
                const mainTax = $('#tax').val();
                taxSelect.children().each(function() {
                    const value = $(this).attr('value');
                    // console.log(value, mainTax);
                    if ((value == mainTax) || (value == 0)) $(this).removeClass('d-none');
                    else $(this).addClass('d-none');
                });
                taxSelect.val(mainTax);
            }
        },

        drawDataTable(params={}) {
            $('#requestsTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: "{{ route('biller.purchase_requests.get_queued') }}",
                    type: 'POST',
                    data: {
                        // job_card: this.jobcard
                        ...params
                    },
                },
                columns: [
                    {data: 'check', name: 'check'},
                    // {data: 'DT_Row_Index', name: 'id'},
                    // {data: 'employee', name: 'employee'},
                    // {data: 'tid', name: 'tid'},
                    // {data: 'requisition_date', name: 'requisition_date'},
                    // {data: 'priority', name: 'priority'},
                    {data: 'name', name: 'name',  searchable: false, sortable: false},
                    {data: 'sku', name: 'sku',  searchable: false, sortable: false},
                    {data: 'uom', name: 'uom',  searchable: false, sortable: false},
                    {data: 'qty', name: 'qty',  searchable: false, sortable: false},
                    {data: 'qty_requested', name: 'qty_requested',  searchable: false, sortable: false},
                    {data: 'tax', name: 'tax',  searchable: false, sortable: false},
                    {data: 'qty_purchased', name: 'qty_purchased',  searchable: false, sortable: false},
                    {data: 'price', name: 'price',  searchable: false, sortable: false},
                    {data: 'taxable', name: 'taxable',  searchable: false, sortable: false},
                    {data: 'amount', name: 'amount', searchable: false, sortable: false},
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
        }
    };

    $(() => Index.init());
</script>
<script>
    // ajax
    $.ajaxSetup({ headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}});

    // select2 config
    function select2Config(url, callback) {
        return {
            ajax: {
                url,
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({q: term, keyword: term}),
                processResults: callback
            }
        }
    }

    // datepicker
    $('.datepicker').datepicker({format: "{{ config('core.user_date_format')}}", autoHide: true})        
    .datepicker('setDate', new Date());
        
    // On selecting supplier type
    $("input[name='supplier_type']").change(function() {
        $('#supplierbox').html('').attr('disabled', true);
        $('#taxid').val('').attr('readonly', false);
        $('#supplier').val('').attr('readonly', false);
        $('#supplierid').val(1);
        if ($(this).val() == 'supplier') {
            $('#supplierbox').attr('disabled', false);
            $('#taxid').attr('readonly', true);
            $('#supplier').attr('readonly', true);
        }
    });

    $('#currency_rate').val(1).attr('readonly',true)
    $('#currency').change(function(e) {
        $('#currency_rate').val('').change();
        const currency = $('#currency').find('option:selected').attr('data-code');
        const rate = $('#currency').find('option:selected').attr('data-rate');
        $('#currency_rate').val(accounting.unformat(rate));
        if (currency == "TSH") {
           // $('#currency_rate').val(1);
            $('#currency_rate').attr('readonly', true);
           
        }else{

            $('#currency_rate').attr('readonly', false);
        }
    });

    // On searching supplier
    $('#supplierbox').change(function() {
        const name = $('#supplierbox option:selected').text().split(' : ')[0];
        const [id, taxId] = $(this).val().split('-');
        $('#taxid').val(taxId);
        $('#supplierid').val(id);
        $('#supplier').val(name);
        let priceCustomer = '';
            $('#pricegroup_id option').each(function () {
                if (id == $(this).val())
                priceCustomer = $(this).val();
            });
            
            $('#pricegroup_id').val(priceCustomer);
    });

    // load suppliers
    const supplierUrl = "{{ route('biller.suppliers.select') }}";
    function supplierData(data) {
        return {results: data.map(v => ({id: `${v.id}-${v.taxid || ''}`, text: `${v.name} : ${v.email}`}))};
    }
    $('#supplierbox').select2(select2Config(supplierUrl, supplierData));

   
    



    // Tax condition
    function taxRule(id, tax) {
        $('#'+ id +' option').each(function() {
            const itemtax = $(this).val();
            $(this).removeClass('d-none');
            if (itemtax != tax && itemtax != 0) $(this).addClass('d-none');
            $(this).attr('selected', false);
            if (itemtax == tax) $(this).attr('selected', true).change();
        }); 
    }

    // on Tax on amount change
    $('.is_tax_exc').change(function() {
        $('#qty-0').change();
        $('#expqty-0').change();
        $('#assetqty-0').change();
    });

    $('#requestsTbl').on('change', '.qty_purchased, .price, .rowtax, .uom', function() {
        const el = $(this);
        const row = el.parents('tr:first');

        const qty = accounting.unformat(row.find('.qty_purchased').val());
        const price = accounting.unformat(row.find('.price').val());
        const rowtax = 1 + row.find('.rowtax').val() / 100;

        let amount = 0;
        let taxable = 0;
        if ($('.is_tax_exc').prop('checked')) {
            amount = qty * price * rowtax;
            taxable = qty * price * (rowtax - 1);
        } else {
            amount = qty * price;
            taxable = (amount / rowtax) * (rowtax - 1);
        }

        row.find('.price').val(accounting.formatNumber(price));
        row.find('.amount').text(accounting.formatNumber(amount));
        row.find('.taxable').val(accounting.formatNumber(taxable));
        // row.find('.stocktaxr').val(accounting.formatNumber(taxable));
        // row.find('.stockamountr').val(accounting.formatNumber(amount));
        calcStock();

        if (el.is('.price')) {
            row.next().find('.descr').attr('required', true);
        }
        if (el.is('.uom')) {
            const purchasePrice = el.find('option:selected').attr('purchase_price');
            row.find('.price').val(purchasePrice).change();
        }
    });
    function calcStock() {
        let tax = 0;
        let grandTotal = 0;
        $('#requestsTbl tbody tr').each(function() {
            if (!$(this).find('.qty_purchased').val()) return;
            const qty = $(this).find('.qty_purchased').val();
            const price = $(this).find('.price').val().replace(/,/g, '') || 0;
            const rowtax = $(this).find('.rowtax').val()/100 + 1;

            let amount = 0;
            let taxable = 0;
            if ($('.is_tax_exc:checked').val() * 1) {
                amount = qty * price * rowtax;
                taxable = amount - qty * price;
            } else {
                amount = qty * price / rowtax;
                taxable = qty * price - amount;
                amount += taxable;
            } 
            tax += parseFloat(taxable.toFixed(2));
            grandTotal += parseFloat(amount.toFixed(2));
        });

        
        $('#invtax').text(tax.toLocaleString());
        $('#stock_tax').val(tax.toLocaleString());
        $('#stock_grandttl').val(grandTotal.toLocaleString());
        $('#stock_subttl').val((grandTotal - tax).toLocaleString());
        // transxnCalc();
    }

    // edit mode
    // let countPurchaseItems = @json(@$purchase->products? $purchase->products->count() : 0);    
</script>
@endsection