@extends ('core.layouts.app')

@section('title', 'Purchase Requisition Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Purchase Requisition Management</h4>
        </div>
        <div class="col-6">
            <div class="btn-group float-right">
                @include('focus.purchase_requests.partials.purchase-request-header-buttons')
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="card">
            <div class="card-content">
                <div class="card-header">
                    @php
                        $pr = $purchase_request;
                        $valid_token = token_validator('', 'pr' . $pr->id, true);
                        $link = route('biller.print_requisition', [$pr->id, 15, $valid_token, 1]);
                    @endphp
                    <a href="{{ $link }}" class="btn btn-purple btn-sm" target="_blank">
                        <i class="fa fa-print" aria-hidden="true"></i> Print
                    </a>
                    <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                        <i class="fa fa-pencil" aria-hidden="true"></i> Status
                    </a>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-sm">
                        @php 
                            $req = $purchase_request;                        
                            $details = [
                                'Requisition No.' => gen4tid('REQ-', $req->tid),
                                'Status' => $req->status,
                                'Priority' => $req->priority,
                                'Date' => dateFormat($req->date),
                                'Employee' => $req->employee? $req->employee->full_name : '',
                                'Expected Delivery Date' => dateFormat($req->expect_date),
                                'Remark' => $req->note,
                                'Job Card' => $req->job_card,
                            ];
                        @endphp
                        @foreach ($details as $key => $val)
                            <tr>
                                <th width="30%">{{ $key }}</th>
                                <td>
                                    @if (in_array($key, ['Status', 'Priority']))
                                        <span class="font-weight-bold">{{ $val }}</span>
                                    @elseif ($key == 'Item List Description')
                                        {!! $val !!}
                                    @else
                                        {{ $val }}    
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </table>
                </div>

                <div class="card-body">
                    <table class="table text-center tfr my_stripe_single" id="requisitionTbl">
                        <thead>
                            <tr class="item_header bg-gradient-directional-blue white ">
                                <th width="15%" class="text-center">Material Name</th>
                                <th width="10%" class="text-center">SKU</th>
                                <th width="10%" class="text-center">UoM</th>
                                <th width="10%" class="text-center">Quantity</th>              
                            </tr>
                        </thead>
                        <tbody>
                            <!-- layout -->
                            @if (isset($purchase_request))
                                @foreach ($purchase_request->items as $i => $item)
                                    <tr>
                                        <td>
                                            {{ $item->name }}
                                        </td>
                                        <td>{{ $item->sku }}</td>
                                        <td>{{ $item->unit ? $item->unit->code : @$item->product->unit->code }}</td>
                                        <td>{{ NumberFormat($item->qty) }}</td> 
                                    </tr>
                                @endforeach
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@include('focus.purchase_requests.partials.status-modal')
@endsection
