@extends ('core.layouts.app')

@section('title', 'Purchase Requisition Push Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Purchase Requisition Push Management</h4>
        </div>
        <div class="col-6">
            <div class="btn-group float-right">
                @include('focus.purchase_requests.partials.purchase-request-header-buttons')
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="col-3">
                            <label for="job_card">Search JobCard</label>
                            <select name="job_card" class="custom-select form-control" id="job-card" aria-placeholder="Search Requestor">
                                @foreach ($filters as $job)
                                    <option value="{{ $job->job_card}}">{{ $job->job_card }}</option>
                                @endforeach
                            </select>
                        </div>
                       <div class="col-2 float-right">
                        <button type="button" class="btn btn-lg btn-primary push_lpo">PUSH TO LPO</button>
                    </div>
                       <div class="col-2 float-right">
                        <button type="button" class="btn btn-lg btn-secondary push_direct">PUSH TO DIRECT</button>
                    </div>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                           <form action="{{route('biller.purchaseorders.store')}}" method="POST">
                            @csrf
                            <table id="requestsTbl" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>SKU</th>
                                        <th>UoM</th>
                                        <th>Qty Purchased</th>
                                        <th>Qty</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="100%" class="text-center text-success font-large-1">
                                            <i class="fa fa-spinner spinner"></i>
                                        </td>
                                    </tr>
                                </tbody>                                
                            </table>
                            <button type="submit" class="btn btn-lg">Submit</button>
                        </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>        
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script(mix('js/dataTable.js')) }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
    };

    const Index = {
        jobcard: @json(request('job_card')),
        init() {
            $.ajaxSetup(config.ajax);
            $('#job-card').select2({allowClear: true}).val('').trigger('change');
            $('#job-card').val(this.jobcard).change(this.jobCardChange);
            //$('#requestsTbl').on('click', '.push_lpo', this.checkedItems);
            $('.push_lpo').click(this.checkedLPOItems);
            $('.push_direct').click(this.checkedDirectItems);
            $('#requestsTbl tbody').on('click', '.check', this.checkOne);
            this.drawDataTable();
        },

        jobCardChange() {
            Index.jobcard = $(this).val();
            $('#requestsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },
        checkOne(){
            const el = $(this);
            const row = el.parents('tr:first');
            row.find('.pid').attr('disabled', false);
            console.log(row.find('.qty_purchased').attr('disabled', false));
        },

        checkedLPOItems(){
            const id = [];
            const el = $(this);
            $('#requestsTbl tbody tr').each(function() {
                    const row = $(this);
                    // if(row.is('.check:checked')){
                    //     console.log('checking');
                    // }
                    id.push(row.find('.check:checked').val())
                    //console.log(row);
                });
            // console.log(id);
            const url = "{{ route('biller.purchase_requests.store_direct_lpo') }}";
            $.ajax({
                type: 'POST',
                url: url,
                data: { id: id , type: 'lpo'},
                success: function(response) {
                    // Handle the response from the server
                    console.log(response);
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    // Handle error cases
                    console.log(xhr.responseText);
                }
            });
        },
        checkedDirectItems(){
            const id = [];
            const el = $(this);
            $('#requestsTbl tbody tr').each(function() {
                    const row = $(this);
                    id.push(row.find('.check:checked').val())
                    //console.log(row);
                });
            // console.log(id);
            const url = "{{ route('biller.purchase_requests.store_direct_lpo') }}";
            $.ajax({
                type: 'POST',
                url: url,
                data: { id: id, type: 'direct' },
                success: function(response) {
                    console.log(response);
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    console.log(xhr.responseText);
                }
            });
        },
        // checkedItems() {
        //     const el = $(this);
        //     $('#requestsTbl tbody tr').each(function() {
        //             const row = $(this);
        //             if (row.find('.check').val() != el.val()) {
        //                 row.find('.check').prop('checked', false);
        //             }
        //         });
        //     if (el.prop('checked')) {
        //         $('#quote').val(el.val());
        //         $('#quotesTbl tbody tr').each(function() {
        //             const row = $(this);
        //             if (row.find('.select-row').val() != el.val()) {
        //                 row.find('.select-row').prop('checked', false);
        //             }
        //         });
        //     } else {
        //         $('#quote').val('');
        //         $('#quotesTbl tbody tr').each(function() {
        //             const row = $(this);
        //             row.find('.select-row').prop('checked', false);
        //         });
        //     }
        //     if ($('#quote').val()) {
        //         swal({
        //             title: 'Proceed to Issue Stock?',
        //             icon: "warning",
        //             buttons: true,
        //             dangerMode: true,
        //             showCancelButton: true,
        //         }, () => $('form').submit()); 
        //     }
        // },

        drawDataTable() {
            $('#requestsTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: "{{ route('biller.purchase_requests.get_queued') }}",
                    type: 'POST',
                    data: {
                        job_card: this.jobcard
                    },
                },
                columns: [
                    {data: 'check', name: 'check'},
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'name', name: 'name'},
                    {data: 'sku', name: 'sku'},
                    {data: 'uom', name: 'uom'},
                    {data: 'qty_purchased', name: 'qty_purchased'},
                    {data: 'qty', name: 'qty', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
        }
    };

    $(() => Index.init());
</script>
@endsection
