@extends ('core.layouts.app')

@section('title', 'Push Requisition to Lpo')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Purchase Requisition Management</h4>
        </div>
        <div class="col-6">
            <div class="btn-group float-right">
                @include('focus.purchase_requests.partials.purchase-request-header-buttons')
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="card">
            <div class="card-header">
                <div class="form-group row filters">
                    <div class="col-3">
                        <label for="job_card">Search JobCard</label>
                        <select name="job_card" class="custom-select form-control" id="job-card"  data-placeholder="Search Requestor">
                            @foreach ($filters as $job)
                                <option value="{{ $job->job_card}}">{{ $job->job_card }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-3">
                        <label for="requestor">Request From</label>
                        <select name="requestor" class="custom-select form-control" id="requestor" data-placeholder="Search Requestor">
                            @foreach ($filters as $job)
                                <option value="{{ $job->employee_id}}">{{ $job->employee }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-2">
                        <label for="priority">Select Priority</label>
                        <select name="priority" class="custom-select form-control" id="priority" data-placeholder="Search priority">
                            <option value="">Select Priority</option>
                            <option value="low">Low</option>
                            <option value="medium">Medium</option>
                            <option value="high">High</option>
                        </select>
                    </div>
                    <div class="col-2 float-right">
                        <button class="btn btn-lg submit btn-primary float-right" type="button">
                            Push To Purchase
                        </button>
                    </div>
                </div>
                <div class="col-2">{{ trans('general.search_date')}} </div>
                <div class="col-2">
                    <input type="text" name="start_date" id="start_date" class="form-control datepicker date30  form-control-sm" autocomplete="off" />
                </div>
                
            </div>
            <div class="card-body">
                <table id="requisitionTbl" class="table table-s table-bordered">
                    <thead>
                        <th><input type="checkbox" name="" id="check-all"></th>
                        <th>SKU Code</th>
                        <th>Item Name</th>
                        <th>UoM</th>
                        <th>Qty</th>
                    </thead>
                    <tbody>
                        {{-- {{ dd($purchase_requests->items) }} --}}
                        
                        {{-- {{ dd($items) }} --}}
                            {{-- @foreach ($purchase_requests as $request)
                            @foreach ($request->items as $i => $item)
                               @if ($item->status_check == '0')
                               <tr>
                                    <td><input type="checkbox" class="check-item" name="" id="check-item-{{$i+1}}"></td>
                                    <td>{{ $item->sku }}</td>
                                    <td>{{ $item->name }}</td>
                                    <td>{{ $item->uom }}</td>
                                    <td>{{ $item->qty }}</td>
                                    <input type="hidden" class="id" name="id" value="{{$item->id}}" id="id-{{$i+1}}">
                                    <input type="hidden" class="item_id" name="item_id" value="{{$item->item_id}}" id="item_id-{{$i+1}}">
                                </tr>
                               @endif
                            @endforeach
                            @endforeach --}}
                        
                       
                    </tbody>
                </table>
               
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script(mix('js/dataTable.js')) }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
    };

    const Index = {
        purchase_requests: @json($purchase_requests),
        items: @json($items),
        init() {
            $.ajaxSetup(config.ajax);
            this.drawDataTable();
            $('#job-card').select2({allowClear: true}).val('').trigger('change');
            $('#requestor').select2({allowClear: true}).val('').trigger('change');
            // if (this.items && this.items.length) {
            //     $('#requisitionTbl tbody').html('');
            //     this.items.forEach((v, i) => $('#requisitionTbl tbody').append(Index.requisitionChange(v, i)));

            // }
            //$('.check-item').change(this.checkedItems);
            $('.submit').click(this.checkedItems);
            $('#check-all').click(function() {
                // Get the state of the "Select All" checkbox
                var isChecked = $(this).prop('checked');

                // Set the state of all other checkboxes based on the "Select All" checkbox
                $('.check-item').prop('checked', isChecked);
            });
            $('.filters').on('change', '#priority, #job-card, #requestor', this.filterCriteriaChange);
        },
        filterCriteriaChange() {
            const url = "{{ route('biller.purchase_requests.get_requisition_items') }}";
            const job_card = $('#job-card').val();
            const employee_id = $('#requisitor').val();
            const priority = $('#priority').val();
            // console.log(job_card, employee_id, priority);
            $.ajax({
                type: 'POST',
                url: url,
                data: { 
                    employee_id: employee_id,
                    priority: priority,
                    job_card: job_card,
                 },
                success: function(response) {
                    // Handle the response from the server
                    $('#requisitionTbl tbody').html('');
                        response.forEach((v, i) => $('#requisitionTbl tbody').append(Index.requisitionChange(v, i)));
                    console.log(response);
                    if(response && response.length){
                        $('#requisitionTbl tbody').html('');
                        response.forEach((v, i) => $('#requisitionTbl tbody').append(Index.requisitionChange(v, i)));
                    }
                },
                error: function(xhr, status, error) {
                    // Handle error cases
                   // console.log(xhr.responseText);
                }
            }); 
        },

        drawDataTable() {
            $('#requestsTbl').dataTable({
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'],
            });
        },
        checkedItems() {
            var id = [];
            var allChecked = $('.check-item:checked').length === $('.check-item').length;
            if(allChecked == true){
                $('#check-all').prop('checked', allChecked)
                $('.check-item:checked').each(function() {
                const el = $(this).parents('tr:first');
                var itemId = el.find('.id').val();
                id.push(itemId);
            });
            }
            else{
                 // Iterate through checked checkboxes
            $('.check-item:checked').each(function() {
                const el = $(this).parents('tr:first');
                var itemId = el.find('.id').val();
                id.push(itemId);
            });
            }
           
           
            // $('#check-all').prop('checked', allChecked)
           
            const url = "{{ route('biller.purchase_requests.store_push') }}";
            $.ajax({
                type: 'POST',
                url: url,
                data: { id: id },
                success: function(response) {
                    // Handle the response from the server
                   // console.log(response);
                   window.location.reload()
                },
                error: function(xhr, status, error) {
                    // Handle error cases
                    //console.log(xhr.responseText);
                }
            });
            // // Output selected item IDs (you can modify this to retrieve other item properties)
             //console.log(id);
        },

        requisitionChange(v,i){
            return `
                <tr>
                    <td><input type="checkbox" class="check-item" name="" id="check-item-${i+1}"></td>
                    <td>${v.sku}</td>
                    <td>${v.name}</td>
                    <td>${v.uom}</td>
                    <td>${v.qty}</td>
                    <input type="hidden" class="id" name="id" value="${v.id}" id="id-${i+1}">
                    <input type="hidden" class="item_id" name="item_id" value="${v.item_id}" id="item_id-${i+1}">
                </tr>
            `;
        }
    };

    $(() => Index.init());
</script>
@endsection


