<script>
     const config = {
        ajax: {
            headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}
        },
        select: {
            allowClear: true,
        },
        date: {autoHide: true, format: '{{config('core.user_date_format')}}'},
    };
    // ajax header set up
    $.ajaxSetup(config.ajax);
    $('#jobcard').select2({...config.select});
    jobSum();

    $(() =>{
        // on show tab load datatables
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            localStorage.setItem('project_tab', $(e.target).attr('href'));
            switch ($(e.target).attr('href')) {
                case '#tab_data2': lpo(); break;
                case '#tab_data3': tasks(); break;
                case '#tab_data4': jobcard(); break;
                case '#tab_data5': bomItems(); break;
                case '#tab_data6': process(); break;
                case '#tab_data7': dispatch(); break;
                case '#tab_data8': attachment(); break;
                // case '#tab_data1': jobSum(); break;
                
            }
        });
        const projectTab = localStorage.project_tab;
        if (projectTab) $('a[href="' + projectTab + '"]').tab('show');
    });
    function jobcard() {
        if ($('#jobcardTbl tbody tr').length) return;        
        $('#jobcardTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.jobcards.get_jobcards') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['jobcard_no', 'total_board', 'total_qty']
                .map(v => ({data: v, name: v})),
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    } 

    function attachment() {
        if ($('#attachmentsTbl tbody tr').length) return;        
        $('#attachmentsTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.jobcards.get_attachment') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['jobcard_no', 'attachment','description']
                .map(v => ({data: v, name: v})),
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    } 
    function process() {
        if ($('#processTbl tbody tr').length) return;        
        $('#processTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.jobcards.get_process') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['jobcard_id','process_id','date','operator_id','start_time',
                    'end_time','record_qty','board_rej','qty_produced','print_rej']
                .map(v => ({data: v, name: v})),
                {data: 'net_qty', name: 'net_qty'}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    } 
    function dispatch() {
        // if ($('#dispatchTbl tbody tr').length) return;  
        
        // $('.dispatchAttach').append()
        const data = {project_id: "{{ $project->id }}"};
        $.post("{{ route('biller.jobcards.get_dispatch') }}",  data ,
            function (data, textStatus, jqXHR) {
                
                // console.log(data);
                // $('#dispatchTbl tbody').append(data)
                if (data && data.length) {
                    // $('#dispatchTbl').dataTable();
                    data.forEach((v) => {
                    
                    $('#dispatchTbl tbody').append(v);
                    // console.log(v);
                });
                }
            }
        );
       
    } 
    function bomItems() {
        if ($('#bomItemsTbl tbody tr').length) return;        
        $('#bomItemsTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.jobcards.get_bom_items') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['jobcard','product', 'product_quantity']
                .map(v => ({data: v, name: v})),
                {data: 'uom', name: 'uom', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    } 

    function tasks() {
        if ($('#tasksTbl tbody tr').length) return;        
        $('#tasksTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.tasks.get') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['name', 'start_date', 'end_date', 'priority','qty_needed','jobcard_no','total_board','total_qty']
                .map(v => ({data: v, name: v})),
                {data: 'actions', name: 'actions', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    }
    function lpo() {
        if ($('#lpoTbl tbody tr').length) return;        
        $('#lpoTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.lpo.get') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['customer', 'lpo_number', 'amount','lpo_document']
                .map(v => ({data: v, name: v})),
                {data: 'balance', name: 'balance', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    }
    function jobSum() {
        if ($('#jobSumTbl tbody tr').length) return;        
        $('#jobSumTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
            ajax: {
                url: "{{ route('biller.jobcards.get_job_summary') }}",
                type: 'POST',
                data: {project_id: "{{ $project->id }}"},
            },
            columns: [
                {data: 'DT_Row_Index',name: 'id'},
                ...['jobcard_no','project_qty_needed','task_qty_needed','total_per_jobcard']
                .map(v => ({data: v, name: v})),
                {data: 'total_dispatch', name: 'total_dispatch', searchable: false, sortable: false}
            ],
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    }

    // task show modal
    $('#AddTaskModal').on('shown.bs.modal', function () {
        $('[data-toggle="datepicker"]').datepicker(config.date);
        $('.from_date').datepicker(config.date).datepicker('setDate', 'today');
        $('.to_date').datepicker(config.date).datepicker('setDate', '{{ dateFormat(date('Y-m-d', strtotime('+30 days', strtotime(date('Y-m-d'))))) }}');
        ['tags', 'employee', 'projects'].forEach(v => $('#'+v).select2());
        // $('#color_t').colorpicker();
        $("#job-card").select2({
            allowClear: true,
            dropdownParent: $('#AddTaskModal'),
            ajax: {
                url: "{{ route('biller.projects.jobcard_select') }}",
                dataType: 'json',
                type: 'POST',
                data: ({term}) => ({search: term, customer_id: @json(@$project->customer_id) }),
                processResults: (data) => {
                    return {
                        results: $.map(data, (item) => ({
                            text: `${item.jobcard_no}`,
                            id: item.id
                        }))
                    };
                },
            }
        });
        
    });
    // jobcard show modal
    $('#AddJobCardModal').on('shown.bs.modal', function () {
        
        const dt = "{{ dateFormat() }}";
        $('.from_date').val(dt);
        $('.to_date').val(dt);

        $("#job").select2({
            allowClear: true,
            dropdownParent: $('#AddJobCardModal'),
            ajax: {
                url: "{{ route('biller.projects.jobcard_select') }}",
                dataType: 'json',
                type: 'POST',
                data: ({term}) => ({search: term, customer_id: @json(@$project->customer_id) }),
                processResults: (data) => {
                    return {
                        results: $.map(data, (item) => ({
                            text: `${item.jobcard_no}`,
                            id: item.id
                        }))
                    };
                },
            }
        });
        
    });
    $('#AddAttachmentModal').on('shown.bs.modal', function () {
    });
    $('#tasksTbl tbody').on('click', '#attach_jobcard', function(e){
            const el = $(this);
            const row = el.parents('tr');
            let task_id = e.target.getAttribute('data-name');
            $('#task_id').val(task_id);
            // console.log();
        });
    $('#attachmentsTbl tbody').on('click', '.zoom', function(e){
            const el = $(this);
            console.log(el);
        });
    // on jobcard submit
    $("#submit-data_jobcard").on("click", function (e) {
        e.preventDefault();
        var form_data = {};
        form_data['form_name'] = 'data_form_jobcard';
        form_data['form'] = $("#data_form_jobcard").serialize();
        form_data['url'] = $('#action-url_1').val();
        addObject(form_data, true);
        $('#AddJobCardModal').modal('toggle');
    });

    $('#jobcardTbl tbody').on('click', '#attach_image', function(e){
            const el = $(this);
            const row = el.parents('tr');
            let jobcard_id = e.target.getAttribute('data-id');
            $('#jobcard_id').val(jobcard_id);
            // console.log(jobcard_id);
        });

    // lpo show modal
    $('#AddLPOModal').on('shown.bs.modal', function () {
        
        const dt = "{{ dateFormat() }}";
        $('.from_date').val(dt);
        $('.to_date').val(dt);

        $("#lpo").select2({
            allowClear: true,
            dropdownParent: $('#AddLPOModal'),
            ajax: {
                url: "{{ route('biller.projects.lpo_select') }}",
                dataType: 'json',
                type: 'POST',
                data: ({term}) => ({search: term, customer_id: @json(@$project->customer_id) }),
                processResults: (data) => {
                    return {
                        results: $.map(data, (item) => ({
                            text: `${item.lpo_no}`,
                            id: item.id
                        }))
                    };
                },
            }
        });
        
    });
    // on lpo submit
    $("#submit-data_lpo").on("click", function (e) {
        e.preventDefault();
        var form_data = {};
        form_data['form_name'] = 'data_form_lpo';
        form_data['form'] = $("#data_form_lpo").serialize();
        form_data['url'] = $('#action-url_2').val();
        addObject(form_data, true);
        $('#AddLPOModal').modal('toggle');
    });

</script>