@extends ('core.layouts.app')

@section ('title', trans('labels.backend.projects.management'))

@section('content') 
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Project Management</h4>
        </div>
        <div class="content-header-right col">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.projects.partials.projects-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="card todo-details rounded-0">
            <div class="sidebar-toggle d-block d-lg-none info"><i class="ft-menu font-large-1"></i></div>
            <div class="search"></div>
            <div class="card-body">
                <table id="projects-table" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>#Project No</th>
                            <th>Name</th>
                            <th>Customer</th>                         
                            <th>Start Date</th>
                            <th>Project Priority</th>
                            <th>Qty Ordered.</th>                         
                            <th>{{ trans('general.action') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="100%" class="text-center text-success font-large-1"><i class="fa fa-spinner spinner"></i></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>    
@endsection

@section('extra-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
    <script>
        const config = {
            ajax: { headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"} },
        };
        const Index = {
            init() {
                $.ajaxSetup(config.ajax);
                this.drawDataTable();
            },

            drawDataTable() {
            $('#projects-table').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: "{{ route('biller.projects.get') }}",
                    type: 'post'
                },
                columns: [{
                        data: 'DT_Row_Index',
                        name: 'id'
                    },
                    {
                        data: 'tid',
                        name: 'tid'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'customer',
                        name: 'customer'
                    },
                    
                    {
                        data: 'start_date',
                        name: 'start_date'
                    },
                    {
                        data: 'priority',
                        name: 'priority'
                    },
                    {
                        data: 'qty_needed',
                        name: 'qty_needed'
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        searchable: false,
                        sortable: false
                    }
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print'] 
            });
        },
        };
        $(() => Index.init());
    </script>
@endsection