@extends ('core.layouts.app')
@section('title', trans('labels.backend.products.management'))

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">{{ trans('labels.backend.products.management') }}</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.products.partials.products-header-buttons')
                </div>
            </div>
        </div>
    </div>


    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                       

                        <div class="card-body">
                            <div class="">
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Product Name</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['name'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Stock Type</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['stock_type'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Stock Keeping Unit</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['sku'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Tax Rate</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['taxrate']) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Product Description</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['product_des'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Product Code</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['code'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Base Unit</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product->unit['code'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Qty Alert</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['alert'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Image</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['image'] }}</div>
                                </div>
                                <hr class="mb-3 mt-2">
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Warehouse</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product->warehouse['title'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Purchase Price</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['purchase_price']) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Qty</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['qty']) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Weight</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['weight']) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Serial Number</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['serial'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        At is Date</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $product['date'] }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Lenght</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['weight']) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Width</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['width']) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-4 border-blue-grey border-lighten-5  p-1">
                                        Height</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ NumberFormat($product['height']) }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="productTbl" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th width="15%">Date</th>
                                        <th>Supplier</th>
                                        <th>Ref No.</th>
                                        <th>Value</th>
                                        <th>Minimum Stock</th>
                                        <th>Unit</th>
                                        <th>In</th>
                                        <th>Out</th>
                                        <th>Balance</th>
                                        <th>Weight</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($product->paper_id > 0)
                                        @foreach ($product->paper_bin as $item)
                                        
                                            <tr>
                                                <td>{{dateFormat($item->created_at)}}</td>
                                                <td>{{$item->supplier ? $item->supplier->name : ''}}</td>
                                                <td>{{$item->ref_no}}</td>
                                                <td>{{NumberFormat($item->value)}}</td>
                                                <td>{{NumberFormat($item->min_stock)}}</td>
                                                <td>{{@$item->units->code}}</td>
                                                <td>
                                                    @if ($item->in == 1)
                                                        {{NumberFormat($item->qty)}}
                                                    @else
                                                        {{0}}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($item->out == 1)
                                                        {{NumberFormat($item->qty)}}
                                                    @else
                                                        {{0}}
                                                    @endif
                                                </td>
                                                <td>{{NumberFormat($item->balance)}}</td>
                                                <td>{{NumberFormat($item->weight)}}</td>
                                            </tr>
                                        @endforeach

                                    @else
                                        @foreach ($product->product_bin as $item)
                                        <tr>
                                            <td>{{dateFormat($item->created_at)}}</td>
                                            <td>{{$item->supplier ? $item->supplier->name : ''}}</td>
                                            <td>{{$item->ref_no}}</td>
                                            <td>{{NumberFormat($item->value)}}</td>
                                            <td>{{NumberFormat($item->min_stock)}}</td>
                                            <td>{{@$item->units->code}}</td>
                                            <td>
                                                @if ($item->in == 1)
                                                    {{NumberFormat($item->qty)}}
                                                @else
                                                    {{0}}
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->out == 1)
                                                    {{NumberFormat($item->qty)}}
                                                @else
                                                    {{0}}
                                                @endif
                                            </td>
                                            <td>{{NumberFormat($item->balance)}}</td>
                                            <td>{{NumberFormat(0)}}</td>
                                        </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
    <script>
        $('#productTbl').dataTable({
            processing: true,
            responsive: true,
            stateSave: true,
            language: {@lang('datatable.strings')},
           
            order:[[0, 'desc']],
            searchDelay: 500,
            dom: 'Blfrtip',
            buttons: ['csv', 'excel', 'print'],
        });
    </script>
@endsection