{{-- Product --}}
{{-- <h4>{{trans('products.general_product_details')}}</h4> --}}
<h4>Product Conversion</h4>

<div class="row form-group">
        <div class="col-6">
            {{-- {{ Form::label('name', trans('products.name'),['class' => 'control-label']) }} --}}
            {{ Form::label('name', "In-House Product",['class' => 'control-label']) }}
            {{-- {{ Form::text('in_house_product', null, ['class' => 'form-control box-size', 'placeholder' => trans('products.name').'*','required'=>'required']) }} --}}
            <select class="custom-select" name="in_house_product" id="in_house_product_id" required>
                @foreach($products as $product)
                    @if ($product->stock_type == 'in-house')
                        <option value="{{$product->id}}" {{$product->id  == @$productconversion->in_house_product ? 'selected' : ''}}>
                            {{$product->name}}
                        </option>
                    @endif
                @endforeach
            </select>
        </div>

        <br>
        <div class="col-6">
            {{-- {{ Form::label('name', trans('products.name'),['class' => 'control-label']) }} --}}
            {{ Form::label('name', "Quantity of In-House Products",['class' => 'control-label']) }}
            {{ Form::text('in_house_product_quantity', null, ['class' => 'form-control' , 'required' => 'required']) }}
        </div>
</div>

<h4>Raw material products</h4>

<div class="row form-group raw-class" id="raw_id">
    {{-- <div class="old_id"><input type="hidden" name="v_id[]" value="{{@$product->standard['id']}}"><input type="hidden" name="pv_id" value="{{@$product->standard['id']}}"></div> --}}
    {{-- <div class="product"> --}}
        <div class="col-5">
            {{ Form::label('unit', "Raw Material",['class' => 'control-label']) }}
            {{-- {{ Form::text('raw_material', null, ['class' => 'form-control']) }} --}}
            <select class="custom-select" name="raw_material[]" id="raw_material_id" required>
                @foreach($products as $product)
                        <option value="{{$product->id}}">
                            {{$product->name}}
                        </option>
                @endforeach
            </select>
        </div>
        <br>
        <div class="col-5">
            {{-- <label for="brand">Brand</label> --}}
            {{ Form::label('unit', "Quantity of Raw Materials",['class' => 'control-label']) }}
            {{ Form::text('raw_material_quantity[]', null, ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="col-2">
            <span class="del_b"></span>
        </div>
    {{-- </div> --}}
</div>

@if (isset($productconversion))
    @foreach ($productconversion->product_conversion_raw_materials as $row)
    <div class="row form-group" id="">
        {{-- <div class="old_id"><input type="hidden" name="v_id[]" value="{{@$product->standard['id']}}"><input type="hidden" name="pv_id" value="{{@$product->standard['id']}}"></div> --}}
        {{-- <div class="product"> --}}
            <div class="col-5">
                {{ Form::label('unit', "Raw Material",['class' => 'control-label']) }}
                {{-- {{ Form::text('raw_material', null, ['class' => 'form-control']) }} --}}
                <select class="custom-select" name="raw_material[]" id="raw_material_id" required>
                    @foreach($products as $product)
                            <option value="{{$product->id}}" {{ $product->id == @$row->raw_material ? 'selected' : ''}}>
                                {{$product->name}}
                            </option>
                    @endforeach
                </select>
            </div>
            <br>
            <div class="col-5">
                {{-- <label for="brand">Brand</label> --}}
                {{ Form::label('unit', "Quantity of Raw Materials",['class' => 'control-label']) }}
                {{ Form::text('raw_material_quantity[]', @$row->raw_material_quantity, ['class' => 'form-control', 'required' => 'required']) }}
            </div>
            <div class="col-2">
                <span class="del_b"></span>
            </div>
        {{-- </div> --}}
    </div>
    @endforeach
@endif

<div id="added_product"></div>
<button class="btn btn-blue add_more btn-sm m-1">{{trans('general.add_row')}}</button>
<div id="remove_variation"></div>

@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    const config = {
        ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        datepicker: {
            autoHide: true,
            format: "{{config('core.user_date_format')}}"
        },
    };

    const Form = {
        units: @json($productconversion),

        init() {
            $.ajaxSetup(config.ajax);

            const events = [".add_more", ".v_delete_temp"];
            const handlers = [this.addMore, this.delProduct];
            events.forEach((v,i) => $(document).on('click', v, handlers[i]));
        },

        addMore(e) {
            e.preventDefault();
            var product_details = $('#raw_id').clone().find(".old_id input:hidden").val(0).end();
            // var product_details = $('#raw_id').clone().end();
            product_details.find(".del_b").append('<button class="btn btn-danger v_delete_temp m-1 align-content-end"><i class="fa fa-trash"></i> </button>').end();
            $('#added_product').append(product_details);
            $('.datepicker').datepicker(config.datepicker);
        },
        delProduct(e) {
            e.preventDefault();
            $(this).closest('div .raw-class').remove();
        },

    };

    $(() => Form.init());
</script>
@endsection
