<h4>Combined Product</h4>

<div class="row form-group">
    <div class="col-3">
        {{ Form::label('name', trans('products.name'),['class' => 'control-label']) }}
        {{ Form::text('name', null, ['class' => 'form-control box-size', 'placeholder' => trans('products.name').'*','required'=>'required']) }}
    </div>
    <div class="col-3">
        <label for="sku">Stock Keeping Unit (SKU)</label>
        {{ Form::text('sku', null, ['class' => 'form-control']) }}
    </div>
    <div class="col-3">
        {{ Form::label( 'productcategory_id', trans('products.productcategory_id'),['class' => 'control-label']) }}
        <select class="custom-select" name="productcategory_id" id="product_category_id">
            @foreach($product_categories as $item)
                @if (!$item->c_type)
                    <option value="{{$item->id}}" {{ $item->id == @$product->productcategory_id ? 'selected' : '' }}>
                        {{$item->title}}
                    </option>
                @endif
            @endforeach
        </select>
    </div>
    <div class="col-3">
        {{ Form::label('unit', 'Base Unit', ['class' => 'control-label']) }}
        <select class="custom-select" name="unit_id" id="unit">
            <option value="">-- Choose Base Unit --</option>
            @foreach($productvariables as $item)
                @if ($item->unit_type == 'base')
                    <option value="{{ $item->id }}" {{ $item->id == @$product->unit_id ? 'selected' : '' }} >
                        {{ $item->code }} ({{ $item->title }})
                    </option>
                @endif
            @endforeach
        </select>
    </div>


</div>
<div class="row form-group">
    <div class="col-6">
        {{ Form::label('product_des', trans('products.product_des'),['class' => 'control-label']) }}
        {{ Form::textarea('product_des', null, ['class' => 'form-control col', 'rows'=>2, 'placeholder' => trans('products.product_des')]) }}
    </div>

    <div class="col-3">
    {{ Form::label('name', trans('products.product_serial'),['class' => 'control-label']) }}
    {{ Form::text('product_serial', @$product['product_serial'], ['class' => 'form-control box-size']) }}
    </div>

    <div class="col-3">
        {{ Form::label('expiry', "Has expiry?",['class' => 'control-label']) }}
        {{ Form::checkbox('expiry', null, ['class' => 'form-control col']) }}
    </div>

</div>
<div class="row form-group">
    <div class="col-md-4">
        <div class='form-group'>
            {{ Form::label( 'Selling Price', "Recommended Selling Price",['class' => 'col control-label']) }}
            <div class='col'>
                {{ Form::text('recommended_selling_price', numberFormat(@$product->standard['price']), ['class' => 'form-control box-size', 'placeholder' => trans('products.price'),'onkeypress'=>"return isNumber(event)"]) }}
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class='form-group'>
            {{ Form::label( 'price', "Minimum selling price",['class' => 'col control-label']) }}
            <div class='col'>
                {{ Form::text('minimum_selling_price', numberFormat(@$product->standard['price']), ['class' => 'form-control box-size', 'placeholder' => trans('products.price').'*','required'=>'required','onkeypress'=>"return isNumber(event)"]) }}
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class='form-group'>
            {{ Form::label('alert', 'Qty Alert Limit',['class' => 'col control-label']) }}
            <div class='col'>
                {{ Form::number('alert', numberFormat(@$product->standard['alert']), ['class' => 'form-control box-size', 'placeholder' => trans('products.alert'),'onkeypress'=>"return isNumber(event)"]) }}
            </div>
        </div>
    </div>
</div>
<div class="row" id="location-row">
    <div class="col-md-4">
        <div class="form-group">
            {{ Form::label( 'productcategory_id', trans('products.warehouse_id'),['class' => 'col control-label']) }}
            <div class='col' id="warehouse-n">
                <select class="custom-select warehouse_id" name="warehouse_id" id="warehouse_id">
                    @foreach($warehouses as $item)
                        <option value="{{$item->id}}" {{ $item->id == @$product->standard->warehouse_id ? "selected" : "" }}>
                            {{$item->title}}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            {{ Form::label( 'productcategory_id', 'Warehouse Row',['class' => 'col control-label']) }}
            <div class='col' id="warehouse-row-n">
                <select class="custom-select warehouse_row_id" name="warehouse_row_id" id="warehouse_row_id">
                </select>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            {{ Form::label( 'productcategory_id', 'Warehouse shelf',['class' => 'col control-label']) }}
            <div class='col' id="warehouse-shelf-n">
                <select class="custom-select warehouse_shelf_id" name="warehouse_shelf_id" id="warehouse_shelf_id">
                </select>
            </div>
        </div>
    </div>
</div>

<hr class="mb-3">
<h4>Combining products</h4>

<div class="row form-group raw-class" id="raw_id">
    {{-- <div class="old_id"><input type="hidden" name="v_id[]" value="{{@$product->standard['id']}}"><input type="hidden" name="pv_id" value="{{@$product->standard['id']}}"></div> --}}
    {{-- <div class="product"> --}}
        <div class="col-3">
            {{ Form::label('unit', "Product",['class' => 'control-label']) }}
            {{-- {{ Form::text('raw_material', null, ['class' => 'form-control']) }} --}}
            <select class="custom-select" name="raw_material[]" id="raw_material_id" required>
                @foreach($products as $product)
                        <option value="{{$product->id}}">
                            {{$product->name}}
                        </option>
                @endforeach
            </select>
        </div>
        <br>
        <div class="col-3">
            {{-- <label for="brand">Brand</label> --}}
            {{ Form::label('unit', "Quantity",['class' => 'control-label']) }}
            {{ Form::number('raw_material_quantity[]', null, ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="col-3">
            {{-- <label for="brand">Brand</label> --}}
            {{ Form::label('unit', "Minimum Selling Price",['class' => 'control-label']) }}
            {{ Form::number('price[]', null, ['class' => 'form-control', 'required' => 'required' ,'disabled'=> 'disabled']) }}
        </div>
        <div class="col-2">
            <span class="del_b"></span>
        </div>
    {{-- </div> --}}
</div>


<div id="added_product"></div>
<button class="btn btn-blue add_more btn-sm m-1">{{trans('general.add_row')}}</button>
<div id="remove_variation"></div>

@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    const config = {
        ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        datepicker: {
            autoHide: true,
            format: "{{config('core.user_date_format')}}"
        },
    };

    const Form = {
        units: @json($products),

        init() {
            $.ajaxSetup(config.ajax);
            $('#warehouse_id').click(this.fetchWarehouseRowsForInventory);
            $('#warehouse_row_id').click(this.fetchWarehouseShelvesForInventory);

            const events = [".add_more", ".v_delete_temp"];
            const handlers = [this.addMore, this.delProduct];
            events.forEach((v,i) => $(document).on('click', v, handlers[i]));
        },
        fetchWarehouseRowsForInventory(e){
            e.preventDefault();
            var warehouse_id = $('#warehouse_id').val();
            // console.log(warehouse_id);
            $.ajax({
                url:"{{ route('biller.get.warehouse-rows.for.inventory') }}",
                type: 'GET',
                quietMillis: 50,
                data:{warehouse_id :warehouse_id},
                success:function(data){
                    // console.log(data.length);

                    if(data.length === 0){
                        $('select[id="warehouse_row_id"]').empty();
                        $('select[id="warehouse_row_id"]')
                                .append('<option value="'+"n/a"+'">' + "No row in this warehouse." + '</option');
                    }else{
                        $('select[id="warehouse_row_id"]').empty();
                        $.each(data, function(key, values){
                            $('select[id="warehouse_row_id"]')
                                .append('<option value="'+values.id+'">' + values.row_number + '</option');
                        });
                    }
                }
            });

        },
        fetchWarehouseShelvesForInventory(e){
            e.preventDefault();
            var warehouse_row_id = $('#warehouse_row_id').val();
            var warehouse_id = $('#warehouse_id').val();
            $.ajax({
                url:"{{ route('biller.get.warehouse-shelves.for.inventory') }}",
                type: 'GET',
                quietMillis: 50,
                data:{warehouse_row_id :warehouse_row_id, warehouse_id:warehouse_id },
                success:function(data){

                    if(data.length === 0){
                        $('select[name="warehouse_shelf_id"]').empty();
                        $('select[name="warehouse_shelf_id"]')
                                .append('<option value="'+"n/a"+'">' + "No shelf in this warehouse row." + '</option');
                    }else{
                        $('select[name="warehouse_shelf_id"]').empty();
                        $.each(data, function(key, values){
                            $('select[name="warehouse_shelf_id"]')
                                .append('<option value="'+values.id+'">' + values.shelf_number + '</option');
                        });
                    }
                }
            });

        },

        addMore(e) {
            e.preventDefault();
            var product_details = $('#raw_id').clone().find(".old_id input:hidden").val(0).end();
            // var product_details = $('#raw_id').clone().end();
            product_details.find(".del_b").append('<button class="btn btn-danger v_delete_temp m-1 align-content-end"><i class="fa fa-trash"></i> </button>').end();
            $('#added_product').append(product_details);
            $('.datepicker').datepicker(config.datepicker);
        },
        delProduct(e) {
            e.preventDefault();
            $(this).closest('div .raw-class').remove();
        },

    };

    $(() => Form.init());
</script>
@endsection
