<div class='form-group'>
    {{ Form::label( 'paper_width', 'Paper Size',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        <select name="paper_width_id" id="paper_width" class="form-control" data-placeholder="Search Paper Size">
            <option value="">Search Paper Size</option>
            @foreach ($paper_width as $width)
                <option value="{{ $width->id }}" {{$width->id == @$papers->paper_width_id ? 'selected': ''}}>{{ $width->name }}</option>
            @endforeach
        </select>
    </div>
</div>
<div class='form-group'>
    {{ Form::label( 'gsm', 'GSM',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        <select name="gsm_id" id="gsm" class="form-control" data-placeholder="Search GSM">
            <option value="">Search GSM</option>
            @foreach ($gsm as $g)
                <option value="{{ $g->id }}" {{$g->id == @$papers->gsm_id ? 'selected': ''}}>{{ $g->name }}</option>
            @endforeach
        </select>
    </div>
</div>
<div class='form-group'>
    {{ Form::label( 'supplier', 'Supplier',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        <select name="supplier_id" id="supplierbox" class="form-control" data-placeholder="Search supplier">
            <option value="">Search Supplier</option>
            @foreach ($suppliers as $supplier)
                <option value="{{$supplier->id}}" {{$supplier->id == @$papers->supplier_id ? 'selected': ''}}>{{$supplier->name}}</option>
            @endforeach
        </select>
        {{-- <input type="hidden" name="supplier_id" id="supplierid"> --}}
    </div>
</div>
<div class="form-group">
    <div class="col-lg-10">
        {{ Form::label( 'price', 'Paper price',['class' => 'control-label']) }}
        {{ Form::text( 'price', null,['class' => 'col-lg-10 form-control', 'placeholder'=>'0.00']) }}
    </div>
</div>
<div class="form-group">
    <div class="col-lg-10">
        {{ Form::label( 'ledger', 'Select Ledger',['class' => 'control-label']) }}
        <select name="ledger_id" id="ledger_id" class="custom-select ledger">
            <option value="">-- Select Subcategory Account --</option>
            @foreach ($account->subledgers as $row)
                <option value="{{ $row->id }}" {{ $row->id == @$papers->ledger_id? 'selected' : '' }}>
                    {{ $row->name }}
                </option>
            @endforeach
        </select>
    </div>
</div>
<div class='form-group'>
    {{ Form::label( 'uom', 'UOM',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        {{-- {{ Form::text('uom', null, ['class' => 'form-control round', 'placeholder' => 'UOM']) }} --}}
        <select name="unit_id" id="unit-id" class="form-control" data-placeholder="Select UoM">
            @foreach ($productvariables as $unit)
                @if ($unit->unit_type == 'base')
                    <option value="{{ $unit->id }}" {{ $unit->id == @$papers->unit_id ? 'selected' : '' }} >
                        {{ $unit->code }} ({{ $unit->title }})
                    </option>    
                @endif
            @endforeach
        </select>
    </div>
</div>

@section("extra-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
    $.ajaxSetup({ headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}});
    $('#gsm').select2();
    $('#paper_width').select2();
    $('#supplierbox').select2();
        //Put your javascript needs in here.
        //Don't forget to put `@`parent exactly after `@`section("after-scripts"),
        //if your create or edit blade contains javascript of its own
         // On searching supplier
    //  function select2Config(url, callback) {
    //     return {
    //         ajax: {
    //             url,
    //             dataType: 'json',
    //             type: 'POST',
    //             quietMillis: 50,
    //             data: ({term}) => ({q: term, keyword: term}),
    //             processResults: callback
    //         }
    //     }
    // }
    // $('#supplierbox').change(function() {
    //     const name = $('#supplierbox option:selected').text().split(' : ')[0];
    //     const [id, taxId] = $(this).val().split('-');
    //     $('#taxid').val(taxId);
    //     $('#supplierid').val(id);
    //     $('#supplier').val(name);
    //     let priceCustomer = '';
    //         $('#pricegroup_id option').each(function () {
    //             if (id == $(this).val())
    //             priceCustomer = $(this).val();
    //         });
            
    //         $('#pricegroup_id').val(priceCustomer);
    // });

    // // load suppliers
    // const supplierUrl = "{{ route('biller.suppliers.select') }}";
    // function supplierData(data) {
    //     return {results: data.map(v => ({id: `${v.id}-${v.taxid || ''}`, text: `${v.name} : ${v.email}`}))};
    // }
    // $('#supplierbox').select2(select2Config(supplierUrl, supplierData));
    
    // </script>
@endsection
