<div class='form-group'>
    {{ Form::label( 'paper_type', 'Paper Type',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        {{ Form::text('paper_type', null, ['class' => 'form-control round', 'placeholder' => 'Paper Type']) }}
    </div>
</div>
<div class='form-group'>
    {{ Form::label( 'name', 'Name',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        {{-- {{ Form::text('name', null, ['class' => 'form-control round', 'placeholder' => 'Name']) }} --}}
        <select name="name" id="paper-name" class="form-control" data-placeholder="Select Paper Name">
            @foreach ($paper_name as $name)
                <option value="{{ $name->id }}" {{ $name->id == @$paper_width->name ? 'selected' : '' }} >
                    {{ $name->name }}
                    </option>    
            @endforeach
        </select>
    </div>
</div>
<div class='form-group'>
    {{ Form::label( 'width', 'Width',['class' => 'col-lg-2 control-label']) }}
    <div class='col-lg-10'>
        {{ Form::text('width', null, ['class' => 'form-control round', 'placeholder' => 'Width']) }}
    </div>
</div>


@section("after-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        const config = {
            ajax: { headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        };
        const Form = {
            init() {
                $.ajaxSetup(config.ajax);
                $('#paper-name').select2();
            },
        };
        $(()=>Form.init());
    </script>
@endsection
