{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
      ajaxSetup: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
      date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
      select2: {allowClear: true},
     
  };

  const Form = {
      jobcard: @json(@$jobcards),

      init() {
         $.ajaxSetup(config.ajaxSetup);
          $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
          $('#customer').select2(config.select2);
          $('#bom').select2(config.select2);
          $('#process').select2(config.select2);
          $('#design').select2(config.select2);
          $('#flute').select2(config.select2);
          $('#flute_type').change(this.fluteChange);
          $('#type').change(this.typeChange);
          $('#filters').on('change','#lenght, #width, #height, #total_qty', this.calculateChange);
          $('#filters').on('change','#no_of_out, #no_of_chop', this.outChange);
          $('#filters').on('change','#reel_size', this.sizeChange);
          $('#filters').on('change','#total_width, #total_length', this.dieChange);
           $('#patternTbl').on('change', '.gsm_value',this.gsmChange);
           //$('#reel_size').change(this.reelChange)
           if (this.jobcard && this.jobcard.length) {
            if($('#type').val() == 'DIE'){
              $('#height').val(0);
              $('#height').attr('readonly', true);
              $('#lenght').val(0);
              $('#lenght').attr('readonly', true);
              $('#width').val(0);
              $('#width').attr('readonly', true);
              $('#total_width').attr('readonly', false);
              $('#total_length').attr('readonly', false);
            }else if($('#type').val() == 'RSC'){
              $('#height').attr('readonly', false);
              $('#lenght').attr('readonly', false);
              $('#width').attr('readonly', false);
              $('#total_width').attr('readonly', true);
              $('#total_length').attr('readonly', true);
            }
            //  $('#process').val('').trigger('change');
          }else{
            console.log($('#process').val());
           }

           // $('.gsm_value').on('change', this.gsmChange);
           //$('.gsm_value').change(this.gsmChange)
          //  console.log(this.jobcard);
      },

      dieChange() {
        let lenght = accounting.unformat($('#lenght').val());
        let width = accounting.unformat($('#width').val());
        let height = accounting.unformat($('#height').val());
        // let no_of_out = accounting.unformat($('#no_of_out').val());
        let total_qty = accounting.unformat($('#total_qty').val());
        var total_lenght = accounting.unformat($('#total_length').val());
        //flap
        let flap = parseInt((width+2) / 2);
        let total_flap = flap * 2;
        //total width(Breadth)
        let total_width = accounting.unformat($('#total_width').val());
        let no_of_out = accounting.unformat($('#no_of_out').val());
        //No of outs 
      //  let no_of_outs = parseInt(1600/total_width);
        //No of chops
        let no_of_chops = (total_qty/no_of_out);
        // $('#no_of_out').val(no_of_outs);
        $('#no_of_chop').val(no_of_chops);
        // $('#total_width').val(total_width);
        // $('#total_length').val(total_lenght);
        $('#flap').val(flap);
        // let size = (no_of_out*total_width);
        let size = (total_width+20) * no_of_out;
        //  console.log(size);
        $.ajax({
          method: "post",
          url: "{{route('biller.jobcards.get_reel_size')}}",
          data: {
            size: size
          },
          
          success: function (response) {
            $('#reel_size').val(response);
            // console.log(response);
            Form.reelChange(response);
          }
        });
      },

      typeChange() {
        // console.log($(this).val());
        if($(this).val() == 'DIE'){
          $('#height').val(0);
          $('#height').attr('readonly', true);
          $('#lenght').val(0);
          $('#lenght').attr('readonly', true);
          $('#width').val(0);
          $('#width').attr('readonly', true);
          $('#total_width').attr('readonly', false);
          $('#total_length').attr('readonly', false);
        }else if($(this).val() == 'RSC'){
          $('#height').attr('readonly', false);
          $('#lenght').attr('readonly', false);
          $('#width').attr('readonly', false);
          $('#total_width').attr('readonly', true);
          $('#total_length').attr('readonly', true);
        }
      },
      sizeChange(){
        $('#flute_type').change();
      },

      reelChange(reel_size){
        // let reel_size = $('.reel-size').val();
        // console.log(reel_size);
        $('#patternTbl tbody tr').each(function() {
            
            $(this).find('.reel').val(reel_size);
            $(this).find('.gsm_value').val(0);
            $(this).find('.meter').val(0);
            $(this).find('.tones').val(0);
            //Form.gsmChange();
        });
        $('#total_tones').val(0)
        $('#sheet_weight').val(0);
        // let reel_size = accounting.unformat($('.reel-size').val());
        let flap = accounting.unformat($('#flap').val());
        let height = accounting.unformat($('#height').val());
        let no_of_out = accounting.unformat($('#no_of_out').val());
        $('#patternTbl tbody tr td:has(input)').each(function(index, element) {
          // console.log(reel_size);
          // Access each td item within the current tr element
          // var item1 = $(this).find('td:eq(0)').text(); // Get the text content of the first td in this tr
          var item2 = $(this).find('input.reel').val(reel_size); // Get the text content of the second td in this t
          let crease_part1 = (2000-reel_size)/2;
          let crease_part2 = flap + crease_part1;
          let crease_part3 = 2 + crease_part1;
          let crease_part4 = flap;
          let sum_flap_height = accounting.unformat(height+(2*flap));
          $('#cpTbl tbody').find('.crease_part1').val(crease_part1);
          $('#cpTbl tbody').find('.crease_part2').val(crease_part2);
          $('#cpTbl tbody').find('.crease_part3').val(crease_part3);
          $('#cpTbl tbody').find('.crease_part4').val(crease_part4);
          $('#cpTbl tbody').find('.cp2_1').val(height);
          $('#cpTbl tbody').find('.cp2_2').val(accounting.unformat(flap*2));
          $('#cpTbl tbody').find('.cp3_1').val(sum_flap_height);
          if (no_of_out > 1) {
            $('#cpTbl tbody').find('.cp2_3').val(accounting.unformat(height));
            $('#cpTbl tbody').find('.cp2_4').val(accounting.unformat(flap*2));
            $('#cpTbl tbody').find('.cp3_2').val(sum_flap_height);
          }else{
            $('#cpTbl tbody').find('.cp2_3').val('FALSE');
            $('#cpTbl tbody').find('.cp2_4').val('FALSE');
            $('#cpTbl tbody').find('.cp3_2').val('FALSE');
          }
          if (no_of_out > 2) {
            $('#cpTbl tbody').find('.cp2_5').val(accounting.unformat(height));
            $('#cpTbl tbody').find('.cp2_6').val(accounting.unformat(flap*2));
            $('#cpTbl tbody').find('.cp3_3').val(sum_flap_height);
          }else{
            $('#cpTbl tbody').find('.cp2_5').val('FALSE');
            $('#cpTbl tbody').find('.cp2_6').val('FALSE');
            $('#cpTbl tbody').find('.cp3_3').val('FALSE');
          }

        });
      },

      gsmChange(){
        const el = $(this);
        const row = el.parents('tr:first')
        let gsm_value = accounting.unformat(row.find('.gsm_value').val());
        let reel = accounting.unformat(row.find('.reel').val());
        let total_length = accounting.unformat($('#total_length').val());
        let total_width = accounting.unformat($('#total_width').val());
        let no_of_chop = accounting.unformat($('#no_of_chop').val());
        let meter = 0;
        const get_id = row.find('.gsm_value').attr('id');
         if(get_id == 'gsm_value-1'){
          meter = (total_length/1000)*no_of_chop*1.36;
          accounting.unformat(row.find('.meter').val(meter))
         }else if(get_id == 'gsm_value-3'){
            meter = (total_length/1000)*no_of_chop*1.45;
            accounting.unformat(row.find('.meter').val(meter))
         }
         else{
            meter = (total_length/1000)*no_of_chop;
          // $('.meter').val(meter);
          accounting.unformat(row.find('.meter').val(meter))
         }
         let tone = (meter*gsm_value/1000)*(reel/1000/1000);
         accounting.unformat(row.find('.tones').val(tone));
        //  let sheet_weight = (total_width*total_length/1000000)*()
        // console.log(gsm_value,no_of_chop, total_length, meter);
        // $('#patternTbl tbody tr').each(function() {
        //     const row = $(this);
        //     const gsm_value = row.find('.gsm_value').val();
            // console.log(gsm_value);
        // });
        // Form.reelChange();
        Form.calTotal();
        Form.sheetWeightChange();
        
      },

      calcPatterns(){
        
      },

      sheetWeightChange(){
        let total_length = accounting.unformat($('#total_length').val());
        let total_width = accounting.unformat($('#total_width').val());
        let gsm_value0 = 0;
        let gsm_value1 = 0;
        let gsm_value2 = 0;
        let gsm_value3 = 0;
        let gsm_value4 = 0;
        $('#patternTbl tbody tr').each(function() {
            if (!$(this).find('.gsm_value').val()) return;
            gsm_value0 += accounting.unformat($(this).find('#gsm_value-0').val());
            gsm_value1 += accounting.unformat($(this).find('#gsm_value-1').val());
            gsm_value2 += accounting.unformat($(this).find('#gsm_value-2').val());
            gsm_value3 += accounting.unformat($(this).find('#gsm_value-3').val());
            gsm_value4 += accounting.unformat($(this).find('#gsm_value-4').val());
        });
        // console.log(gsm_value0, gsm_value1, gsm_value2, gsm_value3, gsm_value4);
        let sheet_weight = (total_length*total_width/1000000)*(gsm_value0+(gsm_value1*1.36)+gsm_value2+(gsm_value3*1.44)+gsm_value4);
        $('#sheet_weight').val(accounting.formatNumber(sheet_weight));
        // console.log('sheet weigth', accounting.unformat(sheet_weight));
      },

      calTotal(){
        let grandTotal = 0;
        $('#patternTbl tbody tr').each(function() {
            if (!$(this).find('.gsm_value').val()) return;
            const tones = accounting.unformat($(this).find('.tones').val());
            grandTotal += tones;
        });
        $('#total_tones').val(accounting.unformat(grandTotal))
      },

      calculateChange(){
        let lenght = accounting.unformat($('#lenght').val());
        let width = accounting.unformat($('#width').val());
        let height = accounting.unformat($('#height').val());
        // let no_of_out = accounting.unformat($('#no_of_out').val());
        let total_qty = accounting.unformat($('#total_qty').val());
        let no_of_out = accounting.unformat($('#no_of_out').val());
        var total_lenght = (lenght * 2) + (width * 2) + 40;
        //flap
        let flap = parseInt((width+2) / 2);
        let total_flap = flap * 2;
        //total width(Breadth)
        let total_width = accounting.unformat(height+total_flap);
        //No of outs 
      //  let no_of_outs = parseInt(1600/total_width);
        //No of chops
        let no_of_chops = (total_qty/no_of_out);
        // $('#no_of_out').val(no_of_outs);
        $('#no_of_chop').val(no_of_chops);
        $('#total_width').val(total_width);
        $('#total_length').val(total_lenght);
        $('#flap').val(flap);
        // let size = (no_of_out*total_width);
        let size = ((width+height+3)*no_of_out)+20;
        //  console.log(size);
        $.ajax({
          method: "post",
          url: "{{route('biller.jobcards.get_reel_size')}}",
          data: {
            size: size
          },
          
          success: function (response) {
            $('#reel_size').val(response);
            // console.log(response);
            Form.reelChange(response);
            // console.log(response);
          }
        });
  
      },

      outChange(){
        let no_of_out = accounting.unformat($('#no_of_out').val());
        let total_qty = accounting.unformat($('#total_qty').val());
        let type = $('#type').val();
        //No of chops
        let no_of_chops = (total_qty/no_of_out);
        $('#no_of_chop').val(no_of_chops);
        if(type == "RSC"){
          Form.calculateChange();
        }else if(type == "DIE"){
          Form.dieChange();
        }
      },

      fluteChange(){
        var flute_option = $(this).find('option:selected').val();
        if(flute_option == 'three')
        {
            $('#patternTbl tbody').html('');
            $('#patternTbl tbody').append(Form.pattern_three);
        }
        else
        {
            $('#patternTbl tbody').html('');
            $('#patternTbl tbody').append(Form.pattern_five);
        }
        // console.log(flute_option);
        const el = $(this);
        // console.log($('.reel-size').val());
        let reel_size = accounting.unformat($('.reel-size').val());
        let flap = accounting.unformat($('#flap').val());
        let height = accounting.unformat($('#height').val());
        let no_of_out = accounting.unformat($('#no_of_out').val());
        $('#patternTbl tbody tr td:has(input)').each(function(index, element) {
          // console.log(reel_size);
          // Access each td item within the current tr element
          // var item1 = $(this).find('td:eq(0)').text(); // Get the text content of the first td in this tr
          var item2 = $(this).find('input.reel').val(reel_size); // Get the text content of the second td in this t
          let crease_part1 = (2000-reel_size)/2;
          let crease_part2 = flap + crease_part1;
          let crease_part3 = 2 + crease_part1;
          let crease_part4 = flap;
          let sum_flap_height = accounting.unformat(height+(2*flap));
          $('#cpTbl tbody').find('.crease_part1').val(crease_part1);
          $('#cpTbl tbody').find('.crease_part2').val(crease_part2);
          $('#cpTbl tbody').find('.crease_part3').val(crease_part3);
          $('#cpTbl tbody').find('.crease_part4').val(crease_part4);
          $('#cpTbl tbody').find('.cp2_1').val(height);
          $('#cpTbl tbody').find('.cp2_2').val(accounting.unformat(flap*2));
          $('#cpTbl tbody').find('.cp3_1').val(sum_flap_height);
          if (no_of_out > 1) {
            $('#cpTbl tbody').find('.cp2_3').val(accounting.unformat(height));
            $('#cpTbl tbody').find('.cp2_4').val(accounting.unformat(flap*2));
            $('#cpTbl tbody').find('.cp3_2').val(sum_flap_height);
          }else{
            $('#cpTbl tbody').find('.cp2_3').val('FALSE');
            $('#cpTbl tbody').find('.cp2_4').val('FALSE');
            $('#cpTbl tbody').find('.cp3_2').val('FALSE');
          }
          if (no_of_out > 2) {
            $('#cpTbl tbody').find('.cp2_5').val(accounting.unformat(height));
            $('#cpTbl tbody').find('.cp2_6').val(accounting.unformat(flap*2));
            $('#cpTbl tbody').find('.cp3_3').val(sum_flap_height);
          }else{
            $('#cpTbl tbody').find('.cp2_5').val('FALSE');
            $('#cpTbl tbody').find('.cp2_6').val('FALSE');
            $('#cpTbl tbody').find('.cp3_3').val('FALSE');
          }

        });
      },

      pattern_five(){
        return `
        <tr>
							<td class="borders">Top Liner</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-0" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter" readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Top Liner">
						</tr>
						<tr>
							<td class="borders">Fluting 1</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-1" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter " readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Fluting 1">
						</tr>
						<tr>
							<td class="borders">Liner</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-2" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter" readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Liner">
						</tr>
						<tr class="fluting_2">
							<td class="borders">Fluting 2</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-3" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter" readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Fluting 2">
						</tr>
						<tr class="bottom_liner">
							<td class="borders">Liner</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-4" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter" readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Liner">
						</tr>
						<tr>
							<td class="borders">Total</td>
							<td class="borders"></td>
							<td class="borders"></td>
							<td class="borders"></td>
							<td class="borders"></td>
							<td class="borders"><input type="text" name="total_tones" id="total_tones" class="form-control" readonly></td>
						</tr> 
        `;
      },

      pattern_three(){
        return `
        <tr>
							<td class="borders">Top Liner</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-0" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter" readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Top Liner">
						</tr>
						<tr>
							<td class="borders">Fluting 1</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-1" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter " readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Fluting 1">
						</tr>
						<tr>
							<td class="borders">Liner</td>
							<td class="borders" width="15%"><input type="text" name="reel_size[]" id="reel" class="form-control reel" readonly he></td>
							<td class="borders" width="15%">
								<input type="text" name="gsm_value[]" id="gsm_value-2" class="form-control gsm_value">
							</td>
							<td class="borders" width="10%"><input type="text" name="kraft_liner[]" class="form-control" id="kraft"></td>
							<td class="borders" width="15%"><input type="text" name="meters[]" id="meter" class="form-control meter" readonly></td>
							<td class="borders" width="15%"><input type="text" name="tones[]" id="tones" class="form-control tones" readonly></td>
              <input type="hidden" name="liner_name[]" value="Liner">
						</tr>
        
        <tr>
            <td class="borders">Total</td>
            <td class="borders"></td>
            <td class="borders"></td>
            <td class="borders"></td>
            <td class="borders"></td>
            <td class="borders"><input type="text" name="total_tones" id="total_tones" class="form-control" readonly></td>
        </tr>
        `;
      },

  }

  $(() => Form.init());

</script>