@extends ('core.layouts.app')
@php
    // $header_title = trans('labels.backend.quotes.management');
    $is_pi = request('page') == 'pi';
    $task = request('task');
    // if ($is_pi) $header_title = 'Proforma Invoice Management';
@endphp

@section ('title', 'Job Card Management' . ' | ' . 'Edit')

@section('page-header')
    <h1>
        {{ 'Job Card Management' }}
        <small>Edit</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h4 class="content-header-title mb-0">Edit</h4>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        <div class="media-body media-right text-right">
                            @include('focus.jobcards.partials.jobcards-header-buttons')
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <div class="card-content">

                                <div class="card-body">
                                    @if ($task)
                                    {{ Form::model($jobcards, ['route' => ['biller.jobcards.store', $jobcards], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'post', 'id' => 'create-department']) }}


                                    <div class="form-group" id="filters">
                                        {{-- Including Form blade file --}}
                                        @include("focus.jobcards.form")
                                        <div class="edit-form-btn">
                                            {{ link_to_route('biller.jobcards.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                            {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-primary btn-md']) }}
                                            <div class="clearfix"></div>
                                        </div><!--edit-form-btn-->
                                    </div><!-- form-group -->

                                    {{ Form::close() }}
                                    @else
                                        {{ Form::model($jobcards, ['route' => ['biller.jobcards.update', $jobcards], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'PATCH', 'id' => 'edit-department']) }}

                                        <div class="form-group" id="filters">
                                            {{-- Including Form blade file --}}
                                            @include("focus.jobcards.form")
                                            <div class="edit-form-btn">
                                                {{ link_to_route('biller.jobcards.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                                {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                                <div class="clearfix"></div>
                                            </div><!--edit-form-btn-->
                                        </div><!--form-group-->

                                        {{ Form::close() }}
                                    @endif
                                </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('extra-scripts')
    @include('focus.jobcards.form-js')
@endsection