{{ Html::script('focus/js/select2.min.js') }}
{{ Html::script('core/app-assets/vendors/js/extensions/sweetalert.min.js') }}
<script>
    const config = {
        ajax: { headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"} },
        date: {format: "{{config('core.user_date_format')}}", autoHide: true}, 
        customerSelect2: {
            allowClear: true,
            ajax: {
                url: "{{ route('biller.customers.select') }}",
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({search: term}),
                processResults: result => {
                    return { results: result.map(v => ({text: `${v.company}`, id: v.id }))};
                }      
            },
        }
    };

    const Form = {
        payment: null,
        startDate: '',
        endDate: '',

        init() {
            $('table thead th').css({'padding': '5px 8px'});
            $('table tbody td').css({'border': 'none', 'padding': '5px 8px'});
            $.ajaxSetup(config.ajax);
            $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
            $('#person').select2(config.customerSelect2);
            $('#credit_id').select2(config.creditPaymentSelect2);

            // edit mode
            let payment = @json(@$invoice_payment);
            if (payment && payment.id) {
                Form.payment = payment;
                Form.handleEdit(payment);
            }
            $('form').on('change', '.check_all, .check_row', Form.checkRow);
            $('form').on('blur', '.row_amount', Form.rowAmountChange);
            $('#amount').on('blur', Form.amountChange);
            $('#person').change(Form.customerChange);
            $('#currency_id').change(Form.currencyChange);
            $('#search').click(Form.invoiceSearchClick);
            $('.confirm_submit').click(Form.confirmSubmit);

            // set currency rate
            $('#frx_rate').val($('#currency_id option:selected').attr('rate')*1);
        },

        handleEdit(pmt) {
            if (pmt.date) $('#date').datepicker('setDate', new Date(pmt.date));
            $('#person').attr('disabled', true);
            $('#currency_id').attr('disabled', true);
            const currency_rate = $('#currency_id option:selected').attr('rate')*1;
            if (currency_rate > 1) $('#currency_rate').attr('readonly', false);
            Form.calcTotal();
        },

        confirmSubmit() {
            const amount = accounting.unformat($('#amount').val());
            const allocatedTotal = accounting.unformat($('#allocated_ttl').val());
            if (amount > 0) {
                if (!$('.check_row:checked').length) {
                    swal({
                        title: 'Confirm Advance Payment',
                        text: 'Payment will be auto-applied to consequent invoices',
                        icon: "warning",
                        buttons: true,
                    }).then(confirm => confirm? $('input:submit').click() : null);
                } else if (allocatedTotal < amount) {
                    swal({
                        title: 'Confirm Payment',
                        text: 'Over paid amount will be auto-applied to consequent invoices',
                        icon: "warning",
                        buttons: true,
                    }).then(confirm => confirm? $('input:submit').click() : null);
                } else {
                    $('input:submit').click();
                }
            } else {
                $('input:submit').click();
            }
        },

        currencyChange() {
            const rate = $(this).find(':selected').attr('rate');
            if (rate == 1) $('#frx_rate').attr('readonly', true);
            else $('#frx_rate').attr('readonly', false);
            $('#frx_rate').val(rate);
            $('#person').change();
        },

        invoiceSearchClick() {
            Form.startDate = $('#start_date').val();
            Form.endDate = $('#end_date').val();
            $('#person').change();
        },

        customerChange() {
            $('#allocated_ttl').val('');
            $('#unallocated_ttl').val('');
            $('#due_ttl').val('');
            $('#invoicesTbl tbody tr').remove();
            if (this.value) {
                // fetch invoices
                let url = "{{ route('biller.invoices.select') }}?";
                let params = {
                    customer_id: this.value, 
                    start_date: Form.startDate, 
                    end_date: Form.endDate,
                    currency_id: $('#currency_id').val(),
                };
                params = new URLSearchParams(params).toString();
                $.get(url + params, data => {
                    data.forEach((v, i) => {
                        $('#invoicesTbl tbody').append(Form.renderInvoices(v));
                    });
                });
            }
        },

        renderInvoices(v) {
            const amount_received = (v.amount_received*1) + (v.amount_paid*1);
            return `
                <tr>
                    <td><input type="checkbox" class="check_row"></td>
                    <td>${v.due_date.split('-').reverse().join('-')}</td>
                    <td>${v.tid}</td>
                    <td>${v.note}</td>
                    <td>${accounting.formatNumber(v.total*1)}</td>
                    <td>${accounting.formatNumber(amount_received)}</td>
                    <td class="row_due">${accounting.formatNumber(v.amount_due*1)}</td>
                    <td width="15%"><input type="text" name="row_amount[]" class="form-control row_amount" disabled></td>
                    <input type="hidden" name="inv_id[]" value="${v.id}" disabled />
                </tr>
            `;
        },

        amountChange() {
            let amount = accounting.unformat(this.value);
            this.value = accounting.formatNumber(amount);
            Form.calcTotal();
        },

        checkRow() {
            const amount = accounting.unformat($('#unallocated_ttl').val());
            if ($(this).is('.check_row')) {
                const row = $(this).parents('tr');
                if ($(this).prop('checked')) {
                    row.find('.row_amount').attr('disabled', false);
                    row.find(':hidden').attr('disabled', false);
                    if (amount > 0) {
                        let due = accounting.unformat(row.find('.row_due').text());
                        if (due >= amount) due = amount;
                        row.find('.row_amount').val(accounting.formatNumber(due));
                    }
                } else {
                    row.find('.row_amount').val('').attr('disabled', true);
                    row.find(':hidden').attr('disabled', true);
                }
            } else {
                if ($(this).prop('checked')) {
                    $('#invoicesTbl tbody').find('.row_amount').each(function() { $(this).attr('disabled', false) });
                    $('#invoicesTbl tbody').find(':hidden').each(function() { $(this).attr('disabled', false) });
                    $('#invoicesTbl tbody').find('.check_row').prop('checked', true);
                    let amount = accounting.unformat($('#amount').val());
                    if (amount > 0) {
                        $('#invoicesTbl tbody tr').each(function() {
                            if (amount == 0) return; 
                            const row = $(this);
                            let due = accounting.unformat(row.find('.row_due').text());
                            if (due >= amount) due = amount;
                            row.find('.row_amount').val(accounting.formatNumber(due));
                            amount -= due;
                        });
                    }
                } else {
                    $('#invoicesTbl tbody').find('.row_amount').each(function() { $(this).val('').attr('disabled', true) });
                    $('#invoicesTbl tbody').find(':hidden').each(function() { $(this).attr('disabled', true) });
                    $('#invoicesTbl tbody').find('.check_row').prop('checked', false);
                }
            }
            Form.calcTotal();
        },

        rowAmountChange() {
            const row = $(this).parents('tr');
            const due = accounting.unformat(row.find('.row_due').text());
            const allocated = accounting.unformat(this.value);
            if (allocated > due) this.value = accounting.formatNumber(due);
            else this.value = accounting.formatNumber(this.value);
            Form.calcTotal();
        },

        calcTotal() {
            let totalDue = 0;
            let totalAllocated = 0;
            const amount = accounting.unformat($('#amount').val());
            $('#invoicesTbl tbody tr').each(function() {
                let due = accounting.unformat($(this).find('.row_due').text());
                totalDue += due;
                if ($(this).find(':checked').length) {
                    let allocated = accounting.unformat($(this).find('.row_amount').val());
                    totalAllocated += allocated;
                }
            });
            
            $('#allocated_ttl').val(accounting.formatNumber(totalAllocated));
            const unallocated = amount - totalAllocated;
            if (unallocated >= 0) $('#unallocated_ttl').val(accounting.formatNumber(unallocated));
            totalDue = totalDue - totalAllocated;
            $('#due_ttl').val(accounting.formatNumber(totalDue));
        }
    };    

    $(Form.init);
</script>
