<div class="row mb-1">
    <div class="col-6">
        <label for="customer" class="caption">Search Customer</label>
        <div class="input-group">
            <div class="input-group-addon"><span class="icon-file-text-o" aria-hidden="true"></span></div>
            <select id="person" name="customer_id" class="form-control select-box" data-placeholder="Search Customer" required>
                @isset ($invoice_payment)
                    <option value="{{ $invoice_payment->customer_id }}">{{ @$invoice_payment->customer->company }}</option>
                @endisset
            </select>
        </div>
    </div>

    <div class="col-2">
        <label for="date" class="caption">Date</label>
        <div class="input-group">
            {{ Form::text('date', null, ['class' => 'form-control datepicker', 'id' => 'date', 'required']) }}
        </div>
    </div>     

    <div class="col-2">
        <label>Currency Rate</label>
        <div class="row no-gutters">
            <div class="col-md-6">
                <select class="custom-select currency_id" name="currency_id" id="currency_id" required>
                    @foreach ($currencies as $row)
                        <option value="{{ $row->id }}" rate="{{ +$row->rate }}" {{ $row->id == @$invoice_payment->currency_id? 'selected' : '' }}>
                            {{ $row->code }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-6">
                {{ Form::text('frx_rate', null, ['class' => 'form-control', 'id' => 'frx_rate', 'readonly']) }}  
            </div>
        </div>
    </div> 

    <div class="col-2">
        <label for="payment_mode">Mode</label>
        <select name="doc_reference" id="doc_reference" class="custom-select" required>
            <option value="">-- Select Mode --</option>
            @foreach (['eft', 'rtgs','cash', 'mpesa', 'cheque'] as $val)
                <option value="{{ $val }}" {{ $val == @$invoice_payment->doc_reference? 'selected' : '' }}>
                    {{ strtoupper($val) }}
                </option>
            @endforeach
        </select>
    </div>  
</div> 

<div class="form-group row">  
    
    <div class="col-6">
        <label for="note">Note</label>    
        {{ Form::text('note', null, ['class' => 'form-control', 'id' => 'note']) }}
    </div>  
   
    <div class="col-2">
        <label for="reference" class="caption">Reference No.</label>
        {{ Form::text('reference', null, ['class' => 'form-control', 'id' => 'reference', 'required']) }}
    </div>  

    <div class="col-2">
        <label for="account">Cash Account</label>
        <select name="ledger_id" id="account" class="custom-select" required>
            <option value="">-- Select Account --</option>
            @foreach ($accounts as $row)
                <option value="{{ $row->id }}" {{ $row->id == @$invoice_payment->ledger_id? 'selected' : '' }}>
                    {{ $row->name }}
                </option>
            @endforeach
        </select>
    </div>  

    <div class="col-2">
        <label for="amount" class="caption">Amount</label>
        {{ Form::text('amount', @$invoice_payment? numberFormat($invoice_payment->amount) : null, ['class' => 'form-control', 'id' => 'amount', 'required']) }}
    </div> 
</div>
<br>

<div class="table-responsive">
    @if (empty(@$invoice_payment))
        <div class="row no-gutters">
            <div class="col-md-1">Invoice Date Filter</div>
            @php
                $now = date('d-m-Y');
                $start = date('d-m-Y', strtotime("{$now} - 3 months"));
            @endphp
            <div class="col-md-1 mr-1">
                <input type="text" value="{{ $start }}" id="start_date" class="form-control form-control-sm datepicker">
            </div>
            <div class="col-md-1 mr-1">
                <input type="text" value="{{ $now }}" id="end_date" class="form-control form-control-sm datepicker">
            </div>
            <div class="col-md-1">
                <input type="button" name="search" id="search" value="Search" class="btn btn-info btn-sm">
            </div>
        </div>
    @endif
    <br>

    <div class="table-responsive">
        <table class="table tfr my_stripe_single" id="invoicesTbl">
            <thead>
                <tr class="bg-gradient-directional-blue white">
                    <th><input type="checkbox" class="check_all ml-2" {{ @$invoice_payment && $invoice_payment->items->count()? 'checked' : '' }}></th>
                    <th>Due Date</th>
                    <th>Invoice No</th>
                    <th>Note</th>
                    <th>Amount</th>
                    <th>Received</th>
                    <th>Due</th>
                    <th width="10%">Allocated</th>
                </tr>
            </thead>
            <tbody>                   
                @isset ($invoice_payment)
                    @foreach ($invoice_payment->items as $row)
                        @if ($row->invoice)
                            <tr>
                                <td><input type="checkbox" class="check_row" checked></td>
                                <td>{{ dateFormat($row->invoice->due_date) }}</td>
                                <td>{{ $row->invoice->tid }}</td>
                                <td>{{ $row->invoice->note }}</td>
                                <td>{{ numberFormat($row->invoice->total) }}</td>
                                <td>{{ numberFormat(0) }}</td>
                                <td class="row_due">{{ numberFormat($row->invoice->total) }}</td>
                                <td><input type="text" name="row_amount[]" value="{{ numberFormat($row->amount)  }}" class="form-control row_amount"></td>
                                <input type="hidden" name="inv_id[]" value="{{ $row->invoice_id }}" />
                                <input type="hidden" name="id[]" value="{{ $row->id }}" />
                            </tr>
                        @endif
                    @endforeach
                @endisset      
            </tbody>                
        </table>
    </div>
</div>

<div class="row">
    <div class="col-2 ml-auto">
        <label for="allocated_total">Total Allocated</label>
        {{ Form::text('allocated_total', null, ['class' => 'form-control', 'id' => 'allocated_ttl', 'readonly']) }}
    </div>
</div>
<div class="row">
    <div class="col-2 ml-auto">
        <label for="unallocated_total">Total Unallocated</label>
        {{ Form::text('unallocated_total', null, ['class' => 'form-control', 'id' => 'unallocated_ttl', 'readonly']) }}
    </div>
</div>

<div class="row">
    <div class="col-2 ml-auto">
        <label for="due_total">Total Due</label>
        {{ Form::text('due_total', null, ['class' => 'form-control', 'id' => 'due_ttl', 'disabled']) }}
    </div>
</div>
<div class="form-group row mt-1">                            
    <div class="col-12">  
        <button type="button" class="btn btn-primary btn-lg float-right confirm_submit">
            {{ @$invoice_payment? 'Update Payment' : 'Receive Payment' }}
        </button>
        {{ Form::submit('submit', ['class' =>'d-none']) }}
    </div>
</div>

@section('after-scripts')
@include('focus/invoice_payments/form_js')
@endsection
