@extends ('core.layouts.app')

@section ('title', 'Delivery Note Management' . ' | ' . 'view')

@section('page-header')
    <h1>
        {{ 'Delivery Note Management' }}
        <small>{{ 'view' }}</small>
    </h1>
@endsection

@section('content')
    <div class="">
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-6 col-12 mb-2">
                    <h3 class="content-header-title mb-0">View DNOTE</h3>

                </div>
                <div class="content-header-right col-md-6 col-12">
                    <div class="media width-250 float-right">

                        {{-- <div class="media-body media-right text-right">
                            @include('focus.delivery_notess.partials.delivery_notess-header-buttons')
                        </div> --}}
                    </div>
                </div>
            </div>
            <div class="content-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                @php
                                $dn = $delivery_notes;
                                $valid_token = token_validator('', 'dn' . $dn->id, true);
                                $link = route('biller.print_delivery_note', [$dn->id, 16, $valid_token, 1]);
                            @endphp
                            <a href="{{ $link }}" class="btn btn-purple btn-sm" target="_blank">
                                <i class="fa fa-print" aria-hidden="true"></i> Print
                            </a>
                            </div>

                            <div class="card-content">

                                <div class="card-body">


                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Delivery Note No.</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{gen4tid('DN-',$delivery_notes['tid'])}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Customer</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{@$delivery_notes->customer['company']}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Date</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{dateFormat($delivery_notes['date'])}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Item Type</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{$delivery_notes['item_type']}}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                            <p>Description</p>
                                        </div>
                                        <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                            <p>{{$delivery_notes['description']}}</p>
                                        </div>
                                    </div>


                                </div>

                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr class="item_header bg-gradient-directional-blue white ">
                                                <th width="15%" class="text-center">Product Name</th>
                                                <th width="10%" class="text-center">Box/Bundle</th>
                                                <th width="10%" class="text-center">No. Of Bundles</th>
                                                
                                                <th width="10%" class="text-center">Total Qty</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            {{-- {{dd($delivery_notes)}} --}}
                                            @foreach ($delivery_notes->items as $item)
                                                <tr class="text-center">
                                                    <td>{{$item->name}}</td>
                                                    <td>{{$item->box_bundle}}</td>
                                                    <td>{{$item->no_of_bundle}}</td>
                                                    
                                                    <td>{{+$item->total_qty}}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    </div>
@endsection
@section('extra-scripts')
{{ Html::script('focus/js/select2.min.js') }}
<script type="text/javascript">
    config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}},
        date: {format: "{{ config('core.user_date_format')}}", autoHide: true},
        
    };

    const Form = {
        requestDispatch: @json(@$delivery_notes),
        rowIds: 0,
        tableRow: $('#requisitionTbl tbody tr:first').html(),
        stockUrl: "{{ route('biller.products.waste_search') }}",
        jobcardUrl: "{{ route('biller.products.jobcard_search') }}",

        init() {
            $.ajaxSetup(config.ajax);
            $('#employee').select2({allowClear: true});
            $('.datepicker').datepicker(config.date);
           
            
            
        },
       
    };

    $(() => Form.init());
</script>
@endsection