@extends ('core.layouts.app')

@section ('title', 'Client Product Pricelist')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Client Product Pricelist</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.client_products.partials.clientproducts-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <table class="table table-bordered table-sm">
                                @php
                                    $details = [ 
                                        'Customer' => $client_product->customer? $client_product->customer->company : '',
                                        'Contract' => $client_product->contract,
                                        'Row Number' => $client_product->row_num,
                                        'Product Description' => $client_product->descr,
                                        'UoM' => $client_product->uom,
                                        'Rate' => numberFormat($client_product->rate),
                                    ];
                                @endphp
                                @foreach ($details as $key => $val)
                                <tr>
                                    <th>{{ $key }}</th>
                                    <td>{{ $val }}</td>
                                </tr>
                                @endforeach
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection