@extends ('core.layouts.app')
@section ('title', 'Bill Of Materials')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h3 class="content-header-title">Bill Of Materials</h3>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.bom.partials.bom-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-header">
                            @php
                                $bo = $bom;
                                $valid_token = token_validator('', 'bo' . $bo->id, true);
                                $link = route('biller.print_bom', [$bo->id, 13, $valid_token, 1]);
                            @endphp
                            <a href="{{ $link }}" class="btn btn-purple btn-sm" target="_blank">
                                <i class="fa fa-print" aria-hidden="true"></i> Print
                            </a>
                            <a href="#" class="btn btn-warning btn-sm mr-1" data-toggle="modal" data-target="#statusModal">
                                <i class="fa fa-pencil" aria-hidden="true"></i>Approval Status
                            </a>
                        </div>
                        <div class="card-body">
                            <div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Name
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                       {{$bom->title}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Reference Number
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ gen4tid('BOM-',$bom->tid) }}
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        JobCard Number
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                       {{$bom->bom_jobcard ? $bom->bom_jobcard->jobcard_no : ''}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Customer Name
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        @php
                                            $customer = '';
                                            if ($bom->bom_jobcard) {
                                                $jobcard = $bom->bom_jobcard->customer;
                                                if($jobcard){
                                                    $customer = $jobcard->company;
                                                }
                                            }
                                        @endphp
                                       {{$customer}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Amount
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ numberFormat($bom->total_bom) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Created on
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ dateFormat($bom->created_at) }}</div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Description
                                    </div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{ $bom->description }}</div>
                                </div>
                            </div>
                            {{-- <div class="container"> --}}
                                <br><br>
                                <div class="content-header-left col-6">
                                    <h4 class="content-header-title">Bill of Material Items</h4>
                                </div>
                                <br><br>
                                <table class="table table-bordered">
                                    <thead>
                                        <th>#</th>
                                        <th>Product</th>
                                        <th>Quantity</th>
                                        <th>Unit Of Measure</th>
                                        <th>Unit Cost</th>


                                    </thead>
                                    <tbody>
                                        @foreach ($bom->bom_items as $k => $item)
                                            <tr>
                                                <td>{{$k+1}}</td>
                                                <td>{{$item->product}}</td>
                                                <td>{{NumberFormat($item->product_quantity)}}</td>
                                                <td>{{$item->uom}}</td>
                                                <td>{{NumberFormat($item->purchase_price)}}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            {{-- </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('focus.bom.partials.approval')
</div>
@endsection
