@extends ('core.layouts.app')
@php
    // $header_title = trans('labels.backend.quotes.management');
    $is_pi = request('page') == 'pi';
    $task = request('task');
    // if ($is_pi) $header_title = 'Proforma Invoice Management';
@endphp

@section ('title', 'Bill of Materials')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Bill of Materials</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.bom.partials.bom-header-buttons')
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            @if ($task)
                            {{ Form::model($bom,['route' => ['biller.bom.store', $bom], 'method' => 'post', 'id' => 'create-bom']) }}
                                @include("focus.bom.form")
                                <div class="edit-form-btn">
                                    {{ link_to_route('biller.bom.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                    {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-primary btn-md']) }}
                                    <div class="clearfix"></div>
                                </div>
                                {{ Form::close() }}
                            @else
                                {{ Form::model($bom, ['route' => ['biller.bom.update', $bom], 'class' => 'form-horizontal', 'role' => 'form', 'method' => 'PATCH', 'id' => 'edit-bom']) }}
                                    @include("focus.bom.form")
                                    <div class="edit-form-btn">
                                        {{ link_to_route('biller.bom.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                        {{ Form::submit(trans('buttons.general.crud.update'), ['class' => 'btn btn-primary btn-md']) }}
                                        <div class="clearfix"></div>
                                    </div>
                                {{ Form::close() }}
                            @endif
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra-scripts')
    @include('focus.bom.edit_js')
@endsection