<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    {{-- <meta http-equiv="X-UA-Compatible" content="ie=edge"> --}}
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Product Bar Codes</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
</head>

@php
$loop_count = 0;
$qty=1;
$stickers_in_one_row=1;
$is_continuous=1;
$stickers_in_one_sheet=null;
$paper_height=0.000;
$height=1.9;
$paper_width=1.97;
$left_margin=0.00;
$top_margin=0.00;
$width=1.97;
$col_distance=0;
$row_distance=0;
$generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();
@endphp

<style>
 .text-center{
		text-align: center;
	}

	.text-uppercase{
		text-transform: uppercase;
	}

	/*Css related to printing of barcode*/
	.label-border-outer{
	    border: 0.1px solid grey !important;
	}
	.label-border-internal{
	    /*border: 0.1px dotted grey !important;*/
	}
	.sticker-border{
	    border: 0.1px dotted grey !important;
	    overflow: hidden;
	    box-sizing: border-box;
	}
	#preview_box{
	    padding-left: 30px !important;
	}
	@media print{
	    .content-wrapper{
	      border-left: none !important; /*fix border issue on invoice*/
	    }
	    .label-border-outer{
	        border: none !important;
	    }
	    .label-border-internal{
	        border: none !important;
	    }
	 
	    #preview_box{
	        padding-left: 0px !important;
	    }
	    #toast-container{
	        display: none !important;
	    }
	    .tooltip{
	        display: none !important;
	    }
	    .btn{
	    	display: none !important;
	    }
	}

	@media print{
		#preview_body{
			display: block !important;
		}
	}
	@page {
		size: {{$paper_width}}in @if(!$is_continuous && $paper_height != 0){{$paper_height}}in @endif;


		margin-top: 0in;
		margin-bottom: 0in;
		margin-left: 0in;
		margin-right: 0in;
		
		@if($is_continuous)
			/*page-break-inside : avoid !important;*/
		@endif
	}
  </style>
<body>
            



@foreach ($productsToPrint as $k => $v)

		@php
			$loop_count += 1;
			$is_new_row = ($stickers_in_one_row == 1 || ($loop_count % $stickers_in_one_row) == 1) ? true : false;
 
			$is_new_paper = ($is_continuous && $is_new_row) || (!$is_continuous && ($loop_count % $stickers_in_one_sheet == 1));

			$is_paper_end = (($is_continuous && ($loop_count % $stickers_in_one_row == 0)) || (!$is_continuous && ($loop_count % $stickers_in_one_sheet == 0)));

			
		@endphp

		@if($is_new_paper)
			{{-- Actual Paper --}}
			<div style="@if(!$is_continuous) height:{{$paper_height*0.95}}in !important; @else height:{{$height*0.95}}in !important; @endif width:{{$paper_width}}in !important; line-height: 16px !important; page-break-after: always;" class="@if(!$is_continuous) label-border-outer @endif">

			{{-- Paper Internal --}}
			<div style="@if(!$is_continuous)margin-top:{{$top_margin}}in !important; margin-bottom:{{$top_margin}}in !important; margin-left:{{$left_margin}}in !important;margin-right:{{$left_margin}}in !important;@endif" class="label-border-internal">
		@endif

		@if((!$is_continuous) && ($loop_count % $stickers_in_one_sheet) <= $stickers_in_one_row)
			@php $first_row = true @endphp
		@elseif($is_continuous && ($loop_count <= $stickers_in_one_row) )
			@php $first_row = true @endphp
		@else
			@php $first_row = false @endphp
		@endif

    



		<div style="height:{{$height}}in !important; line-height: {{$height}}in; width:{{$width*0.97}}in !important; display: inline-block; @if(!$is_new_row) margin-left:{{$col_distance}}in !important; @endif @if(!$first_row)margin-top:{{$row_distance}}in !important; @endif" class="text-center">
		<div style="display:inline-block;vertical-align:middle;line-height:16px !important;">
			{{-- Business Name --}}
      <br/>
		
				
		

			{{-- Product Name --}}
      <span style="display: block !important;font-size:7pt">
      HIL
      </span>
	
				<span style="display: block !important;font-size:7pt">
					{{$v['name']}}
				</span>
		

			{{-- Variation --}}
	
				<span style="display: block !important;font-size:7pt">
					<b>SKU</b>:{{$v['sku']}}
				</span>
				
		

	

			<br>
			{{-- Barcode --}}

     


			<img class="center-block" style="max-width:65%; !important;height: {{$height*0.24}}in !important;" src="data:image/png;base64,{{ base64_encode($generatorPNG->getBarcode($v['sku'], $generatorPNG::TYPE_CODE_128)) }}">

		</div>
		</div>

		@if($is_paper_end)
			{{-- Actual Paper --}}
			</div>

			{{-- Paper Internal --}}
			</div>
		@endif



@endforeach

@if(!$is_paper_end)
	{{-- Actual Paper --}}
	</div>

	{{-- Paper Internal --}}
	</div>
@endif


            
</body>
</html>
