@extends ('core.layouts.app')
@section('title', 'Material Issue Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Material Issue Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.assembly.material_issuing.partials.material-issuing-header-buttons')
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-header">
                            <h4 class="card-title">
                                <div class="container">
                                    {{ trans('products.general_product_details') }}
                                    <a href="{{ route('biller.material-issuing.edit', [$material_issuing['id']]) }}" class="btn btn-blue btn-outline-accent-5 btn-sm float-right">
                                        <i class="fa fa-pencil"></i> {{ trans('buttons.general.crud.edit') }}
                                    </a>

                                    <a href="{{ route('biller.material-issuing.print', [$material_issuing['id']]) }}" class="btn btn-blue btn-outline-accent-5 btn-sm float-right">
                                        <i class="fa fa-print"></i> Print
                                    </a>
                                </div>

                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="container">
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Assembly Station</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->assembly_station->name}}
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Items Issued</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->material_issuing_items->count()}}

                                    </div>
                                </div>
                                {{-- <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Total Amount</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->amount}}
                                    </div>
                                </div> --}}
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Warehouse</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->warehouse_station->title}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Time Issued</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{date('d-m-y', strtotime($material_issuing->created_at))}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Issued To(Edit)</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->assembly_station->name}}
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-3 border-blue-grey border-lighten-5  p-1">
                                        Issued By</div>
                                    <div class="col border-blue-grey border-lighten-5  p-1 font-weight-bold">
                                        {{$material_issuing->issued_by->first_name}} {{$material_issuing->issued_by->last_name}}
                                    </div>
                                </div>
                            </div>


                            <div class="container">
                                <br><br>
                                <div class="content-header-left col-6">
                                    <h4 class="content-header-title">Material Items Issued</h4>
                                </div>
                                <br><br>
                                <table class="table table-bordered">
                                    <thead>
                                        <th>#</th>
                                        <th>Item</th>
                                        <th>Quantity Issued</th>
                                        <th>UoM</th>
                                        {{-- <th>Unit Cost</th> --}}
                                        {{-- <th>Total Cost</th> --}}
                                    </thead>
                                    <tbody>
                                        @foreach ( $material_issuing['material_issuing_items'] as $mi)
                                            <tr>
                                                <td>{{$loop->iteration}}</td>
                                                <td>{{$mi->product->name}}</td>
                                                <td>{{$mi->quantity_issued}}</td>
                                                <td>{{$mi->unit_of_measure->title}}</td>
                                                {{-- <td>{{$mi->unit_cost}}</td> --}}
                                                {{-- <td>{{$mi->total_cost}}</td> --}}
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

