<div class="form-group row">
    <div class="col-3">
        <label for="tid">Issue No.</label>
        {{ Form::text('tid', @$material_issues['tid'],['class' => 'form-control', 'id' => 'tid', 'readonly']) }}
    </div>

    <div class="col-3">
        <label for="warehouse">Warehouse</label>
        <select class="form-control warehouse" name="warehouse_id" id="warehouse-0">
            @foreach ($warehouses as $warehouse)
                <option value="{{ $warehouse->id }}" {{@$warehouse->id == $material_issuing['station'] ? 'selected' : ''}}>
                    {{ $warehouse->title }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-3">
        <label for="date">Date of Issue</label>
        {{ Form::date('issue_date', @$material_issuing['issue_date'] ,['class' => 'form-control', 'id' => 'issue_date', '']) }}
    </div>

    <div class="col-3">
        <label for="tid">Select Assembly Station.</label>
        <select name="station" id="station" class="form-control" required>
            @foreach ($assembly_stations as $assembly_station)
                <option value="{{ $assembly_station->id }}" {{@$assembly_station->id == $material_issuing['station'] ? 'selected' : ''}}>
                    {{ $assembly_station->name }}
                </option>
            @endforeach
        </select>
    </div>
</div>

<div class="form-group row">
    <div class="col-12">
        {{ Form::label('Notes', null,['class' => 'control-label']) }}
        {{ Form::textarea('notes', @$material_issuing['notes'], ['class' => 'form-control col', 'rows'=>2, 'placeholder' => "Notes"]) }}
    </div>
</div>

<br>
<div class="table-responsive">
    <table class="table tfr my_stripe_single text-center" id="productsTbl">
        <thead>
            <tr class="item_header bg-gradient-directional-blue white ">
                <th width="20%" class="text-center">Product</th>
                <th width="10%" class="text-center">Actual Qty</th>
                <th width="10%" class="text-center">Issuing Qty</th>
                <th width="10%" class="text-center">UoM</th>
                <th width="10%" class="text-center">Unit Cost</th>
                <th width="10%" class="text-center">TotalCost</th>
                <th width="10%" class="text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ( $material_issuing['material_issuing_items'] as $mi)
            <tr>
                <td>
                    <select class="form-control product-name" name="product_id[]" id="product_id-0">
                        @foreach ($products as $product)
                            <option value="{{ $product->id }}" {{@$product->id == $mi['product_id'] ? 'selected' : ''}}>
                                {{ $product->name }}
                            </option>
                        @endforeach
                    </select>
                </td>
                <td><input type="text" class="form-control current-stock-quantity" name="current_stock_quantity[]" id="current_stock_quantity-0" readonly
                    value="{{round(\App\Models\product\ProductVariation::where('parent_id',$mi['product_id'] )->value('qty')) + $mi['quantity_issued'] }}">
                </td>
                <td><input type="number" class="form-control quantity_issued" name="quantity_issued[]" id="quantity_issuing-0" value="{{$mi['quantity_issued']}}"></td>
                <td>
                    <select name="uom[]" id="uom-0" class="form-control uom" required>
                        @foreach ($productvariables as $productvariable)
                            <option value="{{ $productvariable->id }}" {{@$productvariable->id == $mi['uom'] ? 'selected' : ''}}>
                                {{ $productvariable->title }}
                            </option>
                        @endforeach
                    </select>
                </td>
                <td><input type="text" class="form-control unit-cost" name="unit_cost[]" id="unit_cost-0" readonly value="{{$mi['unit_cost']}}"></td>
                <td><input type="text" class="form-control total-cost" name="total_cost[]" id="total_cost-0" readonly value="{{$mi['total_cost']}}"></td>
                <td>
                    <button type="button" class="btn btn-danger remove"><i class="fa fa-minus-square" aria-hidden="true"></i></button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<button type="button" class="btn btn-success" aria-label="Left Align" id="addProduct">
    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
</button>


<div class="form-group row">
    <div class="col-2 ml-auto">
        <label for="total">Total Amount</label>
        {{ Form::text('amount', @$material_issuing['amount'], ['class' => 'form-control', 'id' => 'total_amount', 'readonly']) }}
    </div>
</div>

@section("extra-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        $.ajaxSetup({ headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}});
        let tableRow = $('#productsTbl tbody tr:first').html();
    // $('#productsTbl tbody tr:first').remove();
    let rowIds = 0;
    $('#addProduct').click(function() {
        rowIds++;
        let i = rowIds;
        const html = tableRow.replace(/-0/g, '-'+i).replace(/d-none/g, '');
        $('#productsTbl tbody').append('<tr>' + html + '</tr>');
        // $('#productsTbl').on('change','.deduct', deduct);
    });
    $('#productsTbl').on('click', '.remove', removeRow);
    function removeRow() {
        const $tr = $(this).parents('tr:first');
        $tr.remove();
        calcStock();
    }

    let rowId = 0;
       $('#productsTbl').on('keyup','.quantity_issued', function() {
        const el = $(this);
        const row = el.parents('tr:first');
        const quantity = row.find('.quantity_issued').val();
        const stock_qty = row.find('.current-stock-quantity').val();

        const unit_cost = row.find('.unit-cost').val();
        row.find('.total-cost').val(quantity * unit_cost);
        calcStock();

        if(quantity > stock_qty){
            row.find('.quantity_issued').addClass('border-danger');
        }else{

        }
    });

    $('#productsTbl').on('change', '.product-name','.quantity_issued', function() {
        const el = $(this);
        const row = el.parents('tr:first');
        const product = row.find('.product-name').val();
        const quantity = row.find('.quantity_issued').val();

        $.ajax({
                url:"{{ route('biller.products.details.get') }}",
                type: 'GET',
                quietMillis: 50,
                data:{product :product},
                success:function(data){
                    row.find('.current-stock-quantity').val(accounting.unformat(data.qty));
                    row.find('.unit-cost').val(data.purchase_price);
                }
            });

    });
    function calcStock() {
        let grandTotal = 0;
        $('#productsTbl tbody tr').each(function() {
            if (!$(this).find('.current-stock-quantity').val()) return;
            const unit_cost = accounting.unformat($(this).find('.unit-cost').val());
            const qty = accounting.unformat($(this).find('.quantity_issued').val());
            // const rowtax = $(this).find('.rowtax').val()/100 + 1;

            const amount = qty * unit_cost;
            grandTotal += amount;
        });
        $('#total_amount').val(grandTotal);
    }

    // $('#productsTbl').on('load', '.product-name','.quantity_issued', function() {
    //     const el = $(this);
    //     const row = el.parents('tr:first');
    //     const product = row.find('.product-name').val();
    //     const quantity = row.find('.quantity_issued').val();

    //     $.ajax({
    //             url:"{{ route('biller.products.details.get') }}",
    //             type: 'GET',
    //             quietMillis: 50,
    //             data:{product :product},
    //             success:function(data){
    //                 row.find('.current-stock-quantity').val(accounting.unformat(data.qty));
    //                 row.find('.unit-cost').val(data.purchase_price);
    //             }
    //         });
    // });

    </script>
@endsection
