@extends ('core.layouts.app')

{{-- @section ('title', trans('labels.backend.products.management')) --}}
@section ('title','Assembly Station Operators Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-2">
        <div class="content-header-left col-6">
            {{-- <h4 class="content-header-title">{{ trans('labels.backend.products.management') }}</h4> --}}
            <h4 class="content-header-title">Assembly Station Operators Management</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.assembly.assembly_station_operator.partials.aso-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-4">
                                <label for="warehouse" class="text-primary h4">Date</label>
                                {{ Form::date('date', null,['class' => 'form-control', 'id' => 'date_id', '']) }}
                            </div>
                            <div class="col-4">
                                <label for="category" class="text-primary h4">Assembly Station</label>
                                <select name="station" id="station_id" class="custom-select">
                                    <option value="">-- select category --</option>
                                    @foreach ($stations as $station)
                                        <option value="{{ $station->id }}">{{ $station->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-4">
                                <label for="status" class="text-primary h4">Operator</label>
                                <select name="operator" id="operator_id" class="custom-select">
                                    <option value="">-- select status --</option>
                                    @foreach ($operators as $operator)
                                        <option value="{{ $operator->id }}">{{ $operator->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            <table id="productsTbl" class="table table-striped table-bordered zero-configuration" cellspacing="0" width="100%">
                                <thead>
                                        <th>#</th>
                                        <th>Date</th>
                                        <th>Station</th>
                                        <th>Operator</th>
                                        <th>Notes</th>
                                        {{-- <th>{{ trans('general.createdat') }}</th> --}}
                                        <th>{{ trans('labels.general.actions') }}</th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td colspan="100%" class="text-center text-success font-large-1">
                                            <i class="fa fa-spinner spinner"></i>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}" }}
    };

    const Index = {
        dateId: @json(request('date_id')),
        stationId: @json(request('station_id')),
        operatorId: @json(request('operator_id')),

        init() {
            this.drawDataTable();
            $('#date_id').val(this.dateId).change(this.dateChange);
            $('#station_id').val(this.stationId).change(this.stationChange);
            $('#operator_id').val(this.operatorId).change(this.operatorChange);
        },
        dateChange(){
            Index.dateId = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },
        stationChange(){
            Index.stationId = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },
        operatorChange(){
            Index.operatorId = $(this).val();
            $('#productsTbl').DataTable().destroy();
            return Index.drawDataTable();
        },


        drawDataTable() {
            $('#productsTbl').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.aso.get") }}',
                    type: 'post',
                    data: {
                        dateId: this.dateId,
                        stationId: this.stationId,
                        operatorId: this.operatorId,
                    },
                    dataSrc: ({data}) => {
                        $('.assembly-stations-count').text('0');
                        if (data.length && data[0].aggregate) {
                            const aggr = data[0].aggregate;
                            $('.assembly-stations-count').text(aggr.assembly_stations);
                        }
                        return data;
                    },
                },
                columns: [
                    {data: 'DT_Row_Index', name: 'id'},
                    {data: 'date', name: 'date'},
                    {data: 'station', name: 'station'},
                    {data: 'operator', name: 'operator'},
                    {data: 'notes', name: 'notes'},
                    // {data: 'location', name: 'location'},
                    // {data: 'qty', name: 'qty'},
                    // {data: 'unit', name: 'unit'},
                    // {data: 'purchase_price', name: 'purchase_price'},
                    // {data: 'total', name: 'total'},
                    // {data: 'created_at', name: 'created_at'},
                    {data: 'actions', name: 'actions', searchable: false, sortable: false}
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        },
    };

    $(() => Index.init());
</script>
@endsection
