<div class="form-group row">
    <div class="col-4">
        <label for="tid">Issue No.</label>
        {{ Form::text('tid',"ASNO".($assembled_products+1),['class' => 'form-control', 'id' => 'tid', 'readonly']) }}
    </div>

    <div class="col-4">
        <label for="Entry no">Entry No.</label>
        {{ Form::text('entry_no',null,['class' => 'form-control', 'id' => 'tid', 'required'])  }}
    </div>

    <div class="col-4">
        <label for="date">Date</label>
        {{ Form::date('assemble_date', null,['class' => 'form-control', 'id' => 'issue_date', 'required']) }}
    </div>

</div>
<div class="form-group row">
    <div class="col-12">
        {{ Form::label('Notes', null,['class' => 'control-label']) }}
        {{ Form::textarea('notes', null, ['class' => 'form-control col', 'rows'=>2, 'placeholder' => "Notes"]) }}
    </div>
</div>

<br>
<div class="table-responsive">
    <table class="table tfr my_stripe_single text-center" id="productsTbl">
        <thead>
            <tr class="item_header bg-gradient-directional-blue white ">
                <th class="text-center">Product</th>
                <th class="text-center">Current Qty</th>
                <th class="text-center">Assembled Qty</th>
                <th class="text-center">Final Qty</th>
                <th class="text-center">UoM</th>
                {{-- <th class="text-center">Unit Cost</th>
                <th class="text-center">TotalCost</th> --}}
                <th class="text-center">Action</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td width="30%">
                    <select class="form-control product-name" name="product_id[]" id="product_id-0">
                        {{-- @foreach ($products as $product)
                            <option value="{{ $product->id }}">
                                {{ $product->name }}
                            </option>
                        @endforeach --}}
                    </select>
                </td>
                <td><input type="text" class="form-control current-stock-quantity" name="current_stock_quantity[]" id="current_stock_quantity-0" readonly></td>
                <td><input type="number" class="form-control assembled_quantity" name="assembled_quantity[]" id="assembled_quantity-0"></td>
                <td><input type="number" class="form-control final_quantity" name="final_quantity[]" id="final_quantity-0"></td>
                <td width="10%">
                    <select name="uom[]" id="uom-0" class="form-control uom" required>
                        @foreach ($productvariables as $productvariable)
                            <option value="{{ $productvariable->id }}">
                                {{ $productvariable->title }}
                            </option>
                        @endforeach
                    </select>
                </td>
                {{-- <td><input type="text" class="form-control unit-cost" name="unit_cost[]" id="unit_cost-0" readonly></td> --}}
                {{-- <td><input type="text" class="form-control total-cost" name="total_cost[]" id="total_cost-0" readonly></td> --}}
                <td>
                    <button type="button" class="btn btn-danger d-none remove"><i class="fa fa-minus-square" aria-hidden="true"></i></button>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<button type="button" class="btn btn-success" aria-label="Left Align" id="addProduct">
    <i class="fa fa-plus-square"></i> {{trans('general.add_row')}}
</button>


<div class="form-group row">
    <div class="col-2 ml-auto">
        {{-- <label for="total">Total Amount</label>
        {{ Form::text('amount', null, ['class' => 'form-control', 'id' => 'total_amount', 'readonly']) }} --}}
    </div>
</div>

@section("extra-scripts")
{{ Html::script('focus/js/select2.min.js') }}
    <script type="text/javascript">
        $.ajaxSetup({ headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}"}});
        let tableRow = $('#productsTbl tbody tr:first').html();

        let rowIds = 0;
    $('#addProduct').click(function() {
        rowIds++;
        let i = rowIds;
        const html = tableRow.replace(/-0/g, '-'+i).replace(/d-none/g, '');
        $('#productsTbl tbody').append('<tr>' + html + '</tr>');

        const productsUrl = "{{ route('biller.products.select') }}";
        function productsData(data) {
            return {results: data.map(v => ({id: v.id, text: v.name}))};
        }
        $('#product_id-'+i).select2(select2Config(productsUrl, productsData));



    });
    $('#productsTbl').on('click', '.remove', removeRow);
    function removeRow() {
        const $tr = $(this).parents('tr:first');
        $tr.remove();
        // calcStock();
    }

    let rowId = 0;
       $('#productsTbl').on('keyup','.assembled_quantity', function() {
        const el = $(this);
        const row = el.parents('tr:first');
        const quantity = row.find('.assembled_quantity').val();
        const stock_qty = row.find('.current-stock-quantity').val();

        row.find('.final_quantity').val(parseInt(quantity) + parseInt(stock_qty));

        // const unit_cost = row.find('.unit-cost').val();
        // row.find('.total-cost').val(quantity * unit_cost);
        // calcStock();

    });


    const productsUrl = "{{ route('biller.products.select') }}";
    function productsData(data) {
        console.log(data);
        return {results: data.map(v => ({id: v.id, text: v.name}))};
    }
    $('#product_id-0').select2(select2Config(productsUrl, productsData));


    $('#productsTbl').on('change', '.product-name','.quantity_issued', function() {
        const el = $(this);
        const row = el.parents('tr:first');

        const product_id = row.find('.product-name').attr('id');
        console.log(product_id);

        const product = row.find('.product-name').val();
        const quantity = row.find('.quantity_issued').val();


        $.ajax({
                url:"{{ route('biller.products.details.get') }}",
                type: 'GET',
                quietMillis: 50,
                data:{product :product},
                success:function(data){
                    row.find('.current-stock-quantity').val(accounting.unformat(data.qty));
                    row.find('.unit-cost').val(data.purchase_price);
                }
            });

    });
    function calcStock() {
        let grandTotal = 0;
        $('#productsTbl tbody tr').each(function() {
            if (!$(this).find('.current-stock-quantity').val()) return;
            const unit_cost = accounting.unformat($(this).find('.unit-cost').val());
            const qty = accounting.unformat($(this).find('.quantity_issued').val());
            // const rowtax = $(this).find('.rowtax').val()/100 + 1;

            const amount = qty * unit_cost;
            grandTotal += amount;
        });
        $('#total_amount').val(grandTotal);
    }

    function select2Config(url, callback) {
        return {
            ajax: {
                url,
                dataType: 'json',
                type: 'POST',
                quietMillis: 50,
                data: ({term}) => ({q: term, keyword: term}),
                processResults: callback
            }
        }
    }

    $('.datepicker')
        .datepicker({format: "{{ config('core.user_date_format')}}", autoHide:true})
        .datepicker('setDate', new Date())

    // On searching supplier
    $('#warehouse').change(function() {
    const name = $('#warehouse option:selected').text().split(' : ')[0];
    // const [id, taxId] = $(this).val().split('-');
    // $('#taxid').val(taxId);
    // $('#supplierid').val(id);
    // $('#supplier').val(name);
    // let priceCustomer = '';
    //     $('#pricegroup_id option').each(function () {
    //         if (id == $(this).val())
    //         priceCustomer = $(this).val();
    //     });

    //     $('#pricegroup_id').val(priceCustomer);
    });

    //Load Warehouses
    const warehouseUrl = "{{ route('biller.warehouse.select') }}";
    function warehouseData(data) {
        return {results: data.map(v => ({id: v.id, text: v.title}))};
    }
    $('#warehouse').select2(select2Config(warehouseUrl, warehouseData));

    //Load Assembly Stations
    const assemblyStationsUrl = "{{ route('biller.stations.select') }}";
    function assemblyStations(data) {
        return {results: data.map(v => ({id: v.id, text: v.name}))};
    }
    $('#station').select2(select2Config(assemblyStationsUrl, assemblyStations));
    </script>
@endsection
