@extends ('core.layouts.app')

@section ('title', 'Assembled Products Management')

@section('content')
<div class="content-wrapper">
    <div class="content-header row mb-1">
        <div class="content-header-left col-6">
            <h4 class="content-header-title">Assembled Products</h4>
        </div>
        <div class="content-header-right col-6">
            <div class="media width-250 float-right">
                <div class="media-body media-right text-right">
                    @include('focus.assembly.assembled_product.partials.assembled-products-header-buttons')
                </div>
            </div>
        </div>
    </div>

    <div class="content-body">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-content">
                        <div class="card-body">
                            {{ Form::open(['route' => 'biller.assembled-products.store', 'method' => 'post', 'files' => true, 'id' => 'create-material-issuing']) }}
                                <div class="form-group">
                                    @include('focus.assembly.assembled_product.form')
                                    @if (@$input['rel_type'])
                                        {{ Form::hidden('rel_id', @$input['rel_id']) }}
                                        {{ Form::hidden('main', 0) }}
                                    @endif
                                    <div class="edit-form-btn ml-2">
                                        {{ link_to_route('biller.material-issuing.index', trans('buttons.general.cancel'), [], ['class' => 'btn btn-danger btn-md']) }}
                                        {{ Form::submit(trans('buttons.general.crud.create'), ['class' => 'btn btn-primary btn-md']) }}
                                    </div>
                                </div>
                            {{ Form::close() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
