@extends ('core.layouts.app')

@section('title', 'Assembled Products Report')

@section('content')
    <div class="content-wrapper">
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                {{-- <div class="col-3">
                                    <label for="warehouse" class="text-primary h4">Assembly Station</label>
                                    <select name="warehouse_id" id="station" class="custom-select">
                                        <option value="">-- select station --</option>
                                        @foreach ($stations as $station)
                                            <option value="{{ $station->id }}">{{ $station->name }}</option>
                                        @endforeach
                                    </select>
                                </div> --}}
                                <div class="col-3">
                                    <label for="category" class="text-primary h4">Product</label>
                                    <select name="product" id="product" class="custom-select">
                                        <option value="">-- select product --</option>
                                        @foreach ($products as $product)
                                            <option value="{{ $product->id }}">{{ $product->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                {{-- <div class="col-3">
                                    <label for="status" class="text-primary h4">Warehouse</label>
                                    <select name="warehouse" id="warehouse" class="custom-select">
                                        <option value="">-- select warehouse --</option>
                                        @foreach ($warehouses as $warehouse)
                                            <option value="{{ $warehouse->id }}">{{ $warehouse->title }}</option>
                                        @endforeach
                                    </select>
                                </div> --}}
                                <div class="col-3">
                                    <label for="status" class="text-primary h4">Date of Issue</label>
                                    {{ Form::date('assemble_date', null ,['class' => 'form-control', 'id' => 'assemble_date', '']) }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-content">
                            <div class="card-body">
                                <table id="materialIssuingReport"
                                    class="table table-striped table-bordered zero-configuration" cellspacing="0"
                                    width="100%">
                                    <thead>
                                        <tr>
                                            <th>Product</th>
                                            <th>Initial Qty</th>
                                            <th>Assembled Qty</th>
                                            <th>Unit Of Measure</th>
                                            <th>Currrent Qty</th>
                                            {{-- <th>Assembled At Station</th> --}}
                                            {{-- <th>Assembled By</th> --}}
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="100%" class="text-center text-success font-large-1">
                                                <i class="fa fa-spinner spinner"></i>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('after-scripts')
{{ Html::script(mix('js/dataTable.js')) }}
{{ Html::script('focus/js/select2.min.js') }}
<script>
    const config = {
        ajax: {headers: {'X-CSRF-TOKEN': "{{ csrf_token() }}" }}
    };

    const Index = {
        stationId: @json(request('station')),
        assembleDateId: @json(request('assemble_date')),
        warehouseId: @json(request('warehouse')),
        productId: @json(request('product')),

        init() {
            this.drawDataTable();
            $('#station').val(this.stationId).change(this.stationChange);
            $('#assemble_date').val(this.assembleDateId).change(this.dateChange);
            $('#warehouse').val(this.warehouseId).change(this.warehouseChange);
            $('#product').val(this.productId).change(this.productChange);
        },
        productChange(){
            Index.productId = $(this).val();
            $('#materialIssuingReport').DataTable().destroy();
            return Index.drawDataTable();
        },
        warehouseChange(){
            Index.warehouseId = $(this).val();
            $('#materialIssuingReport').DataTable().destroy();
            return Index.drawDataTable();
        },
        stationChange(){
            Index.stationId = $(this).val();
            $('#materialIssuingReport').DataTable().destroy();
            return Index.drawDataTable();
        },
        dateChange(){
            Index.assembleDateId = $(this).val();
            $('#materialIssuingReport').DataTable().destroy();
            return Index.drawDataTable();
        },
        drawDataTable() {
            $('#materialIssuingReport').dataTable({
                processing: true,
                serverSide: true,
                responsive: true,
                stateSave: true,
                language: {@lang('datatable.strings')},
                ajax: {
                    url: '{{ route("biller.reports.assembled-products.view") }}',
                    type: 'post',
                    data: {
                        // station: this.stationId,
                        assemble_date: this.assembleDateId,
                        // warehouse: this.warehouseId,
                        product: this.productId,
                    },
                },
                columns: [
                    {
                        data: 'product',
                        name: 'product'
                    },
                    {
                        data: 'initial_qty',
                        name: 'initial_qty'
                    },
                    {
                        data: 'assembled_qty',
                        name: 'assembled_qty'
                    },
                    {
                        data: 'final_qty',
                        name: 'final_qty'
                    },
                    {
                        data: 'uom',
                        name: 'uom'
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                ],
                order: [[0, "desc"]],
                searchDelay: 500,
                dom: 'Blfrtip',
                buttons: ['csv', 'excel', 'print']
            });
        },
    };

    $(() => Index.init());
</script>
@endsection
