<div class="form-group row">
    <div class="col-md-6">
        {{ Form::label('account_type', 'Account Type') }}
        <select name="ledger_type_id" class="custom-select" id="account_type" required>
            <option value="">-- Select Account Type --</option>
            @foreach ($account_types as $row)
                <option value="{{ $row->id }}" code="{{ $row->code }}">
                    {{ $row->name }}
                </option>
            @endforeach
        </select>
    </div>
    <div class="col-md-6">
        {{ Form::label('name', 'Account Name') }}
        {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => 'Ledger Account Name', 'required']) }}
    </div>
</div>
<div class="form-group row">
    <div class="col-md-12">        
        {{ Form::label('note', 'Account Description') }}
        {{ Form::text('note', null, ['class' => 'form-control', 'placeholder' => 'Account Description']) }}
    </div>
</div>
<div class="form-group row">
    <div class="col-md-3">
        {{ Form::label('is_manual', 'Account Usable In Manual Journal ?') }}
        <select name="is_manual" class="custom-select" id="is_manual">
            @foreach (['No', 'Yes'] as $k => $val) 
                <option value="{{ $k ?: null }}">
                    {{ $val }}
                </option>
            @endforeach
        </select>
    </div>
    
    <div class="col-md-3">
        {{ Form::label('is_subledger', 'Is A Subcategory Account?') }}
        <select class="custom-select" id="is_subcategory">
            @foreach (['No', 'Yes'] as $k => $val) 
                <option value="{{ $k ?: null }}">
                    {{ $val }}
                </option>
            @endforeach
        </select>       
    </div>

    <div class="col-md-6">       
        {{ Form::label('category', 'General Accounts') }}  
        <select name="ledger_id" class="custom-select" id="ledger_id" disabled>
            <option value="">-- Select Account Category --</option>
            @foreach ($main_accounts as $row)
                <option value="{{ $row->id }}" code="{{ @$row->account_type->code }}">
                    {{ $row->name }}
                </option>
            @endforeach
        </select>    
    </div>
</div>

@section('after-scripts')
<script>
    config = {
        ajax: {
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            }
        },
        date: {format: "{{ config('core.user_date_format') }}", autoHide: true},
    };

    const Form = {
        account: @json(@$account),

        init() {
            $.ajaxSetup(config.ajax);
            $('.datepicker').datepicker(config.date).datepicker('setDate', new Date());
            
            $('#is_subcategory').change(Form.isSubcategoryChange);
            $('#has_open_bal').change(Form.hasOpenBalanceChange);
            $('#account_type').change(Form.accountTypeChange);
            if (Form.account) Form.handleFormEdit(Form.account);
        },

        handleFormEdit(account) {
            $('#account_type').val(account.ledger_type_id).attr('selected', true);
            $('#is_manual').val(account.is_manual).attr('selected', true);
            if (account.ledger_id) {
                $('#is_subcategory').val(1).attr('selected', true);
                $('#ledger_id').val(account.ledger_id).attr({'selected': true, 'disabled': false, 'required': true});
            }
            $('#account_type').change();
        },

        accountTypeChange() {
            let accountTypeCode = $(this).find('option:selected').attr('code');
            $('#ledger_id option').each(function() {
                let code = $(this).attr('code');
                if (code == accountTypeCode) $(this).removeClass('d-none');
                else $(this).addClass('d-none');
            });
        },

        isSubcategoryChange() {
            if (this.value) {
                $('#ledger_id').val('').attr({'disabled': false, 'required': true});
            } else {
                $('#ledger_id').val('').attr({'disabled': true, 'required': false});
            }
        },

        hasOpenBalanceChange() {
            if (this.value) {
                $('#opening_bal').val('').attr({'disabled': false, 'required': true});
                $('#opening_bal_date').val('').attr({'disabled': false, 'required': true});
                $('#opening_bal_note').val('').attr({'disabled': false});
            } else {
                $('#opening_bal').val('').attr({'disabled': true, 'required': false});
                $('#opening_bal_date').val('').attr({'disabled': true, 'required': false});
                $('#opening_bal_note').val('').attr({'disabled': true});
            }
        },
    };

    $(Form.init);
</script>
@endsection