<?php

namespace App\Repositories\Focus\waste_management;

use App\Exceptions\GeneralException;
use App\Models\waste_management\WasteManagement;
use App\Models\waste_management\WasteManagementItems;
use App\Repositories\BaseRepository;
use DB;
use Illuminate\Support\Arr;


class WasteManagementRepository extends BaseRepository
{

    const MODEL = WasteManagement::class;

    public function getForDataTable()
    {
        $q = $this->query();

        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        // dd($input);
        $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['date']))
                $data[$key] = date_for_database($val);
        }
        $result = WasteManagement::create($data);

        $data_items = $input['data_items'];
        $data_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'waste_management_id' => $result->id, 
                'ins' => $result->ins,
                'user_id' => $result->user_id
            ]);
        }, $data_items);


        // dd($data_items);
        WasteManagementItems::insert($data_items);
        if ($result) {
            DB::commit();
            return $result;
        }

        throw new GeneralException('Error adding waste materials.');
    }
    public function update($waste_management, array $input)
    {
        DB::beginTransaction();
        $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['date']))
                $data[$key] = date_for_database($val);
        }
        
        $result = $waste_management->update($data);

        $data_items = $input['data_items'];
        // remove omitted items
        $item_ids = array_map(function ($v) { return $v['id']; }, $data_items);
        $waste_management->items()->whereNotIn('id', $item_ids)->delete();
        // dd($data_items);
        // create or update items
        foreach($data_items as $item) {
            
            $waste_management_item = WasteManagementItems::firstOrNew(['id' => $item['id']]);
            $waste_management_item->fill(array_replace($item, ['waste_management_id' => $waste_management['id'], 'ins' => $waste_management['ins'],'user_id' => $waste_management['user_id']]));
            // dd($waste_management_item);
            if (!$waste_management_item->id) unset($waste_management_item->id);
            $waste_management_item->save();
        }
        // WasteManagementItems::insert($data_items);

        if ($result) {
            DB::commit();
            return $waste_management;      
        }

        throw new GeneralException('Error updating waste materials.');
    }

    public function delete($waste_management)
    {
        DB::beginTransaction();
        WasteManagementItems::where('waste_management_id',$waste_management->id)->delete();
        // $waste_management->delete();
        // DB::commit();
        if($waste_management->delete()){
            DB::commit();
            return true;
        }

        throw new GeneralException('Error deleting waste products.');
    }
}
