<?php

namespace App\Repositories\Focus\warehouse_shelf;

use DB;
use Carbon\Carbon;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Models\warehouse_row\WareHouseRow;
use App\Models\warehouse_shelves\WarehouseShelf;

/**
 * Class WareHouseShelfRepository.
 */
class WareHouseShelfRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = WarehouseShelf::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {
        $q = $this->query();
        return $q->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        $input = array_map('strip_tags', $input);
        $warehouseShelf = WarehouseShelf::create([
            'warehouse_row_id' => $input['warehouse_row_id'],
            'shelf_number' => $input['shelf_number'],
            'extra' => $input['extra'],
            'length' => $input['length'],
            'width' => $input['width'],
            'height' => $input['height'],
            'ins' => $input['ins'],
        ]);

        if ($warehouseShelf) {
            return true;
        }
        throw new GeneralException(trans('exceptions.backend.warehouses.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Warehouse $warehouse
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(array $input, $id)
    {
        $input = array_map('strip_tags', $input);
        $warehouseShelf = WarehouseShelf::where('id', $id)->first();
        if ($warehouseShelf->update([
            'length' => $input['length'],
            'width' => $input['width'],
            'height' => $input['height'],
            'extra' => $input['extra'],
        ]))
            return true;

        throw new GeneralException(trans('exceptions.backend.warehouses.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Warehouse $warehouse
     * @throws GeneralException
     * @return bool
     */
    public function delete($id)
    {
        $warehouseShelf = WarehouseShelf::where('id', $id)->first();

        if ($warehouseShelf->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.warehouses.delete_error'));
    }
}
