<?php

namespace App\Repositories\Focus\warehouse_row;

use DB;
use Carbon\Carbon;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Models\warehouse_row\WareHouseRow;

/**
 * Class WareHouseRowRepository.
 */
class WareHouseRowRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = WareHouseRow::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable($id)
    {
        $q = $this->query();
        $q->with('wareHouseShelf');
        return $q->where('ware_house_id', $id)->get();

    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        $input = array_map('strip_tags', $input);
        // WareHouseRow::create([
        //     'ware_house_id' => $input['warehouse_id'],
        //     'row_number' => $input['row_number'],
        //     'extra' => $input['extra'],
        //     'ins' => $input['ins']
        // ]);
        if (WareHouseRow::create([
            'ware_house_id' => $input['warehouse_id'],
            'row_number' => $input['row_number'],
            'extra' => $input['extra'],
            'ins' => 1
        ])) {
            return true;
        }
        throw new GeneralException(trans('exceptions.backend.warehouses.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Warehouse $warehouse
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(array $input, $id)
    {
        $input = array_map('strip_tags', $input);
        $warehouseRow = WareHouseRow::where('id', $id)->first();
        if ($warehouseRow->update([
            'extra' => $input['extra'],
        ]))
            return true;

        throw new GeneralException(trans('exceptions.backend.warehouses.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param Warehouse $warehouse
     * @throws GeneralException
     * @return bool
     */
    public function delete($id)
    {
        $warehouseRow = WareHouseRow::where('id', $id)->first();

        if ($warehouseRow->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.warehouses.delete_error'));
    }
}
