<?php

namespace App\Repositories\Focus\stock_adjustment;

use DB;
use App\Exceptions\GeneralException;
use App\Models\account\Account;
use App\Models\invoice\Invoice;
use App\Models\items\InvoiceItem;
use App\Models\product\Product;
use App\Models\product_bin\ProductBin;
use App\Models\stock\StockIssuedItem;
use App\Models\stock_adjustment\StockAdjustment;
use App\Models\stock_adjustment\StockAdjustmentItem;
use App\Models\transaction\Transaction;
use App\Models\transactioncategory\Transactioncategory;
use App\Repositories\BaseRepository;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Arr;

/**
 * Class InvoiceRepository.
 */
class StockAdjustmentRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = StockAdjustment::class;
    public function getForDataTable()
    {
        $q = $this->query();

        return $q->get();
    }

    public function create(array $input)
    {
        // dd($input);
        $data = Arr::only($input, ['tid','notes','date','user_id','ins','item_type']);
        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'new_qty','uom']);
        $data_items = modify_array($data_items);
        
        $tid = StockAdjustment::max('tid');
        
        $data['tid'] = $tid + 1;
        $data['date'] = date_for_database($data['date']);
        // dd($data);

        DB::beginTransaction();

        $stockAdjustment = StockAdjustment::create($data);
        foreach ($data_items as $i => $item) {
            $data_items[$i] = array_replace($item, [
                'stock_adjustment_id' =>$stockAdjustment->id,
                'date' => $stockAdjustment->date,
                'ins' => $input['ins'],
                'user_id' => $input['user_id'],
            ]);
        }

        StockAdjustmentItem::insert($data_items);

        DB::commit();

        if ($stockAdjustment) return $stockAdjustment;

        throw new GeneralException('Error adjusting stock.');

    }

    public function update($stockAdjustment, array $input)
    {
        $data_items = Arr::only($input, ['product_id', 'current_stock_quantity', 'new_qty','uom','id']);
        $data_items = modify_array($data_items);
        foreach($input as $key => $val){
            if (in_array($key, ['date']))
                $input[$key] = date_for_database($val);
        }
        // dd($data_items);

        DB::beginTransaction();

        $stockAdjustment->update($input);
        // remove omitted items
        $item_ids = array_map(function ($v) { return $v['id']; }, $data_items);
        $stockAdjustment->items()->whereNotIn('id', $item_ids)->delete();

        // create or update items
        foreach($data_items as $item) {
            foreach ($item as $key => $val) {
                if (in_array($key, ['current_stock_quantity', 'new_qty']))
                    $item[$key] = floatval(str_replace(',', '', $val));
            }
            $stock_item = StockAdjustmentItem::firstOrNew(['id' => $item['id']]);
            $stock_item->fill(array_replace($item, ['stock_adjustment_id' => $stockAdjustment['id'],
             'ins' => $stockAdjustment['ins'],
             'date' => $stockAdjustment->date,
             'ins' => $input['ins'],
             'user_id' => $input['user_id']
            ]));
            if (!$stock_item->id) unset($stock_item->id);
            $stock_item->save();
        }

        DB::commit();

        if ($stockAdjustment) return $stockAdjustment;

        throw new GeneralException('Error adjusting stock.');
    }

    public function delete(Invoice $invoice)
    {
        // dd($invoice);

        // throw new GeneralException(trans('exceptions.backend.charges.delete_error'));
    }

}
