<?php

namespace App\Repositories\Focus\shop;

use App\Exceptions\GeneralException;
use App\Models\shops\Shop;
use App\Repositories\BaseRepository;
use DB;

class ShopRepository extends BaseRepository
{

    const MODEL = Shop::class;

    public function getForDataTable()
    {
        $q = $this->query();
        return $q->get();
    }

    public function create(array $input)
    {
        DB::beginTransaction();
        $shop = Shop::create($input);
        DB::commit();

       if ($shop) return $shop;

        throw new GeneralException('Error creating shop.');
    }
    public function update($shop, array $input)
    {

        DB::beginTransaction();
        $shop->update($input);

        DB::commit();

       if ($shop) return $shop;

        throw new GeneralException('Error updating car shop.');
    }

    public function delete($shop)
    {
        if ($shop->delete()) {
            return true;
        }

        throw new GeneralException('Error deleting shop.');

        // DB::beginTransaction();

        // $brand->delete();
        // DB::commit();

        // throw new GeneralException('Error deleting brand.');
    }
}
