<?php

namespace App\Repositories\Focus\request_quotation;

use DB;
use Carbon\Carbon;
use App\Models\request_quotation\RequestQuotation;
use App\Models\request_quotation\RequestQuotationItem;
use App\Models\request_quotation\RequestQuotationSupplier;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;

/**
 * Class request_quotationRepository.
 */
class RequestQuotationRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = RequestQuotation::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

        return $this->query()
            ->get();
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        DB::beginTransaction();
        $data = $input['data'];
        // dd($data['bom_status']);
        foreach ($data as $key => $value) {
            if(in_array($key, ['date', 'due_date']))
                $data[$key] = date_for_database($value);
        }
        $result = RequestQuotation::create($data);
       
        // bom line items
        $data_items = $input['data_items'];
        $data_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'request_quotation_id' => $result->id, 
                'ins' => $result->ins,
                'user_id' => $result->user_id,
            ]);
        }, $data_items);
        RequestQuotationItem::insert($data_items);
        $process_items = $input['process_items'];
        $process_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'request_quotation_id' => $result->id, 
                'ins' => $result->ins,
                'user_id' => $result->user_id,
            ]);
        }, $process_items);
        RequestQuotationSupplier::insert($process_items);
        if ($result) {
            DB::commit();
            return $result;
        }

        throw new GeneralException('Error creating RFQ.');
    }

    /**
     * For updating the respective Model in storage
     *
     * @param request_quotation $request_quotation
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update(RequestQuotation $request_quotation, array $input)
    {
        DB::beginTransaction();
        $data = $input['data'];
        foreach ($data as $key => $value) {
            if(in_array($key, ['date', 'due_date']))
                $data[$key] = date_for_database($value);
        }  
        $result = $request_quotation->update($data);

        $data_items = $input['data_items'];
        //dd($data_items);
        // remove omitted items
        $request_quotation_id = array_map(function ($v) { 
            // dd($v);
            return $v['id']; }, $data_items);
        $request_quotation->items()->whereNotIn('id', $request_quotation_id)->delete();
        // dd($request_quotation->id);
        // create or update items
        foreach($data_items as $item) {
            $request_quotation_item = RequestQuotationItem::firstOrNew(['id' => $item['id']]);         
            $request_quotation_item->fill(array_replace($item, [
                'request_quotation_id' => $request_quotation->id,
                
            ]));
            //dd($request_quotation_item);
            if (!$request_quotation_item->id) unset($request_quotation_item->id);
            unset($request_quotation_item->id);
            $request_quotation_item->save();
        }
        $process_items = $input['process_items'];
        //  dd($process_items);
        RequestQuotationSupplier::whereNotIn('supplier_id', $process_items)->where('request_quotation_id', $request_quotation->id)->whereNotNull('supplier_id')->delete();
        foreach($process_items as $item) {
            
            RequestQuotationSupplier::updateOrCreate(
                ['supplier_id' => $item['supplier_id'], 'request_quotation_id' => $request_quotation->id, 'ins'=> $request_quotation->ins],
                ['supplier_id' => $item['supplier_id'], 'request_quotation_id' => $request_quotation->id, 'ins'=> $request_quotation->ins]
            );
            //dd($item['supplier_id']);
        }

        if ($result) {
            DB::commit();
            return $request_quotation;      
        }

        throw new GeneralException('Error updating Bill of Materials.');
    }

    /**
     * For deleting the respective model from storage
     *
     * @param request_quotation $request_quotation
     * @throws GeneralException
     * @return bool
     */
    public function delete(RequestQuotation $request_quotation)
    {
        if ($request_quotation->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.request_quotations.delete_error'));
    }
}
