<?php

namespace App\Repositories\Focus\request_dispatch;

use DB;
use Carbon\Carbon;
use App\Models\request_dispatch\RequestDispatch;
use App\Models\request_dispatch\RequestDispatchItem;
use App\Exceptions\GeneralException;
use App\Repositories\BaseRepository;
use Illuminate\Database\Eloquent\Model;
use App\Models\dispatch\Dispatch;
use App\Models\dispatch\DispatchItem;
use App\Models\dispatch\DispatchCategory;


/**
 * Class RequestDispatchRepository.
 */
class RequestDispatchRepository extends BaseRepository
{
    /**
     * Associated Repository Model.
     */
    const MODEL = RequestDispatch::class;

    /**
     * This method is used by Table Controller
     * For getting the table data to show in
     * the grid
     * @return mixed
     */
    public function getForDataTable()
    {

        $q = $this->query();
        return $q;
    }

    /**
     * For Creating the respective model in storage
     *
     * @param array $input
     * @throws GeneralException
     * @return bool
     */
    public function create(array $input)
    {
        // dd($input);
        DB::beginTransaction();
        $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['date']))
                $data[$key] = date_for_database($val);
        }
        $result = RequestDispatch::create($data);
        //Create Line items
        $data_items = $input['data_items'];
        $data_items = array_map(function ($v) use($result) {
            return array_replace($v, [
                'request_dispatch_id' => $result->id, 
                'ins' => $result->ins,
                'user_id' => $result->user_id,
                'total_qty' =>  floatval(str_replace(',', '', $v['total_qty'])),
                'balance_instock' => floatval(str_replace(',', '', $v['balance_instock'])),
                'datetime' => datetime_for_database($v['datetime']),
            ]);
        }, $data_items);
        RequestDispatchItem::insert($data_items);
        if ($result) {
            DB::commit();
            return $result;
        }
        // dd($data_items);
        throw new GeneralException(trans('exceptions.backend.departments.create_error'));
    }

    /**
     * For updating the respective Model in storage
     *
     * @param Department $department
     * @param  $input
     * @throws GeneralException
     * return bool
     */
    public function update($request_dispatch, array $input)
    {
        DB::beginTransaction();
        $data = $input['data'];
        foreach ($data as $key => $val) {
            if (in_array($key, ['date']))
                $data[$key] = date_for_database($val);
        }
        $result = $request_dispatch->update($data);
        $data_items = $input['data_items'];
        foreach ($data_items as $i => $item) {
            // $request_dispatch_item = RequestDispatchItem::find($item['id']);
            // $request_dispatch_item->update($item);
            $request_dispatch_item = RequestDispatchItem::firstOrNew(['id' => $item['id']]);
            if (!$request_dispatch_item) throw ValidationException::withMessages(['Request Dispatch item does not exist!']);
            $request_dispatch_item->fill(array_replace($item, ['request_dispatch_id' => $request_dispatch['id'], 'ins' => $request_dispatch['ins']]));
            if (!$request_dispatch_item->id) unset($request_dispatch_item->id);
            $request_dispatch_item->save();
        }

        if ($result) {
            DB::commit();
            return $request_dispatch;      
        }


        throw new GeneralException(trans('exceptions.backend.request_dispatchs.update_error'));
    }

    /**
     * For deleting the respective model from storage
     *
     * @param request_dispatch $request_dispatch
     * @throws GeneralException
     * @return bool
     */
    public function delete(RequestDispatch $request_dispatch)
    {
        if ($request_dispatch->delete()) {
            return true;
        }

        throw new GeneralException(trans('exceptions.backend.request_dispatchs.delete_error'));
    }

    public function approve(array $input)
    {
        DB::beginTransaction();
        // dd($input);
        $data = $input['data'];
        $request_dispatch = RequestDispatch::find($data['id']);
        unset($data['id']);
        // dd($data);
        $result = $request_dispatch->update($data);
        foreach ($request_dispatch->items as $i => $item) {
            // dd($item);
            if($item->type == 'waste'){
                $waste = $item->waste;
                if($waste->qty > $item->total_qty){
                    $waste->decrement('qty', $item->total_qty);
                    $item->checked_by = $request_dispatch->checked_by;
                    $item->approved_by = $request_dispatch->approved_by;
                    $item->update();
                    // dd($item);
                    
                }else{
                    throw ValidationException::withMessages(['Amend Request Dispatch item!']);
                }
            }else if($item->type == 'jobcard')
            {
                
                $jobcard = $item->jobcard;
                if($jobcard)
                {
                    // dd($jobcard, $item);
                    $qty_remains = $jobcard->net_qty-$jobcard->dispatched_qty;
                    if($qty_remains > $item->total_qty)
                    {
                        $jobcard->increment('dispatched_qty', $item->total_qty);
                        $item->checked_by = $request_dispatch->checked_by;
                        $item->approved_by = $request_dispatch->approved_by;
                        $item->update();
                        $count = $jobcard->dispatch->count()+1;
                        $dispatch_name = ordinal($count).' Dispatch';
                        $dispatch = [
                            'jobcard_id' => $jobcard->id,
                            'dispatch_name'=>$dispatch_name,
                            'request_dispatch_id' =>$request_dispatch->id
                        ];
                        $dispatch_result = Dispatch::create($dispatch);
                        $dispatch_arr = [
                            'box_bundle' => $item->box_bundle, 
                            'no_of_bundle' => $item->no_of_bundle, 
                            'total_qty' => $item->total_qty, 
                            'dnote_id' => $item->dnote_id, 
                            'datetime' => $item->datetime, 
                            'balance_instock' => $item->balance_instock, 
                            'checked_by' => $item->checked_by, 
                            'approved_by' => $item->approved_by, 
                          ];
                          $dispatch_category = DispatchCategory::all();
                          $dispatch_items = [];
                          foreach ($dispatch_category as $key => $category) {

                              foreach (array_keys($dispatch_arr) as $k) {
                                    if($k == $category->type){
                                        $dispatch_items[] = [
                                            'dispatch_id' =>$dispatch_result['id'],
                                            'dispatch_category_id' => $category->id,
                                            'dispatch_value' => $dispatch_arr[$k],
                                            'user_id'=> auth()->user()->id,
                                            'ins' => auth()->user()->ins
                                        ];
                                        // dd($dispatch_arr[$k]);
                                    }
                                }
                          }
                            // dd($k);
                            
                        // dd($jobcard, $item, $dispatch_arr, $dispatch_result, array_keys($dispatch_arr), $dispatch_items);
                        DispatchItem::insert($dispatch_items);
                    }else{
                        throw ValidationException::withMessages(['Amend Request Dispatch item!']);
                    
                    }
                }
            }
        }
        if ($result) {
            DB::commit();
            return $result;
        }
    }
}
